/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeEntityService;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.UserUtils;
import org.apache.commons.lang3.ArrayUtils;

public class MergeStatusService {
    private static final Log logger = LogFactory.getLog(MergeStatusService.class);

    private MergeStatusService() {
    }

    public static MergeStatusService getInstance() {
        return new MergeStatusService();
    }

    public MergeData loadMergeData(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        String orgNumber = orgNode.getNumber();
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "=", (Object)orgNumber);
        DynamicObject[] mcs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name", (QFilter[])qcf.toArray());
        List<Long> mergeControlIds = Arrays.stream(mcs).map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> stageMergeControlMap = this.loadStageMergeControl(mergeControlIds, false);
        return this.buildMergeData(orgNode, new ArrayList<DynamicObject>(Arrays.asList(mcs)), false, null, stageMergeControlMap);
    }

    public MergeData loadMergeDataByCurrencyNumber(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId, String currencyNumber) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        String orgNumber = orgNode.getNumber();
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "=", (Object)orgNumber);
        DynamicObject[] mcs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name", (QFilter[])qcf.toArray());
        List<Long> mergeControlIds = Arrays.stream(mcs).map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> stageMergeControlMap = this.loadStageMergeControl(mergeControlIds, false);
        return this.buildMergeData(orgNode, new ArrayList<DynamicObject>(Arrays.asList(mcs)), true, currencyNumber, stageMergeControlMap);
    }

    public MergeData getMergeData(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        String orgNumber = orgNode.getNumber();
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "=", (Object)orgNumber);
        DynamicObjectCollection mcs = QueryServiceHelper.query((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name", (QFilter[])qcf.toArray());
        List<Long> mergeControlIds = mcs.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> stageMergeControlMap = this.loadStageMergeControl(mergeControlIds, true);
        return this.buildMergeData(orgNode, (List<DynamicObject>)mcs, false, null, stageMergeControlMap);
    }

    public MergeData getMergeDataByCurrencyNumber(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId, String currencyNumber) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        String orgNumber = orgNode.getNumber();
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "=", (Object)orgNumber);
        DynamicObjectCollection mcs = QueryServiceHelper.query((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name", (QFilter[])qcf.toArray());
        List<Long> mergeControlIds = mcs.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> stageMergeControlMap = this.loadStageMergeControl(mergeControlIds, true);
        return this.buildMergeData(orgNode, (List<DynamicObject>)mcs, true, currencyNumber, stageMergeControlMap);
    }

    private MergeData buildMergeData(IDNumberTreeNode orgNode, List<DynamicObject> dynList, boolean isManual, String currencyNumber, Map<Long, List<DynamicObject>> stageMergeControlMap) {
        String pcCurrency;
        String ecCurrency = orgNode.getCurrency();
        if (isManual) {
            if (currencyNumber == null) {
                throw new KDBizException("Currency is null");
            }
            pcCurrency = currencyNumber;
        } else {
            pcCurrency = orgNode.getParent() != null ? orgNode.getParent().getCurrency() : ecCurrency;
        }
        DynamicObject ecData = null;
        DynamicObject pcData = null;
        ArrayList<DynamicObject> allConvertList = new ArrayList<DynamicObject>(10);
        if (dynList != null) {
            for (DynamicObject dyn : dynList) {
                if (Objects.equals(ecCurrency, dyn.getString("currencynumber"))) {
                    ecData = dyn;
                } else {
                    allConvertList.add(dyn);
                }
                if (!Objects.equals(pcCurrency, dyn.getString("currencynumber"))) continue;
                pcData = dyn;
            }
        }
        return new MergeData(ecData, pcData, allConvertList, orgNode, stageMergeControlMap);
    }

    private Map<Long, List<DynamicObject>> loadStageMergeControl(List<Long> mergeControlIds, boolean isQuery) {
        Map<Long, List<DynamicObject>> dataMap = new HashMap<Long, List<DynamicObject>>(16);
        if (!mergeControlIds.isEmpty()) {
            QFilter qFilter = new QFilter("mergecontrol", "in", mergeControlIds);
            if (isQuery) {
                DynamicObjectCollection stageStatusList = QueryServiceHelper.query((String)"bcm_stagecontrolstatus", (String)"id,model,mergecontrol,mergecontrol.orgnumber,mergecontrol.currencynumber,lockstage,lockstage.id,lockstage.number,chkstatus,flowtask,flowtask.id,flowtask.action,flowstatus,modifier,modifytime", (QFilter[])qFilter.toArray());
                dataMap = stageStatusList.stream().collect(Collectors.groupingBy(m -> m.getLong("mergecontrol")));
            } else {
                DynamicObject[] stageStatusArray = BusinessDataServiceHelper.load((String)"bcm_stagecontrolstatus", (String)"id,model,mergecontrol,mergecontrol.orgnumber,mergecontrol.currencynumber,lockstage,lockstage.id,lockstage.number,chkstatus,flowtask,flowtask.id,flowtask.action,flowstatus,modifier,modifytime", (QFilter[])qFilter.toArray());
                dataMap = Arrays.stream(stageStatusArray).collect(Collectors.groupingBy(m -> m.getLong("mergecontrol.id")));
            }
        }
        return dataMap;
    }

    public Map<Long, MergeData> batchGetMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        return this.batchGetMcData(modelId, scenarioId, yearId, periodId, orgIds, false, null);
    }

    public MergeData getOrInitMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId) {
        return this.getOrInitMcData(modelId, scenarioId, yearId, periodId, orgId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeData getOrInitMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId, String pcCurrencyNumber) {
        MergeData mergeData = pcCurrencyNumber == null ? this.loadMergeData(modelId, scenarioId, yearId, periodId, orgId) : this.loadMergeDataByCurrencyNumber(modelId, scenarioId, yearId, periodId, orgId, pcCurrencyNumber);
        List<DynamicObject> dataList = this.buildMcObject(modelId, scenarioId, yearId, periodId, orgId, pcCurrencyNumber, mergeData);
        if (dataList.isEmpty()) {
            return mergeData;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[0]));
            }
            catch (Exception ex) {
                logger.error("Init MergeStatus Error: ", (Throwable)ex);
            }
            finally {
                mergeData = this.loadMergeData(modelId, scenarioId, yearId, periodId, orgId);
            }
        }
        return mergeData;
    }

    public void batchInitMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        HashSet orgAndCurrency = new HashSet(16);
        ArrayList dataList = new ArrayList(orgIds.size());
        Map<Long, MergeData> mcMap = this.batchQueryMcData(modelId, scenarioId, yearId, periodId, orgIds);
        for (Long orgId : orgIds) {
            MergeData mergeData = mcMap.get(orgId);
            List<DynamicObject> newDyns = this.buildMcObject(modelId, scenarioId, yearId, periodId, orgId, null, mergeData);
            newDyns.forEach(dyn -> {
                if (orgAndCurrency.add(dyn.getString("orgnumber") + dyn.getString("currencynumber"))) {
                    dataList.add(dyn);
                }
            });
        }
        if (dataList.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[0]), (OperateOption)op);
            }
            catch (Exception ex) {
                logger.error("Batch Init MergeStatus Error: ", (Throwable)ex);
            }
        }
    }

    public Map<Long, MergeData> batchGetMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds, boolean isManual, String currencyNumber) {
        List<DynamicObject> mcs;
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        Set<String> orgNumbers = this.getOrgNumber4Id(modelId, orgIds);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)scenarioId);
        boolean isVersioned = Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
        if (isVersioned) {
            long quoteSceneId = (Long)sceneNode.getProperty("scenequote.id");
            Set<String> versionedOrgs = MergeEntityService.getInstance().getVersionedOrgs(modelId, scenarioId, yearId, periodId, orgIds);
            HashSet<String> unVersionedOrgs = new HashSet<String>(orgNumbers);
            unVersionedOrgs.removeAll(versionedOrgs);
            mcs = this.batchQueryMergeData(modelId, scenarioId, yearId, periodId, versionedOrgs);
            mcs.addAll(this.batchQueryMergeData(modelId, quoteSceneId, yearId, periodId, unVersionedOrgs));
        } else {
            mcs = this.batchQueryMergeData(modelId, scenarioId, yearId, periodId, orgNumbers);
        }
        Map<String, List<DynamicObject>> orgMap = mcs.stream().collect(Collectors.groupingBy(m -> m.getString("orgnumber")));
        List<Long> mergeControlIds = mcs.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> stageMergeControlMap = this.loadStageMergeControl(mergeControlIds, true);
        HashMap<Long, MergeData> map = new HashMap<Long, MergeData>(orgIds.size());
        for (Long orgId : orgIds) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String orgNumber = orgNode.getNumber();
            List<DynamicObject> dynList = orgMap.get(orgNumber);
            map.put(orgId, this.buildMergeData(orgNode, dynList, isManual, currencyNumber, stageMergeControlMap));
        }
        return map;
    }

    public Map<Long, MergeData> batchQueryMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        Set<String> orgNumbers = this.getOrgNumber4Id(modelId, orgIds);
        List<DynamicObject> mcs = this.batchQueryMergeData(modelId, scenarioId, yearId, periodId, orgNumbers);
        Map<String, List<DynamicObject>> orgMap = mcs.stream().collect(Collectors.groupingBy(m -> m.getString("orgnumber")));
        List<Long> mergeControlIds = mcs.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> stageMergeControlMap = this.loadStageMergeControl(mergeControlIds, true);
        HashMap<Long, MergeData> map = new HashMap<Long, MergeData>(orgIds.size());
        for (Long orgId : orgIds) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String orgNumber = orgNode.getNumber();
            List<DynamicObject> dynList = orgMap.get(orgNumber);
            map.put(orgId, this.buildMergeData(orgNode, dynList, false, null, stageMergeControlMap));
        }
        return map;
    }

    private List<DynamicObject> batchQueryMergeData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<String> orgNumbers) {
        if (orgNumbers.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", orgNumbers);
        return QueryServiceHelper.query((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name", (QFilter[])qcf.toArray());
    }

    public Map<Long, MergeData> batchLoadMcData(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        Set<String> orgNumbers = this.getOrgNumber4Id(modelId, orgIds);
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", orgNumbers);
        DynamicObject[] mcs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name", (QFilter[])qcf.toArray());
        Map<String, List<DynamicObject>> orgMap = Stream.of(mcs).collect(Collectors.groupingBy(m -> m.getString("orgnumber")));
        List<Long> mergeControlIds = Stream.of(mcs).map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> stageMergeControlMap = this.loadStageMergeControl(mergeControlIds, false);
        HashMap<Long, MergeData> map = new HashMap<Long, MergeData>(orgIds.size());
        for (Long orgId : orgIds) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String orgNumber = orgNode.getNumber();
            List<DynamicObject> dynList = orgMap.get(orgNumber);
            map.put(orgId, this.buildMergeData(orgNode, dynList, false, null, stageMergeControlMap));
        }
        return map;
    }

    public Map<String, MergeData> batchGetMcData4Periods(Long modelId, Collection<Long> scenarioIds, Collection<Long> yearIds, Collection<Long> periodIds, Collection<Long> orgIds) {
        List<DynamicObject> mcs = this.batchQueryMergeData4Periods(modelId, scenarioIds, yearIds, periodIds, orgIds);
        Map<String, List<DynamicObject>> orgMap = mcs.stream().collect(Collectors.groupingBy(m -> String.join((CharSequence)"_", m.getString("scenario"), m.getString("year"), m.getString("period"), m.getString("orgnumber"))));
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        HashSet<Long> quoteScenarioIds = new HashSet<Long>(16);
        for (Long scenarioId : scenarioIds) {
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)scenarioId);
            boolean isSceneQuote = Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
            if (!isSceneQuote) continue;
            quoteScenarioIds.add((Long)sceneNode.getProperty("scenequote.id"));
        }
        List<DynamicObject> quoteMcs = this.batchQueryMergeData4Periods(modelId, quoteScenarioIds, yearIds, periodIds, orgIds);
        Map<String, List<DynamicObject>> quoteOrgMap = quoteMcs.stream().collect(Collectors.groupingBy(m -> String.join((CharSequence)"_", m.getString("scenario"), m.getString("year"), m.getString("period"), m.getString("orgnumber"))));
        List<Long> mergeControlIds = mcs.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> stageMergeControlMap = this.loadStageMergeControl(mergeControlIds, true);
        HashMap<String, MergeData> map = new HashMap<String, MergeData>(orgIds.size());
        for (Long scenarioId : scenarioIds) {
            IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNumber, (Long)scenarioId);
            boolean isSceneQuote = Boolean.TRUE.equals(sceneNode.getProperty("isversioned"));
            long quoteScenarioId = (Long)sceneNode.getProperty("scenequote.id");
            for (Long yearId : yearIds) {
                for (Long periodId : periodIds) {
                    Set<Object> versionedOrgs = new HashSet(16);
                    if (isSceneQuote) {
                        versionedOrgs = MergeEntityService.getInstance().getVersionedOrgs(modelId, scenarioId, yearId, periodId, orgIds);
                    }
                    for (Long orgId : orgIds) {
                        List<DynamicObject> dynList;
                        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                        String orgNumber = orgNode.getNumber();
                        String key = String.join((CharSequence)"_", String.valueOf(scenarioId), String.valueOf(yearId), String.valueOf(periodId), orgNumber);
                        if (isSceneQuote && !versionedOrgs.contains(orgNumber)) {
                            String queryKey = String.join((CharSequence)"_", String.valueOf(quoteScenarioId), String.valueOf(yearId), String.valueOf(periodId), orgNumber);
                            dynList = quoteOrgMap.get(queryKey);
                        } else {
                            dynList = orgMap.get(key);
                        }
                        map.put(key, this.buildMergeData(orgNode, dynList, false, null, stageMergeControlMap));
                    }
                }
            }
        }
        return map;
    }

    private List<DynamicObject> batchQueryMergeData4Periods(Long modelId, Collection<Long> scenarioIds, Collection<Long> yearIds, Collection<Long> periodIds, Collection<Long> orgIds) {
        if (scenarioIds.isEmpty()) {
            return new ArrayList<DynamicObject>(16);
        }
        Set<String> orgNumbers = this.getOrgNumber4Id(modelId, orgIds);
        QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "in", scenarioIds).and("year", "in", yearIds).and("period", "in", periodIds).and("orgnumber", "in", orgNumbers);
        return QueryServiceHelper.query((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name,model,scenario,year,period", (QFilter[])qcf.toArray());
    }

    private List<DynamicObject> buildMcObject(Long modelId, Long scenarioId, Long yearId, Long periodId, Long orgId, String pcCurrency, MergeData mergeData) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (mergeData == null) {
            mergeData = new MergeData(null, null, new ArrayList<DynamicObject>(), orgNode, new HashMap<Long, List<DynamicObject>>());
        }
        DynamicObject ecData = mergeData.getEcData();
        DynamicObject pcData = mergeData.getPcData();
        String orgNumber = orgNode.getNumber();
        String ecCurrency = orgNode.getCurrency();
        if (pcCurrency == null && orgNode.getParent() != null) {
            pcCurrency = orgNode.getParent().getCurrency();
        }
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>();
        if (ecData == null) {
            ecData = this.newDynamicObject(modelId, scenarioId, yearId, periodId, orgNumber, ecCurrency);
            dataList.add(ecData);
        }
        if (orgNode.getParent() != null && !"Entity".equals(orgNode.getParent().getNumber()) && pcData == null && !Objects.equals(ecCurrency, pcCurrency)) {
            pcData = this.newDynamicObject(modelId, scenarioId, yearId, periodId, orgNumber, pcCurrency);
            dataList.add(pcData);
        }
        return dataList;
    }

    private DynamicObject newDynamicObject(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgNumber, String currencyNumber) {
        DynamicObject mergeData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_mergecontrolstatus");
        mergeData.set("model", (Object)modelId);
        mergeData.set("scenario", (Object)scenarioId);
        mergeData.set("year", (Object)yearId);
        mergeData.set("period", (Object)periodId);
        mergeData.set("orgNumber", (Object)orgNumber);
        mergeData.set("currencynumber", (Object)currencyNumber);
        mergeData.set("calculatestatus", (Object)"B");
        mergeData.set("mergestatus", (Object)"B");
        mergeData.set("chkstatus", (Object)"B");
        mergeData.set("creator", (Object)UserUtils.getUserId());
        mergeData.set("createtime", (Object)TimeServiceHelper.now());
        return mergeData;
    }

    public void updateCalcStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgNumber) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "=", (Object)orgNumber).and("calculatestatus", "=", (Object)"C").and("flowstatus", "!=", (Object)"C").and(new QFilter("flowtask.id", "is null", null).or("flowtask.action", "!=", (Object)StageOpTypeEnum.APPR.getCode()));
        Object[] mergeObjs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,calculatestatus,flowstatus", (QFilter[])qf.toArray());
        if (ArrayUtils.isEmpty((Object[])mergeObjs)) {
            return;
        }
        for (Object dyn : mergeObjs) {
            dyn.set("calculatestatus", (Object)"B");
        }
        SaveServiceHelper.update((DynamicObject[])mergeObjs);
        this.updateParentMergeStatusByCurrencyNum(modelId, scenarioId, yearId, periodId, orgNumber, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCalcStatusByCurrencyNum(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgNumber, String currencyNumber) {
        boolean isEc = true;
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)orgNumber);
        if (null == currencyNumber) {
            if (orgNode.getId() <= 0L || "Entity".equals(orgNumber)) return;
            currencyNumber = orgNode.getCurrency();
        } else {
            isEc = currencyNumber.equals(orgNode.getCurrency());
        }
        if (isEc) {
            this.updateCalcStatus(modelId, scenarioId, yearId, periodId, orgNumber);
            return;
        } else {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("currencynumber", "=", (Object)currencyNumber).and("orgnumber", "=", (Object)orgNumber).and("calculatestatus", "=", (Object)"C").and("flowstatus", "!=", (Object)"C").and(new QFilter("flowtask.id", "is null", null).or("flowtask.action", "!=", (Object)StageOpTypeEnum.APPR.getCode()));
            Object[] mergeObjs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,calculatestatus,flowstatus", (QFilter[])qfBuilder.toArray());
            if (ArrayUtils.isEmpty((Object[])mergeObjs)) {
                return;
            }
            for (Object dyn : mergeObjs) {
                dyn.set("calculatestatus", (Object)"B");
            }
            SaveServiceHelper.update((DynamicObject[])mergeObjs);
            this.updateParentMergeStatusByCurrencyNum(modelId, scenarioId, yearId, periodId, orgNumber, currencyNumber);
        }
    }

    public void batchUpdateMergeStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, Collection<Long> orgIds) {
        Set<String> orgNumbers = this.getOrgNumber4Id(modelId, orgIds);
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", orgNumbers).and("flowstatus", "!=", (Object)"C").and(new QFilter("flowtask.id", "is null", null).or("flowtask.action", "!=", (Object)StageOpTypeEnum.APPR.getCode()));
        Object[] mergeObjs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,calculatestatus,flowstatus,orgnumber,mergestatus", (QFilter[])qf.toArray());
        if (ArrayUtils.isEmpty((Object[])mergeObjs)) {
            return;
        }
        for (Object dyn : mergeObjs) {
            dyn.set("mergestatus", (Object)"B");
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("updateModifyDate", "false");
        SaveServiceHelper.update((DynamicObject[])mergeObjs, (OperateOption)op);
    }

    public void batchUpdateCalcStatusByCurrencyNum(Long modelId, Long scenarioId, Long yearId, Long periodId, String currencyNumber, Collection<String> orgNumbers) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", orgNumbers).and(new QFilter("mergestatus", "=", (Object)"C").or("calculatestatus", "=", (Object)"C")).and("flowstatus", "!=", (Object)"C").and(new QFilter("flowtask.id", "is null", null).or("flowtask.action", "!=", (Object)StageOpTypeEnum.APPR.getCode()));
        DynamicObject[] mergeObjs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,chkstatus,orgnumber,currencynumber", (QFilter[])qfBuilder.toArray());
        Map<String, List<DynamicObject>> orgMap = Stream.of(mergeObjs).collect(Collectors.groupingBy(m -> m.getString("orgnumber")));
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(10);
        for (String string : orgNumbers) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)string);
            boolean isEc = currencyNumber.equals(orgNode.getCurrency());
            List<DynamicObject> list = orgMap.get(string);
            if (null == list) continue;
            if (isEc) {
                for (DynamicObject statusDyn : list) {
                    statusDyn.set("mergestatus", (Object)"B");
                    statusDyn.set("calculatestatus", (Object)"B");
                    statusDyn.set("chkstatus", (Object)"B");
                    updateList.add(statusDyn);
                }
                continue;
            }
            for (DynamicObject statusDyn : list) {
                if (!currencyNumber.equals(statusDyn.getString("currencynumber"))) continue;
                statusDyn.set("mergestatus", (Object)"B");
                statusDyn.set("calculatestatus", (Object)"B");
                statusDyn.set("chkstatus", (Object)"B");
                updateList.add(statusDyn);
            }
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (String orgNumber : orgNumbers) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)modelNumber, (String)orgNumber);
            List shareNodes = orgNode.getShareNodes();
            shareNodes.add(orgNode);
            boolean isEc = currencyNumber.equals(orgNode.getCurrency());
            if (isEc) {
                orgIdSet.addAll(shareNodes.stream().map(IDNumberTreeNode::getId).collect(Collectors.toList()));
                continue;
            }
            for (IDNumberTreeNode shareNode : shareNodes) {
                IDNumberTreeNode parentNode = shareNode.getParent();
                if (parentNode == null || parentNode.getId() <= 0L || "Entity".equals(parentNode.getNumber()) || !currencyNumber.equals(parentNode.getCurrency())) continue;
                orgIdSet.add(shareNode.getId());
            }
        }
        Set<Long> set = OrgServiceHelper.findParentOrgIdsForIsMergeAndCSTE(modelId, scenarioId, yearId, periodId, orgIdSet);
        if (set.size() > 0) {
            DynamicObject[] parentMergeObjs;
            Set<String> resetParentOrgNumbers = this.getOrgNumber4Id(modelId, set);
            QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", resetParentOrgNumbers).and("mergestatus", "=", (Object)"C").and("flowstatus", "!=", (Object)"C").and(new QFilter("flowtask.id", "is null", null).or("flowtask.action", "!=", (Object)StageOpTypeEnum.APPR.getCode()));
            for (DynamicObject mcDyn : parentMergeObjs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,chkstatus,orgnumber,currencynumber", (QFilter[])qcf.toArray())) {
                mcDyn.set("mergestatus", (Object)"B");
                updateList.add(mcDyn);
            }
        }
        if (!updateList.isEmpty()) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)op);
        }
    }

    public void updateParentMergeStatusByCurrencyNum(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgNumber, String currencyNumber) {
        boolean isEc = true;
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberByNum((String)MemberReader.findModelNumberById((Object)modelId), (String)orgNumber);
        if (null == currencyNumber) {
            currencyNumber = orgNode.getCurrency();
        } else {
            isEc = orgNode.getCurrency().equals(currencyNumber);
        }
        List shareNodes = orgNode.getShareNodes();
        shareNodes.add(orgNode);
        HashSet<Long> changeShareOrgIds = new HashSet(16);
        if (isEc) {
            changeShareOrgIds = shareNodes.stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet());
        } else {
            for (IDNumberTreeNode shareNode : shareNodes) {
                IDNumberTreeNode parentNode = shareNode.getParent();
                if (parentNode.getId() <= 0L || "Entity".equals(parentNode.getNumber()) || !currencyNumber.equals(parentNode.getCurrency())) continue;
                changeShareOrgIds.add(shareNode.getId());
            }
        }
        Set<Long> allChangeParentOrgIds = OrgServiceHelper.findParentOrgIdsForIsMergeAndCSTE(modelId, scenarioId, yearId, periodId, changeShareOrgIds);
        if (allChangeParentOrgIds.size() > 0) {
            DynamicObject[] mcs;
            Set<String> resetParentOrgNumbers = this.getOrgNumber4Id(modelId, allChangeParentOrgIds);
            QFBuilder qcf = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "in", resetParentOrgNumbers).and("mergestatus", "=", (Object)"C").and("flowstatus", "!=", (Object)"C").and(new QFilter("flowtask.id", "is null", null).or("flowtask.action", "!=", (Object)StageOpTypeEnum.APPR.getCode()));
            for (DynamicObject mcDyn : mcs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,archivestatus,chkstatus,checkstatus,progressid,flowtask,flowtask.action,begintime,endtime,orgnumber,currencynumber,modifier.name", (QFilter[])qcf.toArray())) {
                mcDyn.set("mergestatus", (Object)"B");
            }
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            SaveServiceHelper.update((DynamicObject[])mcs, (OperateOption)op);
        }
    }

    private Set<String> getOrgNumber4Id(Long modelId, Collection<Long> orgIds) {
        HashSet<String> orgNumbers = new HashSet<String>(orgIds.size());
        for (Long orgId : orgIds) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String orgNumber = orgNode.getNumber();
            orgNumbers.add(orgNumber);
        }
        return orgNumbers;
    }

    public void updateCheckStatus(Long modelId) {
        DBRoute dbRoute = DBRoute.of((String)"bcm");
        String updateSql = "update t_bcm_mergecontrol set fcheckstatus = ?  where fmodelid = ? and fflowstatus ='C'\u3000";
        DB.update((DBRoute)dbRoute, (String)updateSql, (Object[])new Object[]{"C", modelId});
    }

    public void updateChkStatus(Long modelId, Long scenarioId, Long yearId, Long periodId, String orgNumber, String currencyNumber, String status) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId).and("scenario", "=", (Object)scenarioId).and("year", "=", (Object)yearId).and("period", "=", (Object)periodId).and("orgnumber", "=", (Object)orgNumber).and("currencynumber", "=", (Object)currencyNumber).and("flowstatus", "!=", (Object)"C").and(new QFilter("flowtask.id", "is null", null).or("flowtask.action", "!=", (Object)StageOpTypeEnum.APPR.getCode()));
        DynamicObject[] mcs = BusinessDataServiceHelper.load((String)"bcm_mergecontrolstatus", (String)"id,mergestatus,calculatestatus,flowstatus,chkstatus,orgnumber,currencynumber", (QFilter[])qfBuilder.toArray());
        if (mcs.length > 0) {
            for (DynamicObject mcDyn : mcs) {
                mcDyn.set("chkstatus", (Object)status);
            }
            OperateOption op = OperateOption.create();
            op.setVariableValue("updateModifyDate", "false");
            SaveServiceHelper.update((DynamicObject[])mcs, (OperateOption)op);
        }
    }
}

