/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.check;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.check.CheckCompleteExecutor;
import kd.fi.bcm.common.model.ResultBox;

public class CheckCancelCompleteExecutor
extends CheckCompleteExecutor {
    @Override
    public ResultBox check() {
        ResultBox result = ResultBox.of();
        if (this.needOrgList.isEmpty()) {
            result.add(MergeMessage.EMPTY_DATA.getText());
            return result;
        }
        HashSet<String> dealOrgNumber = new HashSet<String>(this.needOrgList.size());
        for (DynamicObject org : this.needOrgList) {
            long orgId = org.getLong("id");
            String orgNumber = org.getString("number");
            if (!dealOrgNumber.add(orgNumber)) continue;
            if (this.OPEN_CM012 && !this.periodStatusOpenOrgNumbers.contains(orgNumber)) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNumber));
                continue;
            }
            MergeData mergeData = (MergeData)this.mcStatusMap.get(orgId);
            McStatus mcStatus = mergeData.getMergeStatus();
            DynamicObject ecData = mergeData.getEcData();
            if (mcStatus.getFlow().isFlowSubmit()) {
                result.addError(String.format(MergeMessage.HAS_SUBMIT.getText(), orgNumber));
                continue;
            }
            if ("B".equals(ecData.getString("checkstatus"))) {
                result.addError(String.format(MergeMessage.NO_CHECKSTATUS.getText(), orgNumber));
                continue;
            }
            this.checkedList.add(org);
        }
        return result;
    }

    @Override
    public ResultBox submit() {
        ResultBox result = ResultBox.of();
        ArrayList<DynamicObject> mcList = new ArrayList<DynamicObject>(this.checkedList.size());
        for (DynamicObject dyn : this.checkedList) {
            long memberId = dyn.getLong("id");
            MergeData mergeData = (MergeData)this.mcStatusMap.get(memberId);
            DynamicObject mcData = mergeData.getEcData();
            mcData.set("checkstatus", (Object)"B");
            mcList.add(mcData);
        }
        try (TXHandle tx = TX.required();){
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.update((DynamicObject[])mcList.toArray(new DynamicObject[0]), (OperateOption)op);
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.toString());
            }
        }
        return result;
    }
}

