/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.IMergeExecutor;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.model.ResultBox;

public class CheckCompleteExecutor
implements IMergeExecutor {
    protected MergeControlService mergeService = MergeControlService.getInstance();
    protected McContext ctx;
    private Set<Long> orgIds = new HashSet<Long>();
    private Set<String> orgNumbers = new HashSet<String>();
    protected Map<Long, MergeData> mcStatusMap = new HashMap<Long, MergeData>();
    protected List<DynamicObject> needOrgList = new ArrayList<DynamicObject>();
    protected List<DynamicObject> checkedList = new ArrayList<DynamicObject>();
    protected boolean OPEN_CM012 = false;
    protected Set<String> periodStatusOpenOrgNumbers = new HashSet<String>();

    @Override
    public ResultBox doSubmit(McContext mcContext) {
        this.ctx = mcContext;
        this.init();
        ResultBox check = this.check();
        ResultBox result = this.submit();
        result.append(check);
        return result;
    }

    public void init() {
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long fyId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Map<String, Object> dataMap = this.ctx.getDataMap();
        Boolean includeAllChildren = (Boolean)dataMap.get("includeChildren");
        Collection<SimpleItem> orgList = this.ctx.getOrgList();
        List<Long> selectOrgIds = orgList.stream().map(SimpleItem::getId).collect(Collectors.toList());
        this.needOrgList = this.getOrgListByScope(modelId, selectOrgIds, includeAllChildren);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, this.ctx.getFyNum(), periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, this.needOrgList);
        this.orgIds = this.needOrgList.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        this.orgNumbers = this.needOrgList.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        MergeStatusService.getInstance().batchInitMcData(modelId, scenarioId, fyId, periodId, this.orgIds);
        this.mcStatusMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, fyId, periodId, this.orgIds);
        this.periodStatusOpenOrgNumbers = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, this.orgNumbers, scenarioId, fyId, periodId, "datastatus");
        this.OPEN_CM012 = ConfigServiceHelper.getBoolParam(modelId, "CM012");
    }

    public ResultBox check() {
        ResultBox result = ResultBox.of();
        if (this.needOrgList.isEmpty()) {
            result.add(MergeMessage.EMPTY_DATA.getText());
            return result;
        }
        HashSet<String> dealOrgNumber = new HashSet<String>(this.needOrgList.size());
        for (DynamicObject org : this.needOrgList) {
            long orgId = org.getLong("id");
            String orgNumber = org.getString("number");
            if (!dealOrgNumber.add(orgNumber)) continue;
            if (this.OPEN_CM012 && !this.periodStatusOpenOrgNumbers.contains(orgNumber)) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNumber));
                continue;
            }
            MergeData mergeData = this.mcStatusMap.get(orgId);
            McStatus mcStatus = mergeData.getMergeStatus();
            DynamicObject ecData = mergeData.getEcData();
            if (mcStatus.getFlow().isFlowSubmit()) {
                result.addError(String.format(MergeMessage.HAS_SUBMIT.getText(), orgNumber));
                continue;
            }
            if ("C".equals(ecData.getString("checkstatus"))) {
                result.addError(String.format(MergeMessage.HAS_CHECKED.getText(), orgNumber));
                continue;
            }
            this.checkedList.add(org);
        }
        return result;
    }

    public ResultBox submit() {
        ResultBox result = ResultBox.of();
        ArrayList<DynamicObject> mcList = new ArrayList<DynamicObject>(this.checkedList.size());
        for (DynamicObject dyn : this.checkedList) {
            long memberId = dyn.getLong("id");
            MergeData mergeData = this.mcStatusMap.get(memberId);
            DynamicObject mcData = mergeData.getEcData();
            mcData.set("checkstatus", (Object)"C");
            mcList.add(mcData);
        }
        try (TXHandle tx = TX.required();){
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.update((DynamicObject[])mcList.toArray(new DynamicObject[0]), (OperateOption)op);
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.toString());
            }
        }
        return result;
    }

    private DynamicObjectCollection getOrgListByScope(long modelId, List<Long> orgIds, boolean includeAllChildren) {
        HashSet<Long> scopeOrgIds = new HashSet<Long>(orgIds.size());
        if (includeAllChildren) {
            orgIds.forEach(orgId -> {
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                if (orgNode.getId() > 0L) {
                    if (orgNode.isLeaf()) {
                        scopeOrgIds.add((Long)orgId);
                    } else {
                        scopeOrgIds.add((Long)orgId);
                        scopeOrgIds.addAll(orgNode.getAllChildrenIds());
                    }
                }
            });
        } else {
            scopeOrgIds.addAll(orgIds);
        }
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("id", "in", scopeOrgIds);
        filter.and("isexchangerate", "=", (Object)"0");
        long orgDimId = DimensionServiceHelper.getIdByNum("bcm_dimension", modelId, DimEntityNumEnum.ENTITY.getNumber());
        filter.and(PermissionServiceImpl.getInstance(modelId).getReadOrWritePermFilter(orgDimId, "bcm_entitymembertree", "id"));
        DynamicObjectCollection sortOrg = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,id as memberid,name,number,longnumber,isleaf,level,currency,currency.number as currencynumber,currency.name currencyname,parent,parent.number,dseq,copyfrom,share,storagetype,isexchangerate", (QFilter[])filter.toArray(), (String)"level,dseq");
        return sortOrg;
    }
}

