/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.allinone.model.McContext;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.IMergeExecutor;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.model.ResultBox;

public abstract class AbstractMergeFlowExecutor
implements IMergeExecutor {
    protected MergeControlService mergeService = MergeControlService.getInstance();
    protected McContext ctx;
    protected Map<Long, MergeData> mcDataMap = new HashMap<Long, MergeData>();
    protected List<DynamicObject> sortOrg = new ArrayList<DynamicObject>();
    protected Map<Long, DynamicObject> taskMap = new HashMap<Long, DynamicObject>();
    protected List<DynamicObject> checkedList = new ArrayList<DynamicObject>();
    protected Set<String> dealOrgNumber = new HashSet<String>();
    protected boolean OPEN_CM012 = false;
    protected Set<String> periodStatusOpenOrgNumbers = new HashSet<String>();
    protected boolean checkReportSubmit = false;
    protected Set<String> notCheckReportSubmitOrgNumbers = new HashSet<String>();

    @Override
    public ResultBox doSubmit(McContext mcContext) {
        this.ctx = mcContext;
        ResultBox result = ResultBox.of();
        TreeMap<Integer, List<DynamicObject>> sortGroupMap = this.sortGroup();
        sortGroupMap.forEach((l, d) -> {
            this.sortOrg = d;
            this.init();
            ResultBox checkResult = this.check();
            ResultBox saveResult = this.submit();
            saveResult.append(checkResult);
            result.append(saveResult);
        });
        return result;
    }

    protected void init() {
    }

    protected ResultBox check() {
        return ResultBox.of();
    }

    protected ResultBox submit() {
        return ResultBox.of();
    }

    protected TreeMap<Integer, List<DynamicObject>> sortGroup() {
        return new TreeMap<Integer, List<DynamicObject>>(this.getOrgGroup());
    }

    protected Map<Integer, List<DynamicObject>> getOrgGroup() {
        Set<String> allVersionedOrgs;
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long periodId = this.ctx.getPeriodId();
        Collection<SimpleItem> orgList = this.ctx.getOrgList();
        List<Long> orgIds = orgList.stream().map(SimpleItem::getId).collect(Collectors.toList());
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String includeSon = (String)resultMap.get("includeson");
        Object sortOrg = this.getSortOrgListByScope(modelId, orgIds, includeSon);
        if (!this.ctx.isIgnoreOrgEffect()) {
            FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, this.ctx.getFyNum(), periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)sortOrg);
            List<Long> allOrgId = sortOrg.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            Set<Long> noPermMembers = PermissionServiceImpl.getInstance(modelId).matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", allOrgId);
            sortOrg = sortOrg.stream().filter(o -> !noPermMembers.contains(o.getLong("id"))).collect(Collectors.toList());
        }
        if (MergeControlHelper.isQuoteScene(modelId, scenarioId) && !(allVersionedOrgs = MergeControlHelper.getAllVersionedOrgs(modelId, scenarioId, this.ctx.getFyId(), this.ctx.getPeriodId())).isEmpty()) {
            sortOrg = sortOrg.stream().filter(e -> allVersionedOrgs.contains(e.getString("number"))).collect(Collectors.toList());
        }
        return sortOrg.stream().collect(Collectors.groupingBy(o -> o.getInt("level")));
    }

    private DynamicObjectCollection getSortOrgListByScope(long modelId, List<Long> orgIds, String includeSon) {
        ArrayList<Long> scopeOrgIds = new ArrayList<Long>(orgIds.size());
        if ("1".equals(includeSon)) {
            scopeOrgIds.addAll(orgIds);
        } else if ("2".equals(includeSon) || "3".equals(includeSon)) {
            orgIds.forEach(orgId -> {
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                if (orgNode.getId() > 0L) {
                    if (orgNode.isLeaf()) {
                        scopeOrgIds.add((Long)orgId);
                    } else {
                        if ("2".equals(includeSon)) {
                            scopeOrgIds.addAll(orgNode.getChildrenIds());
                        } else {
                            scopeOrgIds.addAll(orgNode.getAllChildrenIds());
                        }
                        scopeOrgIds.add((Long)orgId);
                    }
                }
            });
        } else {
            throw new KDBizException("Error include type");
        }
        DynamicObjectCollection sortOrg = OrgServiceHelper.getOrgList(modelId, scopeOrgIds);
        return sortOrg;
    }
}

