/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.flow;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.allinone.model.McContext;
import kd.fi.bcm.business.dimension.datalock.StageServiceHelper;
import kd.fi.bcm.business.mergecontrol.IMergeExecutor;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepServiceHelper;
import kd.fi.bcm.business.mergecontrol.flow.MergeApproveExecutor;
import kd.fi.bcm.business.mergecontrol.flow.MergeBackExecutor;
import kd.fi.bcm.business.mergecontrol.flow.MergeStageApproveExecutor;
import kd.fi.bcm.business.mergecontrol.flow.MergeStageBackExecutor;
import kd.fi.bcm.common.enums.FlowStepTypeEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;

public class FlowOpService {
    String opType;
    McContext mcContext;
    IMergeExecutor stageOp;
    FlowStepTypeEnum stepType;
    Boolean isStage = Boolean.FALSE;

    public FlowOpService(McContext mcContext, String opType) {
        this.opType = opType;
        this.mcContext = mcContext;
        this.stageOp = this.getStageOp(opType);
    }

    public FlowOpService(McContext mcContext, String opType, Boolean isStage) {
        this.opType = opType;
        this.mcContext = mcContext;
        this.isStage = isStage;
        this.stageOp = this.getStageOp(opType);
    }

    private IMergeExecutor getStageOp(String opType) {
        if (this.isStage.booleanValue()) {
            if (Objects.equals(opType, StageOpTypeEnum.COMMIT.getCode())) {
                this.stepType = FlowStepTypeEnum.COMMIT;
                return new MergeStageApproveExecutor();
            }
            if (Objects.equals(opType, StageOpTypeEnum.APPR.getCode())) {
                this.stepType = FlowStepTypeEnum.NOMAL;
                return new MergeStageApproveExecutor();
            }
            if (Objects.equals(opType, StageOpTypeEnum.BACK.getCode())) {
                this.stepType = FlowStepTypeEnum.REJECT;
                return new MergeStageBackExecutor();
            }
        } else {
            if (Objects.equals(opType, StageOpTypeEnum.COMMIT.getCode())) {
                this.stepType = FlowStepTypeEnum.COMMIT;
                return new MergeApproveExecutor();
            }
            if (Objects.equals(opType, StageOpTypeEnum.APPR.getCode())) {
                this.stepType = FlowStepTypeEnum.NOMAL;
                return new MergeApproveExecutor();
            }
            if (Objects.equals(opType, StageOpTypeEnum.BACK.getCode())) {
                this.stepType = FlowStepTypeEnum.REJECT;
                return new MergeBackExecutor();
            }
        }
        throw new KDBizException("Error StageOpType");
    }

    public ResultBox doSubmit() {
        DynamicObject step;
        if (Objects.equals(this.opType, StageOpTypeEnum.APPR.getCode())) {
            Object stepId = this.mcContext.getDataMap().get("stepid");
            step = FlowStepServiceHelper.getFlowStepById(LongUtil.toLong((Object)stepId));
        } else {
            step = FlowStepServiceHelper.getFlowStep(this.mcContext.getModelId(), this.stepType);
        }
        this.mcContext.setFlowStep(step);
        if (this.isStage.booleanValue()) {
            Object stageId = this.mcContext.getDataMap().get("stageId");
            DynamicObject stage = StageServiceHelper.getStageById(LongUtil.toLong((Object)stageId));
            this.mcContext.setStage(stage);
        }
        return this.stageOp.doSubmit(this.mcContext);
    }
}

