/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.flow;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepInitHelper;
import kd.fi.bcm.common.enums.FlowStepTypeEnum;
import kd.fi.bcm.common.enums.StepModuleEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class FlowStepServiceHelper {
    public static DynamicObject getFlowStep(long modelId, FlowStepTypeEnum stepType) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("module", "=", (Object)StepModuleEnum.MERGE.getCode());
        filter.and("steptype", "=", (Object)stepType.getValue());
        DynamicObject flowStep = QueryServiceHelper.queryOne((String)"bcm_flowstep", (String)"id,number,name,sort", (QFilter[])filter.toArray());
        if (flowStep == null) {
            FlowStepInitHelper.initFlowStep(String.valueOf(modelId));
            flowStep = FlowStepServiceHelper.getFlowStep(modelId, stepType);
        }
        return flowStep;
    }

    public static DynamicObject getFlowStepById(long stepId) {
        QFilter filter = new QFilter("id", "=", (Object)stepId);
        return QueryServiceHelper.queryOne((String)"bcm_flowstep", (String)"id,number,name,sort", (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection getBeforeFlowSteps(long modelId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("module", "=", (Object)StepModuleEnum.MERGE.getCode());
        filter.and("steptype", "in", (Object)new String[]{FlowStepTypeEnum.NOMAL.getValue(), FlowStepTypeEnum.END.getValue()});
        return QueryServiceHelper.query((String)"bcm_flowstep", (String)"id,number,name,flowstatus", (QFilter[])filter.toArray(), (String)"sort");
    }

    public static DynamicObjectCollection getFlowSteps(Long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and(new QFilter("steptype", "in", (Object)new String[]{"B", "C", "D", "H"}));
        return QueryServiceHelper.query((String)"bcm_flowstep", (String)"id,name,number,sort", (QFilter[])new QFilter[]{qf}, (String)"sort");
    }

    public static DynamicObject getFlowTask(Long taskId) {
        QFBuilder qf = new QFBuilder();
        qf.add("id", "=", (Object)taskId);
        return QueryServiceHelper.queryOne((String)"bcm_flowtask", (String)"bizid,flowstep.id,flowstep.sort,flowstep.flowstatus,flowstep.steptype,laststep,action,actor", (QFilter[])qf.toArray());
    }

    public static DynamicObjectCollection getFlowTasks(Collection<Long> taskIds) {
        QFBuilder qf = new QFBuilder();
        qf.add("id", "in", taskIds);
        return QueryServiceHelper.query((String)"bcm_flowtask", (String)"id,bizid,flowstep.id,flowstep.sort,flowstep.flowstatus,flowstep.steptype,laststep,action,actor", (QFilter[])qf.toArray());
    }

    public static String getFlowTaskStatus(Long taskId) {
        String flowStatus = "";
        if (taskId == 0L) {
            return flowStatus;
        }
        DynamicObject curTask = FlowStepServiceHelper.getFlowTask(taskId);
        if (curTask != null) {
            flowStatus = curTask.getString("flowstep.flowstatus");
        }
        return flowStatus;
    }

    public static String getFlowTaskSort(Long taskId) {
        String flowStatus = "";
        if (taskId == 0L) {
            return flowStatus;
        }
        DynamicObject curTask = FlowStepServiceHelper.getFlowTask(taskId);
        if (curTask != null) {
            flowStatus = curTask.getString("flowstep.sort");
        }
        return flowStatus;
    }
}

