/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.mergecontrol.custom.MergeCustomServiceHelper;
import kd.fi.bcm.business.mergecontrol.custom.MergeFlowCustomService;
import kd.fi.bcm.business.mergecontrol.flow.AbstractMergeFlowExecutor;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepServiceHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.config.CM053TypeEnum;
import kd.fi.bcm.common.config.SceneSettingVo;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.util.DataCollectUtils;
import org.apache.commons.lang.StringUtils;

public class MergeApproveExecutor
extends AbstractMergeFlowExecutor {
    public static final Log logger = LogFactory.getLog(MergeApproveExecutor.class);

    @Override
    protected TreeMap<Integer, List<DynamicObject>> sortGroup() {
        Map<Integer, List<DynamicObject>> orgGroup = super.getOrgGroup();
        TreeMap<Integer, List<DynamicObject>> treeMap = new TreeMap<Integer, List<DynamicObject>>((o1, o2) -> o2 - o1);
        treeMap.putAll(orgGroup);
        return treeMap;
    }

    @Override
    protected void init() {
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        List<Long> orgIds = this.sortOrg.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        Set<String> orgNumbers = this.sortOrg.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        this.periodStatusOpenOrgNumbers = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, orgNumbers, scenarioId, yearId, periodId, "datastatus");
        this.OPEN_CM012 = ConfigServiceHelper.getBoolParam(modelId, "CM012");
        if (resultMap.containsKey("isApiCall")) {
            MergeData apiMegeData = MergeStatusService.getInstance().getOrInitMcData(modelId, scenarioId, yearId, periodId, (Long)orgIds.get(0), resultMap.get("apiCallCurrency").toString());
            this.mcDataMap.put(orgIds.get(0), apiMegeData);
        } else {
            this.mcDataMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, yearId, periodId, orgIds);
        }
        HashSet<Long> taskIds = new HashSet<Long>(orgIds.size());
        this.mcDataMap.forEach((o, m) -> {
            long taskId;
            DynamicObject mcData = "EC".equals(ecOrPc) ? m.getEcData() : m.getPcData();
            if (mcData != null && (taskId = mcData.getLong("flowtask.id")) != 0L) {
                taskIds.add(taskId);
            }
        });
        DynamicObjectCollection flowTasks = FlowStepServiceHelper.getFlowTasks(taskIds);
        this.taskMap = flowTasks.stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t));
        this.checkReportSubmit = ConfigServiceHelper.getCM024CheckReportSubmit(modelId);
        if (this.checkReportSubmit) {
            this.notCheckReportSubmitOrgNumbers = ConfigServiceHelper.getCM024IgnoreCheckOrg(modelId, scenarioId, yearId, periodId);
        }
    }

    @Override
    protected ResultBox check() {
        ResultBox result = ResultBox.of();
        if (this.sortOrg.isEmpty()) {
            result.add(MergeMessage.EMPTY_DATA.getText());
            return result;
        }
        DynamicObject flowStep = this.ctx.getFlowStep();
        if (flowStep == null) {
            result.addError(MergeMessage.NONE_STEP.getText());
            return result;
        }
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        long stepId = flowStep.getLong("id");
        int stepSort = flowStep.getInt("sort");
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String opType = (String)resultMap.get("stageoptype");
        String ecOrPc = (String)resultMap.get("isEc");
        String yearNum = this.ctx.getFyNum();
        String periodNum = this.ctx.getPeriodNum();
        String scenarioNum = this.ctx.getScenariodNum();
        HashSet excludeOrgNumbers = new HashSet();
        boolean isCommitCheck = !Boolean.TRUE.equals(resultMap.get("forcecommit"));
        isCommitCheck = isCommitCheck && ConfigServiceHelper.getBoolParam(modelId, "CM004");
        Set notCheckChkOrg = new HashSet();
        if (isCommitCheck) {
            notCheckChkOrg = (Set)ConfigServiceHelper.getConfigOfCMO04((Long)Long.valueOf((long)modelId)).p2;
        }
        boolean isCheckMergeStatus = ConfigServiceHelper.getBoolParam(modelId, "isFlowCommitByMergeStatus");
        boolean isSettleCheck = ConfigServiceHelper.getBoolParam(modelId, "CM018", "checkreport");
        isSettleCheck = isSettleCheck && StageOpTypeEnum.COMMIT.getCode().equals(opType);
        boolean isMonth = "MRpt".equals(scenarioNum) && yearNum != null && yearNum.startsWith("FY") && periodNum != null && periodNum.startsWith("M_M");
        boolean bl = isSettleCheck = isSettleCheck && isMonth;
        if (isSettleCheck) {
            yearNum = yearNum.substring(2);
            periodNum = periodNum.substring(3);
            QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
            qf.add("number", "=", (Object)"CM018");
            qf.add("dentity.isshow", "=", (Object)"1");
            DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bcm_checkledgersetting", (String)"number, dentity.num, dentity.rangevalue, dentity.oid", (QFilter[])qf.toArray());
            dyc.forEach(p -> {
                Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", LongUtil.toLong((Object)p.getString("dentity.oid")), p.getString("dentity.num"), p.getInt("dentity.rangevalue"), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
                excludeOrgNumbers.addAll(entitySet);
            });
        }
        Set<String> orgNumbers = this.sortOrg.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        Set<Long> orgIds = this.sortOrg.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Map<String, DynamicObject> org2Perm = this.mergeService.getApprPerm(modelId, orgNumbers);
        this.checkedList = new ArrayList(this.sortOrg.size());
        HashMap<Long, ResultBox> customCheckResult = new HashMap<Long, ResultBox>(16);
        if (!ConfigServiceHelper.getBoolParam(modelId, "isCustomCheckFlow")) {
            List<MergeFlowCustomService> customServiceList = MergeCustomServiceHelper.findCustomService();
            for (MergeFlowCustomService customService : customServiceList) {
                Map<Long, ResultBox> resultBoxMap = customService.customSubmitCheckFlow(modelId, scenarioId, this.ctx.getFyId(), this.ctx.getPeriodId(), orgIds, "EC".equals(ecOrPc));
                if (resultBoxMap == null || resultBoxMap.isEmpty()) continue;
                customCheckResult.putAll(resultBoxMap);
            }
        }
        for (DynamicObject org : this.sortOrg) {
            long taskId;
            long orgId = org.getLong("id");
            String orgNumber = org.getString("number");
            ResultBox resultBox = (ResultBox)customCheckResult.get(orgId);
            if (resultBox != null && resultBox.isNotSuccess()) {
                result.addError(resultBox.getMessageText());
                continue;
            }
            if (this.OPEN_CM012 && !this.periodStatusOpenOrgNumbers.contains(orgNumber)) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNumber));
                continue;
            }
            boolean isLeaf = org.getBoolean("isleaf");
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String ecCurrency = orgNode.getCurrency();
            String pcCurrency = null;
            if (orgNode.getParent() != null) {
                pcCurrency = orgNode.getParent().getCurrency();
            }
            if ("PC".equals(ecOrPc)) {
                if (orgNode.getParent() != null && "Entity".equals(orgNode.getParent().getNumber())) {
                    result.add(String.format(MergeMessage.ROOT_CANTPC.getText(), orgNumber));
                    continue;
                }
                if (Objects.equals(ecCurrency, pcCurrency)) {
                    result.add(String.format(MergeMessage.SKIP_NONEPC.getText(), orgNumber));
                    continue;
                }
            }
            MergeData mergeData = (MergeData)this.mcDataMap.get(orgId);
            McStatus mcStatus = mergeData.getMergeStatus();
            DynamicObject mcData = "EC".equals(ecOrPc) ? mergeData.getEcData() : mergeData.getPcData();
            String orgAndCurrency = "EC".equals(ecOrPc) ? orgNumber + '|' + ecCurrency : orgNumber + '|' + pcCurrency;
            if (!this.dealOrgNumber.add(orgAndCurrency)) continue;
            if (!this.mergeService.checkApprPerm(org2Perm, orgNumber, stepId)) {
                result.add(String.format(MergeMessage.NONE_PERM.getText(), orgNumber));
                continue;
            }
            if ("EC".equals(ecOrPc) && mcStatus.getArchive().isArchive()) {
                result.add(String.format(MergeMessage.HAS_ARCHIVE.getText(), orgNumber));
                continue;
            }
            if ("EC".equals(ecOrPc)) {
                List<String> notSubmitReportNumber;
                MergeDataSourceEnum mergeDataSourceEnum;
                boolean isSIRpt;
                Map<String, String> dimMemMapByNum;
                Boolean disResult;
                if (mcStatus.getFlow().isFlowSubmit()) {
                    result.addError(String.format(MergeMessage.HAS_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (isLeaf && !mcStatus.getCalculate().isSuccess()) {
                    result.addError(String.format(MergeMessage.NOT_CALC.getText(), orgNumber));
                    continue;
                }
                if (!isLeaf) {
                    if (isCheckMergeStatus && !mcStatus.getMergeStatus().isSuccess()) {
                        result.addError(String.format(MergeMessage.NOT_MERGE.getText(), orgNumber));
                        continue;
                    }
                    if (!mcStatus.getCalculate().isSuccess()) {
                        result.addError(String.format(MergeMessage.NOT_CALC.getText(), orgNumber));
                        continue;
                    }
                }
                if (isSettleCheck && !excludeOrgNumbers.contains(orgNumber) && isLeaf && Boolean.FALSE.equals(disResult = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"GLAccountBookService", (String)"isAccountBookClose", (Object[])new Object[]{orgNumber = (dimMemMapByNum = DataCollectUtils.getDimMemMapByNum(modelId, Collections.singletonList(orgNumber), "Entity")).get(orgNumber), null, yearNum, periodNum}))) {
                    result.add(String.format(MergeMessage.NOT_SETTLE.getText(), orgNumber));
                    continue;
                }
                String key = ChkCheckServiceHelper.generateKey(MemberReader.findModelNumberById((Object)modelId), orgNumber, scenarioNum, yearNum, periodNum);
                if (ChkCheckServiceHelper.isKeyValid(key)) {
                    result.add(String.format(MergeMessage.CHK_CHECKING.getText(), orgNumber));
                    continue;
                }
                if (isCommitCheck && !notCheckChkOrg.contains(orgNumber) && !mcStatus.getChkStatus().isSuccess()) {
                    result.setCode(MergeMessage.NOT_CHECKUP.getCode());
                    result.add(String.format(MergeMessage.NOT_CHECKUP.getText(), orgNumber));
                    continue;
                }
                if (!isLeaf && (isSIRpt = (mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)scenarioId, (Object)yearId, (Object)periodId, orgId)).getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex()))) {
                    String subOrgNotCommitNumber;
                    String subOrgNumber = this.mergeService.checkSubLevel(modelId, scenarioId, yearId, periodId, orgId, stepSort);
                    if (StringUtils.isNotBlank((String)subOrgNumber)) {
                        result.add(String.format(MergeMessage.CANT_HIGN.getText(), orgNumber, subOrgNumber));
                        continue;
                    }
                    if (StageOpTypeEnum.COMMIT.getCode().equals(opType) && StringUtils.isNotBlank((String)(subOrgNotCommitNumber = this.mergeService.checkSubPcStatus(modelId, scenarioId, yearId, periodId, orgId)))) {
                        result.add(String.format(MergeMessage.HAS_PCNOTCOMMIT.getText(), orgNumber, subOrgNotCommitNumber));
                        continue;
                    }
                }
                if (this.checkCurrentSceneCheckParam(modelId, scenarioNum) && StageOpTypeEnum.COMMIT.getCode().equals(opType) && !Objects.equals("C", mcData.getString("checkstatus"))) {
                    result.add(String.format(MergeMessage.NO_CHECKSTATUS.getText(), orgNumber));
                    continue;
                }
                if (this.checkReportSubmit && !this.notCheckReportSubmitOrgNumbers.contains(orgNumber) && !(notSubmitReportNumber = ReportServiceHelper.checkOrgReportCommitStatus(modelId, orgId, scenarioId, yearId, periodId)).isEmpty()) {
                    result.add(String.format(MergeMessage.REPORT_NOT_SUBMIT.getText(), orgNumber));
                    continue;
                }
            }
            if ("PC".equals(ecOrPc)) {
                List<String> notSubmitReportNumber;
                String modelNumber;
                IDNumberTreeNode currencyNode;
                IDNumberTreeNode parent;
                if (mcStatus.getPcFlow().isFlowSubmit()) {
                    result.addError(String.format(MergeMessage.HAS_PC_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (!mcStatus.getConvert().isSuccess()) {
                    result.add(String.format(MergeMessage.NOT_CONVERT.getText(), orgNumber));
                    continue;
                }
                if (!mcStatus.getFlow().isFlowSubmit()) {
                    result.add(String.format(MergeMessage.NOT_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (isCommitCheck && !notCheckChkOrg.contains(orgNumber) && !mcStatus.getPcChkStatus().isSuccess()) {
                    result.setCode(MergeMessage.NOT_CHECKUP.getCode());
                    result.add(String.format(MergeMessage.NOT_CHECKUP.getText(), orgNumber));
                    continue;
                }
                if (this.checkReportSubmit && !this.notCheckReportSubmitOrgNumbers.contains(orgNumber) && (parent = orgNode.getParent()) != null && !"Entity".equals(parent.getNumber()) && (currencyNode = BcmThreadCache.findMemberByNum((String)(modelNumber = MemberReader.findModelNumberById((Object)modelId)), (String)"Currency", (String)parent.getCurrency())) != IDNumberTreeNode.NotFoundTreeNode && !(notSubmitReportNumber = ReportServiceHelper.checkOrgReportCommitStatusWithCurrency(modelId, orgId, scenarioId, yearId, periodId, currencyNode.getId())).isEmpty()) {
                    result.add(String.format(MergeMessage.REPORT_NOT_SUBMIT.getText(), orgNumber));
                    continue;
                }
            }
            if ((taskId = mcData.getLong("flowtask.id")) != 0L) {
                DynamicObject curTask = (DynamicObject)this.taskMap.get(taskId);
                if (curTask == null) {
                    logger.debug("Flow task is not exist");
                    result.add(String.format(MergeMessage.NONE_TASK.getText(), orgNumber));
                    continue;
                }
                if (curTask.getInt("flowstep.sort") >= stepSort) {
                    result.add(String.format(MergeMessage.MUST_HIGN.getText(), orgNumber));
                    continue;
                }
            }
            this.checkedList.add(org);
        }
        return result;
    }

    @Override
    protected ResultBox submit() {
        ResultBox result = ResultBox.of();
        long stepId = this.ctx.getFlowStep().getLong("id");
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        String opinion = (String)resultMap.get("opinion");
        String opType = (String)resultMap.get("stageoptype");
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(this.checkedList.size());
        ArrayList<DynamicObject> mcList = new ArrayList<DynamicObject>(this.checkedList.size());
        for (DynamicObject dyn : this.checkedList) {
            long memberId = dyn.getLong("id");
            long taskId = GlobalIdUtil.genGlobalLongId();
            MergeData mergeData = (MergeData)this.mcDataMap.get(memberId);
            DynamicObject mcData = "EC".equals(ecOrPc) ? mergeData.getEcData() : mergeData.getPcData();
            long lastTaskId = mcData.getLong("flowtask.id");
            long lastStepId = mcData.getLong("flowtask.flowstep.id");
            mcData.set("flowtask", (Object)taskId);
            mcData.set("flowstatus", (Object)opType);
            mcList.add(mcData);
            DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"bcm_flowtask");
            task.set("id", (Object)taskId);
            task.set("bizid", (Object)mcData.getLong("id"));
            task.set("flowstep", (Object)stepId);
            task.set("laststep", (Object)lastStepId);
            task.set("lasttask", (Object)lastTaskId);
            task.set("action", (Object)opType);
            task.set("actor", (Object)UserServiceHelper.getCurrentUserId());
            task.set("finishtime", (Object)TimeServiceHelper.now());
            task.set("opinion", (Object)opinion);
            task.set("traceid", (Object)RequestContext.get().getTraceId());
            taskList.add(task);
        }
        try (TXHandle tx = TX.required();){
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.update((DynamicObject[])mcList.toArray(new DynamicObject[0]), (OperateOption)op);
                SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[0]));
                logger.debug(StageOpTypeEnum.getEnumByCode((String)opType).getText() + ResultStatusEnum.SUCCESS.getName() + mcList.size() + "/" + this.sortOrg.size());
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.toString());
            }
        }
        return result;
    }

    private boolean checkCurrentSceneCheckParam(long modelId, String sceneNumber) {
        Pair<Boolean, List<SceneSettingVo>> cm044SceneSetting = ConfigServiceHelper.getCM044SceneSetting(modelId);
        if (((Boolean)cm044SceneSetting.p1).booleanValue()) {
            for (SceneSettingVo sceneSettingVo : (List)cm044SceneSetting.p2) {
                if (!sceneNumber.equals(sceneSettingVo.getSceneNumber()) || !CM053TypeEnum.EXCEPTION.getValue().equals(sceneSettingVo.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

