/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.model.McContext;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.IMergeExecutor;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;

public class MergeArchiveExecutor
implements IMergeExecutor {
    public static final Log logger = LogFactory.getLog(MergeArchiveExecutor.class);
    protected McContext ctx;
    private Map<Long, MergeData> mcDataMap = new HashMap<Long, MergeData>();
    private List<DynamicObject> sortOrg = new ArrayList<DynamicObject>();
    private List<DynamicObject> checkedList = new ArrayList<DynamicObject>();
    private boolean OPEN_CM012 = false;
    private Set<String> periodStatusOpenOrgNumbers = new HashSet<String>();

    @Override
    public ResultBox doSubmit(McContext mcContext) {
        this.ctx = mcContext;
        this.init();
        ResultBox check = this.check();
        ResultBox result = this.submit();
        result.append(check);
        return result;
    }

    public void init() {
        Set<String> allVersionedOrgs;
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Collection<SimpleItem> orgList = this.ctx.getOrgList();
        List<Long> orgIds = orgList.stream().map(SimpleItem::getId).collect(Collectors.toList());
        this.sortOrg = this.getAllArchiveOrgList(modelId, orgIds);
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, this.ctx.getFyNum(), periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, this.sortOrg);
        Set<Long> noPermMembers = PermissionServiceImpl.getInstance(modelId).matchNoPermMembers(MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity"), "bcm_entitymembertree", orgIds);
        this.sortOrg = this.sortOrg.stream().filter(o -> !noPermMembers.contains(o.getLong("id"))).collect(Collectors.toList());
        if (MergeControlHelper.isQuoteScene(modelId, scenarioId) && !(allVersionedOrgs = MergeControlHelper.getAllVersionedOrgs(modelId, scenarioId, this.ctx.getFyId(), this.ctx.getPeriodId())).isEmpty()) {
            this.sortOrg = this.sortOrg.stream().filter(e -> allVersionedOrgs.contains(e.getString("number"))).collect(Collectors.toList());
        }
        List<Long> sortOrgIds = this.sortOrg.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        this.mcDataMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, yearId, periodId, sortOrgIds);
        Set<String> sortOrgNumbers = this.sortOrg.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        this.periodStatusOpenOrgNumbers = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, sortOrgNumbers, scenarioId, yearId, periodId, "datastatus");
        this.OPEN_CM012 = ConfigServiceHelper.getBoolParam(modelId, "CM012");
    }

    private List<DynamicObject> getAllArchiveOrgList(long modelId, List<Long> orgIds) {
        ArrayList<Long> scopeOrgIds = new ArrayList<Long>(orgIds.size());
        orgIds.forEach(orgId -> {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            if (orgNode.getId() > 0L) {
                scopeOrgIds.add((Long)orgId);
                if (!orgNode.isLeaf()) {
                    scopeOrgIds.addAll(orgNode.getAllChildrenIds());
                }
            }
        });
        DynamicObjectCollection sortOrg = OrgServiceHelper.getOrgList(modelId, scopeOrgIds);
        return sortOrg.stream().sorted(Comparator.comparingInt(org -> org.getInt("level"))).collect(Collectors.toList());
    }

    public ResultBox check() {
        ResultBox result = ResultBox.of();
        if (this.sortOrg.isEmpty()) {
            result.add(MergeMessage.EMPTY_DATA.getText());
            return result;
        }
        HashSet<String> dealOrgNumber = new HashSet<String>(this.sortOrg.size());
        this.checkedList = new ArrayList<DynamicObject>(this.sortOrg.size());
        for (DynamicObject org : this.sortOrg) {
            long orgId = org.getLong("id");
            String orgNumber = org.getString("number");
            if (!dealOrgNumber.add(orgNumber)) continue;
            if (this.OPEN_CM012 && !this.periodStatusOpenOrgNumbers.contains(orgNumber)) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNumber));
                continue;
            }
            MergeData mergeData = this.mcDataMap.get(orgId);
            McStatus mcStatus = mergeData.getMergeStatus();
            if (!mcStatus.getFlow().isFlowSubmit()) {
                result.addError(String.format(MergeMessage.NOT_SUBMIT.getText(), orgNumber));
                continue;
            }
            if (mcStatus.getArchive().isArchive()) {
                result.add(String.format(MergeMessage.HAS_ARCHIVE.getText(), orgNumber));
                continue;
            }
            this.checkedList.add(org);
        }
        return result;
    }

    protected ResultBox submit() {
        ResultBox result = ResultBox.of();
        ArrayList<DynamicObject> mcList = new ArrayList<DynamicObject>(this.checkedList.size());
        for (DynamicObject dyn : this.checkedList) {
            long memberId = dyn.getLong("id");
            MergeData mergeData = this.mcDataMap.get(memberId);
            DynamicObject mcData = mergeData.getEcData();
            mcData.set("archivestatus", (Object)"D");
            mcList.add(mcData);
        }
        try (TXHandle tx = TX.required();){
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.update((DynamicObject[])mcList.toArray(new DynamicObject[0]), (OperateOption)op);
                logger.debug(OpItemEnum.ARCHIVE.getName() + ResultStatusEnum.SUCCESS.getName() + mcList.size() + "/" + this.sortOrg.size());
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.toString());
            }
        }
        return result;
    }
}

