/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.flow;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.mergecontrol.custom.MergeCustomServiceHelper;
import kd.fi.bcm.business.mergecontrol.custom.MergeFlowCustomService;
import kd.fi.bcm.business.mergecontrol.flow.AbstractMergeFlowExecutor;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepServiceHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FlowStepTypeEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class MergeBackExecutor
extends AbstractMergeFlowExecutor {
    private Map<Long, MergeData> parentDataMap = new HashMap<Long, MergeData>(16);
    private Map<String, List<DynamicObject>> orgShareMap = new HashMap<String, List<DynamicObject>>(16);
    private boolean isBackNotCheckNotMergeOrg = false;
    private Table<String, String, Boolean> orgIsMergeTable = HashBasedTable.create();
    private Set<Long> sceneApplyOrgSchemeIds = new HashSet<Long>(16);

    @Override
    protected TreeMap<Integer, List<DynamicObject>> sortGroup() {
        Map<Integer, List<DynamicObject>> orgGroup = super.getOrgGroup();
        return new TreeMap<Integer, List<DynamicObject>>(orgGroup);
    }

    @Override
    protected void init() {
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        List<Long> orgIds = this.sortOrg.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        if (resultMap.containsKey("isApiCall")) {
            MergeData apiMegeData = MergeStatusService.getInstance().getOrInitMcData(modelId, scenarioId, yearId, periodId, (Long)orgIds.get(0), resultMap.get("apiCallCurrency").toString());
            this.mcDataMap.put(orgIds.get(0), apiMegeData);
        } else {
            this.mcDataMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, yearId, periodId, orgIds);
        }
        Set<String> orgNumbers = this.sortOrg.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        this.periodStatusOpenOrgNumbers = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, orgNumbers, scenarioId, yearId, periodId, "datastatus");
        this.OPEN_CM012 = ConfigServiceHelper.getBoolParam(modelId, "CM012");
        DynamicObjectCollection orgColl = OrgServiceHelper.getShareOrgList(modelId, this.sortOrg.stream().map(o -> o.getString("number")).collect(Collectors.toSet()));
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, this.ctx.getFyNum(), periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgColl);
        this.orgShareMap = orgColl.stream().collect(Collectors.groupingBy(o -> o.getString("number")));
        Set<Long> parentIds = orgColl.stream().map(o -> o.getLong("parent")).collect(Collectors.toSet());
        this.parentDataMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, yearId, periodId, parentIds);
        HashSet<Long> taskIds = new HashSet<Long>(orgIds.size());
        this.mcDataMap.forEach((orgId, mergeData) -> {
            DynamicObject mcData = "EC".equals(ecOrPc) ? mergeData.getEcData() : mergeData.getPcData();
            if (mcData != null) {
                long lastTaskId;
                long taskId = mcData.getLong("flowtask.id");
                if (taskId != 0L) {
                    taskIds.add(taskId);
                }
                if ((lastTaskId = mcData.getLong("flowtask.lasttask.id")) != 0L) {
                    taskIds.add(lastTaskId);
                }
            }
        });
        this.parentDataMap.forEach((parentId, pmcData) -> {
            long taskId;
            if (pmcData != null && pmcData.getEcData() != null && (taskId = pmcData.getEcData().getLong("flowtask.id")) != 0L) {
                taskIds.add(taskId);
            }
        });
        DynamicObjectCollection flowTasks = FlowStepServiceHelper.getFlowTasks(taskIds);
        this.taskMap = flowTasks.stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t));
        this.isBackNotCheckNotMergeOrg = ConfigServiceHelper.getBoolParam(modelId, "isBackCheckOrgIsMerge");
        this.orgIsMergeTable = InvestServiceHelper.getMergeStructInfoSetting(modelId, scenarioId, yearId, periodId);
        this.sceneApplyOrgSchemeIds = DimensionServiceHelper.getSceneApplyOrgSchemeIds(modelId, scenarioId);
    }

    @Override
    public ResultBox check() {
        ResultBox result = ResultBox.of();
        if (this.sortOrg.isEmpty()) {
            result.add(MergeMessage.EMPTY_DATA.getText());
            return result;
        }
        long modelId = this.ctx.getModelId();
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        Set<Long> orgIds = this.sortOrg.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        HashMap<Long, ResultBox> customCheckResult = new HashMap<Long, ResultBox>(16);
        if (!ConfigServiceHelper.getBoolParam(modelId, "isCustomCheckFlow")) {
            List<MergeFlowCustomService> customServiceList = MergeCustomServiceHelper.findCustomService();
            for (MergeFlowCustomService customService : customServiceList) {
                Map<Long, ResultBox> resultBoxMap = customService.customBackCheckFlow(modelId, this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId(), orgIds, "EC".equals(ecOrPc));
                if (resultBoxMap == null || resultBoxMap.isEmpty()) continue;
                customCheckResult.putAll(resultBoxMap);
            }
        }
        HashSet<Long> permOrgIds = new HashSet<Long>(16);
        this.checkedList = new ArrayList(this.sortOrg.size());
        for (DynamicObject org : this.sortOrg) {
            HashSet<String> tipNumbers;
            IDNumberTreeNode parentNode;
            Long parentId;
            List<DynamicObject> shareOrgs;
            long orgId = org.getLong("id");
            String orgNumber = org.getString("number");
            ResultBox resultBox = (ResultBox)customCheckResult.get(orgId);
            if (resultBox != null && resultBox.isNotSuccess()) {
                result.addError(resultBox.getMessageText());
                continue;
            }
            if (this.OPEN_CM012 && !this.periodStatusOpenOrgNumbers.contains(orgNumber)) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNumber));
                continue;
            }
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String ecCurrency = orgNode.getCurrency();
            String pcCurrency = null;
            if (orgNode.getParent() != null) {
                pcCurrency = orgNode.getParent().getCurrency();
            }
            if ("PC".equals(ecOrPc)) {
                if (orgNode.getParent() != null && "Entity".equals(orgNode.getParent().getNumber())) {
                    result.add(String.format(MergeMessage.ROOT_CANTPC.getText(), orgNumber));
                    continue;
                }
                if (Objects.equals(ecCurrency, pcCurrency)) {
                    result.add(String.format(MergeMessage.SKIP_NONEPC.getText(), orgNumber));
                    continue;
                }
            }
            MergeData mergeData = (MergeData)this.mcDataMap.get(orgId);
            McStatus mcStatus = mergeData.getMergeStatus();
            DynamicObject mcData = "EC".equals(ecOrPc) ? mergeData.getEcData() : mergeData.getPcData();
            String orgAndCurrency = "EC".equals(ecOrPc) ? orgNumber + '|' + ecCurrency : orgNumber + '|' + pcCurrency;
            if (!this.dealOrgNumber.add(orgAndCurrency)) continue;
            if (mcData == null) {
                result.add(String.format(MergeMessage.NONE_TASK.getText(), orgNumber));
                continue;
            }
            long taskId = mcData.getLong("flowtask.id");
            DynamicObject curTask = (DynamicObject)this.taskMap.get(taskId);
            if (curTask != null) {
                int stepSort = curTask.getInt("flowstep.sort");
                if (!this.mergeService.hasStepAuth(modelId, RequestContext.get().getCurrUserId(), stepSort, orgId)) {
                    result.add(String.format(MergeMessage.NONE_PERM.getText(), orgNumber));
                    continue;
                }
            }
            if ("EC".equals(ecOrPc) && mcStatus.getArchive().isArchive()) {
                result.add(String.format(MergeMessage.HAS_ARCHIVE.getText(), orgNumber));
                continue;
            }
            if (curTask == null) {
                String flowStatus = mcData.getString("flowstatus");
                if ("B".equals(flowStatus)) {
                    result.add(String.format(MergeMessage.NONE_TASK.getText(), orgNumber));
                    continue;
                }
            } else if (FlowStepTypeEnum.START.getValue().equals(curTask.getString("flowstep.steptype"))) {
                result.add(String.format(MergeMessage.HAS_PROCESSING.getText(), orgNumber));
                continue;
            }
            if ((shareOrgs = this.orgShareMap.get(orgNumber)) == null) continue;
            if ("EC".equals(ecOrPc)) {
                boolean isOpen;
                if (!mcStatus.getFlow().isSubmitOrApproval()) {
                    result.addError(String.format(MergeMessage.EC_FLOW_IN_PROCESS.getText(), orgNumber));
                    continue;
                }
                if (mcStatus.getConvertFlow().isFlowSubmit()) {
                    List<DynamicObject> allConvertData = mergeData.getAllConvertData();
                    HashSet<Object> pcOrgNumbers = new HashSet<Object>(shareOrgs.size());
                    for (DynamicObject orgDyn : shareOrgs) {
                        parentId = orgDyn.getLong("parent");
                        parentNode = MemberReader.findEntityMemberById((Long)modelId, (Long)parentId);
                        String parentNumber = parentNode.getNumber();
                        String parentCurrency = parentNode.getCurrency();
                        if (Objects.equals(parentCurrency, ecCurrency)) continue;
                        for (DynamicObject dyn : allConvertData) {
                            String currencyNumber = dyn.getString("currencynumber");
                            String flowStatus = dyn.getString("flowstatus");
                            String actionType = dyn.getString("flowtask.action");
                            if (!Objects.equals(currencyNumber, parentCurrency)) continue;
                            if ("C".equals(flowStatus)) {
                                pcOrgNumbers.add(parentNumber);
                            }
                            if (!StageOpTypeEnum.APPR.getCode().equals(actionType) || !"B".equals(flowStatus)) continue;
                            pcOrgNumbers.add(parentNumber);
                        }
                    }
                    if (!pcOrgNumbers.isEmpty()) {
                        result.add(String.format(MergeMessage.HAS_PCCOMMIT.getText(), orgNumber, String.join((CharSequence)",", pcOrgNumbers)));
                        continue;
                    }
                }
                if (!(isOpen = ParamSettingServiceHelper.getBoolean((long)modelId, (String)"isNotCheckDirectLevelStatus"))) {
                    tipNumbers = new HashSet<String>(shareOrgs.size());
                    int lastStep = 0;
                    long lastTaskId = mcData.getLong("flowtask.lasttask.id");
                    DynamicObject lastTask = (DynamicObject)this.taskMap.get(lastTaskId);
                    if (lastTask != null) {
                        lastStep = lastTask.getInt("flowstep.sort");
                    }
                    for (DynamicObject orgDyn : shareOrgs) {
                        String parentNumber;
                        MergeDataSourceEnum mergeDataSourceEnum;
                        boolean isSIRpt;
                        Long parentId2 = orgDyn.getLong("parent");
                        IDNumberTreeNode parentNode2 = MemberReader.findEntityMemberById((Long)modelId, (Long)parentId2);
                        if (!this.sceneApplyOrgSchemeIds.isEmpty() && !this.sceneApplyOrgSchemeIds.contains(parentNode2.getProperty("cslscheme.id")) || !(isSIRpt = (mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)this.ctx.getScenarioId(), (Object)this.ctx.getFyId(), (Object)this.ctx.getPeriodId(), parentId2)).getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex())) || "Entity".equals(parentNumber = parentNode2.getNumber()) || this.isBackNotCheckNotMergeOrg && Boolean.FALSE.equals(this.orgIsMergeTable.get((Object)parentNumber, (Object)orgNumber))) continue;
                        int parStep = 0;
                        MergeData pmcData = this.parentDataMap.get(parentId2);
                        if (pmcData != null && pmcData.getEcData() != null) {
                            if (pmcData.getMergeStatus().getFlow().isFlowSubmit()) {
                                tipNumbers.add(parentNumber);
                                continue;
                            }
                            long parTaskId = pmcData.getEcData().getLong("flowtask.id");
                            DynamicObject parTask = (DynamicObject)this.taskMap.get(parTaskId);
                            if (parTask != null) {
                                parStep = parTask.getInt("flowstep.sort");
                            }
                        }
                        if (lastStep >= parStep) continue;
                        tipNumbers.add(parentNumber);
                    }
                    if (!tipNumbers.isEmpty()) {
                        result.add(String.format(MergeMessage.CANT_LOW.getText(), orgNumber, String.join((CharSequence)",", tipNumbers)));
                        continue;
                    }
                }
            }
            if ("PC".equals(ecOrPc)) {
                if (!mcStatus.getPcFlow().isSubmitOrApproval()) {
                    result.addError(String.format(MergeMessage.PC_FLOW_IN_PROCESS.getText(), orgNumber));
                    continue;
                }
                boolean isOpen = ParamSettingServiceHelper.getBoolean((long)modelId, (String)"isNotCheckDirectLevelStatus");
                if (!isOpen) {
                    tipNumbers = new HashSet(shareOrgs.size());
                    for (DynamicObject orgDyn : shareOrgs) {
                        McStatus parentMc;
                        MergeDataSourceEnum mergeDataSourceEnum;
                        boolean isSIRpt;
                        parentId = orgDyn.getLong("parent");
                        parentNode = MemberReader.findEntityMemberById((Long)modelId, (Long)parentId);
                        if (!this.sceneApplyOrgSchemeIds.isEmpty() && !this.sceneApplyOrgSchemeIds.contains(parentNode.getProperty("cslscheme.id")) || !(isSIRpt = (mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)this.ctx.getScenarioId(), (Object)this.ctx.getFyId(), (Object)this.ctx.getPeriodId(), parentId)).getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex()))) continue;
                        String parentNumber = parentNode.getNumber();
                        String sharePcCurrency = parentNode.getCurrency();
                        if (!Objects.equals(pcCurrency, sharePcCurrency) || "Entity".equals(parentNumber) || this.isBackNotCheckNotMergeOrg && Boolean.FALSE.equals(this.orgIsMergeTable.get((Object)parentNumber, (Object)orgNumber)) || !(parentMc = this.parentDataMap.get(parentId).getMergeStatus()).getFlow().isFlowSubmit()) continue;
                        tipNumbers.add(parentNumber);
                    }
                    if (!tipNumbers.isEmpty()) {
                        result.add(String.format(MergeMessage.PARENT_HASSUBMIT.getText(), orgNumber, String.join((CharSequence)",", tipNumbers)));
                        continue;
                    }
                }
            }
            permOrgIds.add(orgId);
            if (orgNode.getParent() != IDNumberTreeNode.NotFoundTreeNode) {
                permOrgIds.add(orgNode.getParent().getId());
            }
            this.checkedList.add(org);
        }
        if (!permOrgIds.isEmpty()) {
            IDNumberTreeNode firstNode = MemberReader.findEntityMemberById((Long)modelId, (Long)((Long)permOrgIds.iterator().next()));
            PermissionService permissionService = PermissionServiceImpl.getInstance(modelId);
            Set<Long> writePermSet = permissionService.matchWritePermMembers(firstNode.getDimId(), "bcm_entitymembertree", permOrgIds);
            Iterator iterator = this.checkedList.iterator();
            while (iterator.hasNext()) {
                DynamicObject org = (DynamicObject)iterator.next();
                long orgId = org.getLong("id");
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                IDNumberTreeNode parentNode = orgNode.getParent();
                String orgNumber = orgNode.getNumber();
                boolean boolParam = ConfigServiceHelper.getBoolParam(modelId, ConfigEnum.CM021.getNumber());
                Set<Object> exceptOrgs = new HashSet(8);
                if (boolParam) {
                    exceptOrgs = MemberPermHelper.getExceptOrgs(modelId);
                }
                if (parentNode != IDNumberTreeNode.NotFoundTreeNode && !"Entity".equals(parentNode.getNumber()) && boolParam && !exceptOrgs.contains(orgNumber)) {
                    orgId = parentNode.getId();
                }
                if (writePermSet.contains(orgId)) continue;
                result.add(String.format(MergeMessage.NONE_PARENTPERM.getText(), orgNumber));
                iterator.remove();
            }
        }
        return result;
    }

    @Override
    protected ResultBox submit() {
        ResultBox result = ResultBox.of();
        long stepId = this.ctx.getFlowStep().getLong("id");
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        String opinion = (String)resultMap.get("opinion");
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(this.checkedList.size());
        ArrayList<DynamicObject> mcList = new ArrayList<DynamicObject>(this.checkedList.size());
        for (DynamicObject dyn : this.checkedList) {
            long memberId = dyn.getLong("id");
            long taskId = GlobalIdUtil.genGlobalLongId();
            MergeData mergeData = (MergeData)this.mcDataMap.get(memberId);
            DynamicObject mcData = "EC".equals(ecOrPc) ? mergeData.getEcData() : mergeData.getPcData();
            long curTaskId = mcData.getLong("flowtask.id");
            long curStepId = mcData.getLong("flowtask.flowstep.id");
            long lastTaskId = mcData.getLong("flowtask.lasttask.id");
            String lastOpType = "";
            if (lastTaskId != 0L) {
                DynamicObject lastTask = (DynamicObject)this.taskMap.get(lastTaskId);
                if (lastTask != null) {
                    String stepType = lastTask.getString("flowstep.steptype");
                    lastOpType = FlowStepTypeEnum.COMMIT.getValue().equals(stepType) ? StageOpTypeEnum.COMMIT.getCode() : (FlowStepTypeEnum.NOMAL.getValue().equals(stepType) ? StageOpTypeEnum.APPR.getCode() : "B");
                }
            } else {
                lastOpType = "B";
            }
            mcData.set("flowtask", (Object)lastTaskId);
            mcData.set("flowstatus", (Object)lastOpType);
            mcList.add(mcData);
            DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"bcm_flowtask");
            task.set("id", (Object)taskId);
            task.set("bizid", (Object)mcData.getLong("id"));
            task.set("flowstep", (Object)stepId);
            task.set("laststep", (Object)curStepId);
            task.set("lasttask", (Object)curTaskId);
            task.set("action", (Object)StageOpTypeEnum.BACK.getCode());
            task.set("actor", (Object)UserServiceHelper.getCurrentUserId());
            task.set("finishtime", (Object)TimeServiceHelper.now());
            task.set("opinion", (Object)opinion);
            task.set("traceid", (Object)RequestContext.get().getTraceId());
            taskList.add(task);
        }
        try (TXHandle tx = TX.required();){
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.update((DynamicObject[])mcList.toArray(new DynamicObject[0]), (OperateOption)op);
                SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.toString());
            }
        }
        return result;
    }
}

