/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.allinone.model.StageMcStatus;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.datalock.StageServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.mergecontrol.flow.AbstractMergeFlowExecutor;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepServiceHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class MergeStageApproveExecutor
extends AbstractMergeFlowExecutor {
    public static final Log logger = LogFactory.getLog(MergeStageApproveExecutor.class);
    private final Map<Long, DynamicObject> stageMap = new HashMap<Long, DynamicObject>(16);
    private long dataLockPlanId = 0L;
    private final Map<String, Long> stageLevelMap = new TreeMap<String, Long>();
    private boolean isCheckByStageLevel = false;

    @Override
    protected TreeMap<Integer, List<DynamicObject>> sortGroup() {
        Map<Integer, List<DynamicObject>> orgGroup = super.getOrgGroup();
        TreeMap<Integer, List<DynamicObject>> treeMap = new TreeMap<Integer, List<DynamicObject>>((o1, o2) -> o2 - o1);
        treeMap.putAll(orgGroup);
        return treeMap;
    }

    @Override
    protected void init() {
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        long stageId = this.getStageId();
        if (stageId > 0L) {
            List<Long> orgIds = this.sortOrg.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            Set<String> orgNumbers = this.sortOrg.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
            this.periodStatusOpenOrgNumbers = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, orgNumbers, scenarioId, yearId, periodId, "datastatus");
            this.OPEN_CM012 = ConfigServiceHelper.getBoolParam(modelId, "CM012");
            this.mcDataMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, yearId, periodId, orgIds);
            HashSet<Long> taskIds = new HashSet<Long>(orgIds.size());
            this.mcDataMap.forEach((orgId, mergeData) -> {
                if ("EC".equals(ecOrPc)) {
                    List<DynamicObject> ecStageMergeData = mergeData.getEcStageMergeDataList();
                    for (DynamicObject stageData : ecStageMergeData) {
                        taskIds.add(stageData.getLong("flowtask.id"));
                        if (stageId != stageData.getLong("lockstage.id")) continue;
                        this.stageMap.put((Long)orgId, stageData);
                    }
                } else {
                    List<DynamicObject> pcStageMergeData = mergeData.getPcStageMergeDataList();
                    for (DynamicObject stageData : pcStageMergeData) {
                        taskIds.add(stageData.getLong("flowtask.id"));
                        if (stageId != stageData.getLong("lockstage.id")) continue;
                        this.stageMap.put((Long)orgId, stageData);
                    }
                }
            });
            DynamicObjectCollection flowTasks = FlowStepServiceHelper.getFlowTasks(taskIds);
            this.taskMap = flowTasks.stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t));
            Pair<Long, List<Tuple<Long, String, String>>> dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo(modelId, scenarioId, yearId, periodId);
            if ((Long)dataLockPlanInfo.p1 > 0L) {
                this.dataLockPlanId = (Long)dataLockPlanInfo.p1;
                ((List)dataLockPlanInfo.p2).forEach(r -> this.stageLevelMap.put((String)r.p2, (Long)r.p1));
            }
        }
        this.isCheckByStageLevel = ConfigServiceHelper.getBoolParam(modelId, "isValidateStageSeq");
        this.checkReportSubmit = ConfigServiceHelper.getCM024CheckReportSubmit(modelId);
        if (this.checkReportSubmit) {
            this.notCheckReportSubmitOrgNumbers = ConfigServiceHelper.getCM024IgnoreCheckOrg(modelId, scenarioId, yearId, periodId);
        }
    }

    @Override
    protected ResultBox check() {
        ResultBox result = ResultBox.of();
        if (this.sortOrg.isEmpty()) {
            result.add(MergeMessage.EMPTY_DATA.getText());
            return result;
        }
        DynamicObject flowStep = this.ctx.getFlowStep();
        if (flowStep == null) {
            result.addError(MergeMessage.NONE_STEP.getText());
            return result;
        }
        long stageId = this.getStageId();
        if (stageId == 0L) {
            result.addError(MergeMessage.NONE_STAGE.getText());
            return result;
        }
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        long stepId = flowStep.getLong("id");
        int stepSort = flowStep.getInt("sort");
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String opType = (String)resultMap.get("stageoptype");
        String ecOrPc = (String)resultMap.get("isEc");
        Set<String> orgNumbers = this.sortOrg.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        Map<String, DynamicObject> org2Perm = this.mergeService.getApprPerm(modelId, orgNumbers);
        this.checkedList = new ArrayList(this.sortOrg.size());
        for (DynamicObject org : this.sortOrg) {
            StageMcStatus lastStageMcStatus;
            Long lastStageId;
            DynamicObject curTask;
            long stageTaskId;
            long orgId = org.getLong("id");
            String orgNumber = org.getString("number");
            if (this.OPEN_CM012 && !this.periodStatusOpenOrgNumbers.contains(orgNumber)) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNumber));
                continue;
            }
            boolean isLeaf = org.getBoolean("isleaf");
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String ecCurrency = orgNode.getCurrency();
            String pcCurrency = null;
            if (orgNode.getParent() != null) {
                pcCurrency = orgNode.getParent().getCurrency();
            }
            if ("PC".equals(ecOrPc)) {
                if (orgNode.getParent() != null && "Entity".equals(orgNode.getParent().getNumber())) {
                    result.add(String.format(MergeMessage.ROOT_CANTPC.getText(), orgNumber));
                    continue;
                }
                if (Objects.equals(ecCurrency, pcCurrency)) {
                    result.add(String.format(MergeMessage.SKIP_NONEPC.getText(), orgNumber));
                    continue;
                }
            }
            MergeData mergeData = (MergeData)this.mcDataMap.get(orgId);
            McStatus mcStatus = mergeData.getMergeStatus();
            boolean isCheckMergeStatus = ConfigServiceHelper.getBoolParam(modelId, "isFlowCommitByMergeStatus");
            Map<Long, StageMcStatus> stageMergeStatusMap = mergeData.getStageMergeStatusMap();
            StageMcStatus stageMcStatus = stageMergeStatusMap.getOrDefault(stageId, StageMcStatus.DefaultStageMcStatus);
            String org_currency_stage_key = "EC".equals(ecOrPc) ? orgNumber + '|' + ecCurrency + '|' + stageId : orgNumber + '|' + pcCurrency + '|' + stageId;
            if (!this.dealOrgNumber.add(org_currency_stage_key)) continue;
            if (!this.mergeService.checkApprPerm(org2Perm, orgNumber, stepId)) {
                result.add(String.format(MergeMessage.NONE_PERM.getText(), orgNumber));
                continue;
            }
            if (this.isOpECFlow()) {
                List<String> notSubmitReportNumber;
                String modelNumber;
                IDNumberTreeNode currencyNode;
                MergeDataSourceEnum mergeDataSourceEnum;
                boolean isSIRpt;
                stageTaskId = stageMcStatus.getEcFlowTaskId();
                if (stageTaskId != 0L) {
                    curTask = (DynamicObject)this.taskMap.get(stageTaskId);
                    if (curTask == null) {
                        logger.debug("Flow task is not exist");
                        result.add(String.format(MergeMessage.NONE_TASK.getText(), orgNumber));
                        continue;
                    }
                    if (curTask.getInt("flowstep.sort") >= stepSort) {
                        result.add(String.format(MergeMessage.MUST_HIGN.getText(), orgNumber));
                        continue;
                    }
                }
                if ((lastStageId = this.getLastStageId(stageId)) > 0L && !(lastStageMcStatus = stageMergeStatusMap.getOrDefault(lastStageId, StageMcStatus.DefaultStageMcStatus)).getFlow().isFlowSubmit()) {
                    result.addError(String.format(MergeMessage.LAST_STAGE_NOT_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (stageMcStatus.getFlow().isFlowSubmit()) {
                    result.addError(String.format(MergeMessage.STAGE_HAS_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (isLeaf && !mcStatus.getCalculate().isSuccess()) {
                    result.addError(String.format(MergeMessage.NOT_CALC.getText(), orgNumber));
                    continue;
                }
                if (!isLeaf) {
                    if (isCheckMergeStatus && !mcStatus.getMergeStatus().isSuccess()) {
                        result.addError(String.format(MergeMessage.NOT_MERGE.getText(), orgNumber));
                        continue;
                    }
                    if (!mcStatus.getCalculate().isSuccess()) {
                        result.addError(String.format(MergeMessage.NOT_CALC.getText(), orgNumber));
                        continue;
                    }
                }
                if (!isLeaf && (isSIRpt = (mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)scenarioId, (Object)yearId, (Object)periodId, orgId)).getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex()))) {
                    String subOrgNotCommitNumber;
                    String subOrgNumber = this.mergeService.checkSubLevelForStage(modelId, scenarioId, yearId, periodId, orgId, stepSort, stageId);
                    if (StringUtils.isNotEmpty((CharSequence)subOrgNumber)) {
                        result.add(String.format(MergeMessage.CANT_HIGN.getText(), orgNumber, subOrgNumber));
                        continue;
                    }
                    if (StageOpTypeEnum.COMMIT.getCode().equals(opType) && StringUtils.isNotEmpty((CharSequence)(subOrgNotCommitNumber = this.mergeService.checkSubPcStatusForStage(modelId, scenarioId, yearId, periodId, orgId, stageId)))) {
                        result.add(String.format(MergeMessage.HAS_PCNOTCOMMIT.getText(), orgNumber, subOrgNotCommitNumber));
                        continue;
                    }
                }
                if (this.checkReportSubmit && !this.notCheckReportSubmitOrgNumbers.contains(orgNumber) && (currencyNode = BcmThreadCache.findMemberByNum((String)(modelNumber = MemberReader.findModelNumberById((Object)modelId)), (String)"Currency", (String)orgNode.getCurrency())) != IDNumberTreeNode.NotFoundTreeNode && !(notSubmitReportNumber = ReportServiceHelper.checkOrgReportCommitStatusWithCurrencyAndStage(modelId, orgId, scenarioId, yearId, periodId, currencyNode.getId(), stageId)).isEmpty()) {
                    result.add(String.format(MergeMessage.REPORT_NOT_SUBMIT.getText(), orgNumber));
                    continue;
                }
            } else {
                List<String> notSubmitReportNumber;
                String modelNumber;
                IDNumberTreeNode currencyNode;
                IDNumberTreeNode parent;
                stageTaskId = stageMcStatus.getPcFlowTaskId();
                if (stageTaskId != 0L) {
                    curTask = (DynamicObject)this.taskMap.get(stageTaskId);
                    if (curTask == null) {
                        logger.debug("Flow task is not exist");
                        result.add(String.format(MergeMessage.NONE_TASK.getText(), orgNumber));
                        continue;
                    }
                    if (curTask.getInt("flowstep.sort") >= stepSort) {
                        result.add(String.format(MergeMessage.MUST_HIGN.getText(), orgNumber));
                        continue;
                    }
                }
                if ((lastStageId = this.getLastStageId(stageId)) > 0L && !(lastStageMcStatus = stageMergeStatusMap.getOrDefault(lastStageId, StageMcStatus.DefaultStageMcStatus)).getPcFlow().isFlowSubmit()) {
                    result.addError(String.format(MergeMessage.LAST_STAGE_PC_NOT_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (stageMcStatus.getPcFlow().isFlowSubmit()) {
                    result.addError(String.format(MergeMessage.STAGE_HAS_PC_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (!stageMcStatus.getFlow().isFlowSubmit()) {
                    result.add(String.format(MergeMessage.NOT_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (!mcStatus.getConvert().isSuccess()) {
                    result.add(String.format(MergeMessage.NOT_CONVERT.getText(), orgNumber));
                    continue;
                }
                if (this.checkReportSubmit && !this.notCheckReportSubmitOrgNumbers.contains(orgNumber) && (parent = orgNode.getParent()) != null && !"Entity".equals(parent.getNumber()) && (currencyNode = BcmThreadCache.findMemberByNum((String)(modelNumber = MemberReader.findModelNumberById((Object)modelId)), (String)"Currency", (String)parent.getCurrency())) != IDNumberTreeNode.NotFoundTreeNode && !(notSubmitReportNumber = ReportServiceHelper.checkOrgReportCommitStatusWithCurrencyAndStage(modelId, orgId, scenarioId, yearId, periodId, currencyNode.getId(), stageId)).isEmpty()) {
                    result.add(String.format(MergeMessage.REPORT_NOT_SUBMIT.getText(), orgNumber));
                    continue;
                }
            }
            this.checkedList.add(org);
        }
        return result;
    }

    @Override
    protected ResultBox submit() {
        ResultBox result = ResultBox.of();
        if (this.checkedList.isEmpty()) {
            return result;
        }
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        long stepId = this.ctx.getFlowStep().getLong("id");
        long stageId = this.getStageId();
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        String opinion = (String)resultMap.get("opinion");
        String opType = (String)resultMap.get("stageoptype");
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(this.checkedList.size());
        ArrayList<DynamicObject> mcSaveList = new ArrayList<DynamicObject>(this.checkedList.size());
        ArrayList<DynamicObject> mcUpdateList = new ArrayList<DynamicObject>(this.checkedList.size());
        ArrayList<Pair<String, String>> currencyOrgPairList = new ArrayList<Pair<String, String>>(this.checkedList.size());
        for (DynamicObject dyn : this.checkedList) {
            long memberId = dyn.getLong("id");
            long taskId = GlobalIdUtil.genGlobalLongId();
            MergeData mergeData = (MergeData)this.mcDataMap.get(memberId);
            DynamicObject mcData = "EC".equals(ecOrPc) ? mergeData.getEcData() : mergeData.getPcData();
            currencyOrgPairList.add((Pair<String, String>)Pair.onePair((Object)mcData.getString("currencynumber"), (Object)mcData.getString("orgnumber")));
            DynamicObject stageMcData = this.stageMap.get(memberId);
            long lastTaskId = 0L;
            long lastStepId = 0L;
            boolean isNewAdd = false;
            if (stageMcData == null) {
                stageMcData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_stagecontrolstatus");
                stageMcData.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                stageMcData.set("lockstage", (Object)stageId);
                isNewAdd = true;
            } else {
                lastTaskId = stageMcData.getLong("flowtask.id");
                lastStepId = stageMcData.getLong("flowtask.flowstep.id");
            }
            stageMcData.set("model", (Object)modelId);
            stageMcData.set("mergecontrol", (Object)mcData.getLong("id"));
            stageMcData.set("flowtask", (Object)taskId);
            stageMcData.set("flowstatus", (Object)opType);
            stageMcData.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
            stageMcData.set("modifytime", (Object)TimeServiceHelper.now());
            if (isNewAdd) {
                mcSaveList.add(stageMcData);
            } else {
                mcUpdateList.add(stageMcData);
            }
            DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"bcm_flowtask");
            task.set("id", (Object)taskId);
            task.set("bizid", (Object)mcData.getLong("id"));
            task.set("flowstep", (Object)stepId);
            task.set("laststep", (Object)lastStepId);
            task.set("lasttask", (Object)lastTaskId);
            task.set("action", (Object)opType);
            task.set("actor", (Object)UserServiceHelper.getCurrentUserId());
            task.set("finishtime", (Object)TimeServiceHelper.now());
            task.set("opinion", (Object)opinion);
            task.set("traceid", (Object)RequestContext.get().getTraceId());
            task.set("datalockplan", (Object)this.dataLockPlanId);
            task.set("lockstage", (Object)stageId);
            taskList.add(task);
        }
        try (TXHandle tx = TX.required();){
            try {
                if (!mcSaveList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])mcSaveList.toArray(new DynamicObject[0]));
                }
                if (!mcUpdateList.isEmpty()) {
                    SaveServiceHelper.update((DynamicObject[])mcUpdateList.toArray(new DynamicObject[0]));
                }
                SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[0]));
                LockScopeServiceHelper.mergeCommit(modelId, scenarioId, yearId, periodId, stageId, currencyOrgPairList);
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.getMessage());
            }
        }
        return result;
    }

    private boolean isOpECFlow() {
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        return "EC".equals(ecOrPc);
    }

    private long getStageId() {
        DynamicObject stage = this.ctx.getStage();
        if (stage != null) {
            return stage.getLong("id");
        }
        return 0L;
    }

    private Long getLastStageId(Long currentStageId) {
        long lastStageId = 0L;
        if (this.isCheckByStageLevel) {
            List<Long> stageIdList = this.getCurrentStageIdList();
            int currentIndex = 0;
            for (int i = 0; i < stageIdList.size(); ++i) {
                if (!stageIdList.get(i).equals(currentStageId)) continue;
                currentIndex = i;
            }
            if (currentIndex > 0) {
                lastStageId = stageIdList.get(currentIndex - 1);
            }
        }
        return lastStageId;
    }

    private List<Long> getCurrentStageIdList() {
        ArrayList<Long> stageIdList = new ArrayList<Long>(5);
        for (Map.Entry<String, Long> entry : this.stageLevelMap.entrySet()) {
            stageIdList.add(entry.getValue());
        }
        return stageIdList;
    }
}

