/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.flow;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.allinone.model.StageMcStatus;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.datalock.StageServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.mergecontrol.flow.AbstractMergeFlowExecutor;
import kd.fi.bcm.business.mergecontrol.flow.FlowStepServiceHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FlowStepTypeEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class MergeStageBackExecutor
extends AbstractMergeFlowExecutor {
    private Map<Long, MergeData> parentDataMap = new HashMap<Long, MergeData>(16);
    private Map<String, List<DynamicObject>> orgShareMap = new HashMap<String, List<DynamicObject>>(16);
    private boolean isBackNotCheckNotMergeOrg = false;
    private Table<String, String, Boolean> orgIsMergeTable = HashBasedTable.create();
    private Set<Long> sceneApplyOrgSchemeIds = new HashSet<Long>(16);
    private final Map<Long, DynamicObject> stageMap = new HashMap<Long, DynamicObject>(16);
    private long dataLockPlanId = 0L;
    private final Map<String, Long> stageLevelMap = new TreeMap<String, Long>();
    private boolean isCheckByStageLevel = false;

    @Override
    protected TreeMap<Integer, List<DynamicObject>> sortGroup() {
        Map<Integer, List<DynamicObject>> orgGroup = super.getOrgGroup();
        return new TreeMap<Integer, List<DynamicObject>>(orgGroup);
    }

    @Override
    protected void init() {
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        long stageId = this.getStageId();
        if (stageId > 0L) {
            List<Long> orgIds = this.sortOrg.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            this.mcDataMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, yearId, periodId, orgIds);
            Set<String> orgNumbers = this.sortOrg.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
            this.periodStatusOpenOrgNumbers = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, orgNumbers, scenarioId, yearId, periodId, "datastatus");
            this.OPEN_CM012 = ConfigServiceHelper.getBoolParam(modelId, "CM012");
            DynamicObjectCollection orgColl = OrgServiceHelper.getShareOrgList(modelId, this.sortOrg.stream().map(o -> o.getString("number")).collect(Collectors.toSet()));
            FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, this.ctx.getFyNum(), periodId);
            EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgColl);
            this.orgShareMap = orgColl.stream().collect(Collectors.groupingBy(o -> o.getString("number")));
            Set<Long> parentIds = orgColl.stream().map(o -> o.getLong("parent")).collect(Collectors.toSet());
            this.parentDataMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, yearId, periodId, parentIds);
            HashSet<Long> taskIds = new HashSet<Long>(orgIds.size());
            this.mcDataMap.forEach((orgId, mergeData) -> {
                if ("EC".equals(ecOrPc)) {
                    List<DynamicObject> ecStageMergeData = mergeData.getEcStageMergeDataList();
                    for (DynamicObject stageData : ecStageMergeData) {
                        long lastTaskId;
                        long taskId = stageData.getLong("flowtask.id");
                        if (taskId != 0L) {
                            taskIds.add(taskId);
                        }
                        if ((lastTaskId = stageData.getLong("flowtask.lasttask.id")) != 0L) {
                            taskIds.add(lastTaskId);
                        }
                        if (stageId != stageData.getLong("lockstage.id")) continue;
                        this.stageMap.put((Long)orgId, stageData);
                    }
                } else {
                    List<DynamicObject> pcStageMergeData = mergeData.getPcStageMergeDataList();
                    for (DynamicObject stageData : pcStageMergeData) {
                        long lastTaskId;
                        long taskId = stageData.getLong("flowtask.id");
                        if (taskId != 0L) {
                            taskIds.add(taskId);
                        }
                        if ((lastTaskId = stageData.getLong("flowtask.lasttask.id")) != 0L) {
                            taskIds.add(lastTaskId);
                        }
                        if (stageId != stageData.getLong("lockstage.id")) continue;
                        this.stageMap.put((Long)orgId, stageData);
                    }
                }
            });
            this.parentDataMap.forEach((parentId, pmcData) -> {
                if (pmcData != null && pmcData.getEcData() != null) {
                    List<DynamicObject> pEcStageMergeData = pmcData.getEcStageMergeDataList();
                    for (DynamicObject stageData : pEcStageMergeData) {
                        taskIds.add(stageData.getLong("flowtask.id"));
                        if (stageId != stageData.getLong("lockstage.id")) continue;
                        this.stageMap.put((Long)parentId, stageData);
                    }
                    long taskId = pmcData.getEcData().getLong("flowtask.id");
                    if (taskId != 0L) {
                        taskIds.add(taskId);
                    }
                }
            });
            DynamicObjectCollection flowTasks = FlowStepServiceHelper.getFlowTasks(taskIds);
            this.taskMap = flowTasks.stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t));
            this.isBackNotCheckNotMergeOrg = ConfigServiceHelper.getBoolParam(modelId, "isBackCheckOrgIsMerge");
            this.orgIsMergeTable = InvestServiceHelper.getMergeStructInfoSetting(modelId, scenarioId, yearId, periodId);
            this.sceneApplyOrgSchemeIds = DimensionServiceHelper.getSceneApplyOrgSchemeIds(modelId, scenarioId);
            Pair<Long, List<Tuple<Long, String, String>>> dataLockPlanInfo = StageServiceHelper.getDataLockPlanInfo(modelId, scenarioId, yearId, periodId);
            if ((Long)dataLockPlanInfo.p1 > 0L) {
                this.dataLockPlanId = (Long)dataLockPlanInfo.p1;
                ((List)dataLockPlanInfo.p2).forEach(r -> this.stageLevelMap.put((String)r.p2, (Long)r.p1));
            }
        }
        this.isCheckByStageLevel = ConfigServiceHelper.getBoolParam(modelId, "isValidateStageSeq");
    }

    @Override
    public ResultBox check() {
        ResultBox result = ResultBox.of();
        if (this.sortOrg.isEmpty()) {
            result.add(MergeMessage.EMPTY_DATA.getText());
            return result;
        }
        long stageId = this.getStageId();
        if (stageId == 0L) {
            result.addError(MergeMessage.NONE_STAGE.getText());
            return result;
        }
        long modelId = this.ctx.getModelId();
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        HashSet<Long> permOrgIds = new HashSet<Long>(16);
        this.checkedList = new ArrayList(this.sortOrg.size());
        for (DynamicObject org : this.sortOrg) {
            HashSet<String> tipNumbers;
            IDNumberTreeNode parentNode;
            Long parentId;
            List<DynamicObject> shareOrgs;
            DynamicObject curTask;
            long stageTaskId;
            long orgId = org.getLong("id");
            String orgNumber = org.getString("number");
            if (this.OPEN_CM012 && !this.periodStatusOpenOrgNumbers.contains(orgNumber)) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNumber));
                continue;
            }
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            String ecCurrency = orgNode.getCurrency();
            String pcCurrency = null;
            if (orgNode.getParent() != null) {
                pcCurrency = orgNode.getParent().getCurrency();
            }
            if ("PC".equals(ecOrPc)) {
                if (orgNode.getParent() != null && "Entity".equals(orgNode.getParent().getNumber())) {
                    result.add(String.format(MergeMessage.ROOT_CANTPC.getText(), orgNumber));
                    continue;
                }
                if (Objects.equals(ecCurrency, pcCurrency)) {
                    result.add(String.format(MergeMessage.SKIP_NONEPC.getText(), orgNumber));
                    continue;
                }
            }
            MergeData mergeData = (MergeData)this.mcDataMap.get(orgId);
            Map<Long, StageMcStatus> stageMergeStatusMap = mergeData.getStageMergeStatusMap();
            Map<Long, List<DynamicObject>> stageAllConvertDataMap = mergeData.getStageAllConvertDataMap();
            StageMcStatus stageMcStatus = stageMergeStatusMap.getOrDefault(stageId, StageMcStatus.DefaultStageMcStatus);
            String org_currency_stage_key = "EC".equals(ecOrPc) ? orgNumber + '|' + ecCurrency + '|' + stageId : orgNumber + '|' + pcCurrency + '|' + stageId;
            if (!this.dealOrgNumber.add(org_currency_stage_key)) continue;
            long l = stageTaskId = "EC".equals(ecOrPc) ? stageMcStatus.getEcFlowTaskId() : stageMcStatus.getPcFlowTaskId();
            if (stageTaskId > 0L && (curTask = (DynamicObject)this.taskMap.get(stageTaskId)) != null) {
                int stepSort = curTask.getInt("flowstep.sort");
                if (!this.mergeService.hasStepAuth(modelId, RequestContext.get().getCurrUserId(), stepSort, orgId)) {
                    result.add(String.format(MergeMessage.NONE_PERM.getText(), orgNumber));
                    continue;
                }
            }
            if ((shareOrgs = this.orgShareMap.get(orgNumber)) == null) continue;
            if ("EC".equals(ecOrPc)) {
                boolean isOpen;
                StageMcStatus nextEcStageMcStatus;
                if (!stageMcStatus.getFlow().isSubmitOrApproval()) {
                    result.addError(String.format(MergeMessage.STAGE_EC_FLOW_IN_PROCESS.getText(), orgNumber));
                    continue;
                }
                Long nextStageId = this.getNextStageId(stageId);
                if (nextStageId > 0L && (nextEcStageMcStatus = stageMergeStatusMap.getOrDefault(nextStageId, StageMcStatus.DefaultStageMcStatus)).getFlow().isSubmitOrApproval()) {
                    result.addError(String.format(MergeMessage.NEXT_STAGE_HAS_SUBMIT.getText(), orgNumber));
                    continue;
                }
                if (stageMcStatus.isExistOneConvertSubmit()) {
                    List<DynamicObject> allConvertData = stageAllConvertDataMap.get(stageId);
                    HashSet<String> pcOrgNumbers = new HashSet<String>(shareOrgs.size());
                    for (DynamicObject orgDyn : shareOrgs) {
                        parentId = orgDyn.getLong("parent");
                        parentNode = MemberReader.findEntityMemberById((Long)modelId, (Long)parentId);
                        String parentNumber = parentNode.getNumber();
                        String parentCurrency = parentNode.getCurrency();
                        if (Objects.equals(parentCurrency, ecCurrency)) continue;
                        for (DynamicObject dyn : allConvertData) {
                            String currencyNumber = dyn.getString("mergecontrol.currencynumber");
                            String flowStatus = dyn.getString("flowstatus");
                            String actionType = dyn.getString("flowtask.action");
                            if (!Objects.equals(currencyNumber, parentCurrency)) continue;
                            if ("C".equals(flowStatus)) {
                                pcOrgNumbers.add(parentNumber);
                            }
                            if (!StageOpTypeEnum.APPR.getCode().equals(actionType) || !"B".equals(flowStatus)) continue;
                            pcOrgNumbers.add(parentNumber);
                        }
                    }
                    if (!pcOrgNumbers.isEmpty()) {
                        result.add(String.format(MergeMessage.HAS_PCCOMMIT.getText(), orgNumber, String.join((CharSequence)",", pcOrgNumbers)));
                        continue;
                    }
                }
                if (!(isOpen = ParamSettingServiceHelper.getBoolean((long)modelId, (String)"isNotCheckDirectLevelStatus"))) {
                    long lastTaskId;
                    DynamicObject lastTask;
                    tipNumbers = new HashSet<String>(shareOrgs.size());
                    int lastStep = 0;
                    DynamicObject stageMergeStatusDy = this.stageMap.get(orgId);
                    if (stageMergeStatusDy != null && (lastTask = (DynamicObject)this.taskMap.get(lastTaskId = stageMergeStatusDy.getLong("flowtask.lasttask.id"))) != null) {
                        lastStep = lastTask.getInt("flowstep.sort");
                    }
                    for (DynamicObject orgDyn : shareOrgs) {
                        Map<Long, StageMcStatus> pStageMergeStatusMap;
                        StageMcStatus pStageMcStatus;
                        long parentTaskId;
                        DynamicObject parTask;
                        String parentNumber;
                        MergeDataSourceEnum mergeDataSourceEnum;
                        boolean isSIRpt;
                        Long parentId2 = orgDyn.getLong("parent");
                        IDNumberTreeNode parentNode2 = MemberReader.findEntityMemberById((Long)modelId, (Long)parentId2);
                        if (!this.sceneApplyOrgSchemeIds.isEmpty() && !this.sceneApplyOrgSchemeIds.contains(parentNode2.getProperty("cslscheme.id")) || !(isSIRpt = (mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)this.ctx.getScenarioId(), (Object)this.ctx.getFyId(), (Object)this.ctx.getPeriodId(), parentId2)).getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex())) || "Entity".equals(parentNumber = parentNode2.getNumber()) || this.isBackNotCheckNotMergeOrg && Boolean.FALSE.equals(this.orgIsMergeTable.get((Object)parentNumber, (Object)orgNumber))) continue;
                        int parStep = 0;
                        MergeData pmcData = this.parentDataMap.get(parentId2);
                        if (pmcData != null && pmcData.getEcData() != null && (parTask = (DynamicObject)this.taskMap.get(parentTaskId = (pStageMcStatus = (pStageMergeStatusMap = pmcData.getStageMergeStatusMap()).getOrDefault(stageId, StageMcStatus.DefaultStageMcStatus)).getEcFlowTaskId())) != null) {
                            parStep = parTask.getInt("flowstep.sort");
                        }
                        if (lastStep >= parStep) continue;
                        tipNumbers.add(parentNumber);
                    }
                    if (!tipNumbers.isEmpty()) {
                        result.add(String.format(MergeMessage.CANT_LOW.getText(), orgNumber, String.join((CharSequence)",", tipNumbers)));
                        continue;
                    }
                }
            }
            if ("PC".equals(ecOrPc)) {
                StageMcStatus nextPcStageMcStatus;
                if (!stageMcStatus.getPcFlow().isSubmitOrApproval()) {
                    result.addError(String.format(MergeMessage.STAGE_PC_FLOW_IN_PROCESS.getText(), orgNumber));
                    continue;
                }
                Long nextStageId = this.getNextStageId(stageId);
                if (nextStageId > 0L && (nextPcStageMcStatus = stageMergeStatusMap.getOrDefault(nextStageId, StageMcStatus.DefaultStageMcStatus)).getPcFlow().isFlowSubmit()) {
                    result.addError(String.format(MergeMessage.NEXT_STAGE_PC_HAS_SUBMIT.getText(), orgNumber));
                    continue;
                }
                boolean isOpen = ParamSettingServiceHelper.getBoolean((long)modelId, (String)"isNotCheckDirectLevelStatus");
                if (!isOpen) {
                    tipNumbers = new HashSet(shareOrgs.size());
                    for (DynamicObject orgDyn : shareOrgs) {
                        Map<Long, StageMcStatus> pStageMergeStatusMap;
                        StageMcStatus pStageMcStatus;
                        MergeDataSourceEnum mergeDataSourceEnum;
                        boolean isSIRpt;
                        parentId = orgDyn.getLong("parent");
                        parentNode = MemberReader.findEntityMemberById((Long)modelId, (Long)parentId);
                        if (!this.sceneApplyOrgSchemeIds.isEmpty() && !this.sceneApplyOrgSchemeIds.contains(parentNode.getProperty("cslscheme.id")) || !(isSIRpt = (mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)this.ctx.getScenarioId(), (Object)this.ctx.getFyId(), (Object)this.ctx.getPeriodId(), parentId)).getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex()))) continue;
                        String parentNumber = parentNode.getNumber();
                        String sharePcCurrency = parentNode.getCurrency();
                        if (!Objects.equals(pcCurrency, sharePcCurrency) || "Entity".equals(parentNumber) || this.isBackNotCheckNotMergeOrg && Boolean.FALSE.equals(this.orgIsMergeTable.get((Object)parentNumber, (Object)orgNumber)) || !(pStageMcStatus = (pStageMergeStatusMap = this.parentDataMap.get(parentId).getStageMergeStatusMap()).getOrDefault(stageId, StageMcStatus.DefaultStageMcStatus)).getFlow().isFlowSubmit()) continue;
                        tipNumbers.add(parentNumber);
                    }
                    if (!tipNumbers.isEmpty()) {
                        result.add(String.format(MergeMessage.PARENT_HASSUBMIT.getText(), orgNumber, String.join((CharSequence)",", tipNumbers)));
                        continue;
                    }
                }
            }
            permOrgIds.add(orgId);
            if (orgNode.getParent() != IDNumberTreeNode.NotFoundTreeNode) {
                permOrgIds.add(orgNode.getParent().getId());
            }
            this.checkedList.add(org);
        }
        if (!permOrgIds.isEmpty()) {
            IDNumberTreeNode firstNode = MemberReader.findEntityMemberById((Long)modelId, (Long)((Long)permOrgIds.iterator().next()));
            PermissionService permissionService = PermissionServiceImpl.getInstance(modelId);
            Set<Long> writePermSet = permissionService.matchWritePermMembers(firstNode.getDimId(), "bcm_entitymembertree", permOrgIds);
            Iterator iterator = this.checkedList.iterator();
            while (iterator.hasNext()) {
                DynamicObject org = (DynamicObject)iterator.next();
                long orgId = org.getLong("id");
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                IDNumberTreeNode parentNode = orgNode.getParent();
                String orgNumber = orgNode.getNumber();
                boolean boolParam = ConfigServiceHelper.getBoolParam(modelId, ConfigEnum.CM021.getNumber());
                Set<Object> exceptOrgs = new HashSet(8);
                if (boolParam) {
                    exceptOrgs = MemberPermHelper.getExceptOrgs(modelId);
                }
                if (parentNode != IDNumberTreeNode.NotFoundTreeNode && !"Entity".equals(parentNode.getNumber()) && boolParam && !exceptOrgs.contains(orgNumber)) {
                    orgId = parentNode.getId();
                }
                if (writePermSet.contains(orgId)) continue;
                result.add(String.format(MergeMessage.NONE_PARENTPERM.getText(), orgNumber));
                iterator.remove();
            }
        }
        return result;
    }

    @Override
    protected ResultBox submit() {
        ResultBox result = ResultBox.of();
        if (this.checkedList.isEmpty()) {
            return result;
        }
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long yearId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        long stepId = this.ctx.getFlowStep().getLong("id");
        long stageId = this.getStageId();
        Map<String, Object> resultMap = this.ctx.getDataMap();
        String ecOrPc = (String)resultMap.get("isEc");
        String opinion = (String)resultMap.get("opinion");
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(this.checkedList.size());
        ArrayList<DynamicObject> mcList = new ArrayList<DynamicObject>(this.checkedList.size());
        ArrayList<Pair<String, String>> currencyOrgPairList = new ArrayList<Pair<String, String>>(this.checkedList.size());
        for (DynamicObject dyn : this.checkedList) {
            long memberId = dyn.getLong("id");
            long taskId = GlobalIdUtil.genGlobalLongId();
            MergeData mergeData = (MergeData)this.mcDataMap.get(memberId);
            DynamicObject mcData = "EC".equals(ecOrPc) ? mergeData.getEcData() : mergeData.getPcData();
            DynamicObject stageMcData = this.stageMap.get(memberId);
            if (stageMcData == null) continue;
            long curTaskId = stageMcData.getLong("flowtask.id");
            long curStepId = stageMcData.getLong("flowtask.flowstep.id");
            long lastTaskId = stageMcData.getLong("flowtask.lasttask.id");
            String lastOpType = "";
            if (lastTaskId != 0L) {
                DynamicObject lastTask = (DynamicObject)this.taskMap.get(lastTaskId);
                if (lastTask != null) {
                    String stepType = lastTask.getString("flowstep.steptype");
                    if (FlowStepTypeEnum.COMMIT.getValue().equals(stepType)) {
                        lastOpType = StageOpTypeEnum.COMMIT.getCode();
                    } else if (FlowStepTypeEnum.NOMAL.getValue().equals(stepType)) {
                        lastOpType = StageOpTypeEnum.APPR.getCode();
                    } else {
                        lastOpType = "B";
                        currencyOrgPairList.add((Pair<String, String>)Pair.onePair((Object)mcData.getString("currencynumber"), (Object)mcData.getString("orgnumber")));
                    }
                }
            } else {
                currencyOrgPairList.add((Pair<String, String>)Pair.onePair((Object)mcData.getString("currencynumber"), (Object)mcData.getString("orgnumber")));
                lastOpType = "B";
            }
            stageMcData.set("flowtask", (Object)lastTaskId);
            stageMcData.set("flowstatus", (Object)lastOpType);
            mcList.add(stageMcData);
            DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"bcm_flowtask");
            task.set("id", (Object)taskId);
            task.set("bizid", (Object)mcData.getLong("id"));
            task.set("flowstep", (Object)stepId);
            task.set("laststep", (Object)curStepId);
            task.set("lasttask", (Object)curTaskId);
            task.set("action", (Object)StageOpTypeEnum.BACK.getCode());
            task.set("actor", (Object)UserServiceHelper.getCurrentUserId());
            task.set("finishtime", (Object)TimeServiceHelper.now());
            task.set("opinion", (Object)opinion);
            task.set("traceid", (Object)RequestContext.get().getTraceId());
            task.set("datalockplan", (Object)this.dataLockPlanId);
            task.set("lockstage", (Object)stageId);
            taskList.add(task);
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.update((DynamicObject[])mcList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])taskList.toArray(new DynamicObject[0]));
                LockScopeServiceHelper.mergeBack(modelId, scenarioId, yearId, periodId, stageId, currencyOrgPairList);
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.toString());
            }
        }
        return result;
    }

    private long getStageId() {
        DynamicObject stage = this.ctx.getStage();
        if (stage != null) {
            return stage.getLong("id");
        }
        return 0L;
    }

    private Long getNextStageId(Long currentStageId) {
        long lastStageId = 0L;
        if (this.isCheckByStageLevel) {
            List<Long> stageIdList = this.getCurrentStageIdList();
            int currentIndex = 0;
            for (int i = 0; i < stageIdList.size(); ++i) {
                if (!stageIdList.get(i).equals(currentStageId)) continue;
                currentIndex = i;
            }
            if (currentIndex + 1 < stageIdList.size()) {
                lastStageId = stageIdList.get(currentIndex + 1);
            }
        }
        return lastStageId;
    }

    private List<Long> getCurrentStageIdList() {
        ArrayList<Long> stageIdList = new ArrayList<Long>(5);
        for (Map.Entry<String, Long> entry : this.stageLevelMap.entrySet()) {
            stageIdList.add(entry.getValue());
        }
        return stageIdList;
    }
}

