/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.versioned;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.mergecontrol.MergeEntityService;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.mergecontrol.versioned.DataVersionedExecutor;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.model.ResultBox;

public class DataCancelVersionedExecutor
extends DataVersionedExecutor {
    Map<Long, MergeData> mcDataMap = new HashMap<Long, MergeData>();

    @Override
    public ResultBox check() {
        ResultBox result = ResultBox.of();
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long fyId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Set<String> versionedOrgNumbers = this.meService.getAllVersionedOrgs(modelId, scenarioId, fyId, periodId);
        Set<String> periodStatusOpenOrgNumbers = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, this.orgNumbers, scenarioId, fyId, periodId, "datastatus");
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        Set<Long> writePermMembers = PermissionServiceImpl.getInstance(modelId).matchWritePermMembers(dimId, "bcm_entitymembertree", this.orgIds);
        this.mcDataMap = MergeStatusService.getInstance().batchLoadMcData(modelId, scenarioId, fyId, periodId, this.orgIds);
        this.orgIds.removeIf(o -> {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)o);
            if (!versionedOrgNumbers.contains(orgNode.getNumber())) {
                result.add(String.format(MergeMessage.NOT_VERSIONED.getText(), orgNode.getNumber()));
                return true;
            }
            if (this.OPEN_CM012 && !periodStatusOpenOrgNumbers.contains(orgNode.getNumber())) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNode.getNumber()));
                return true;
            }
            if (!writePermMembers.contains(orgNode.getId())) {
                result.add(String.format(MergeMessage.NONE_WRITEPERM.getText(), orgNode.getNumber()));
                return true;
            }
            MergeData mergeData = this.mcDataMap.get(o);
            if (mergeData != null && mergeData.getMergeStatus().getArchive().isArchive()) {
                result.add(String.format(MergeMessage.HAS_ARCHIVE.getText(), orgNode.getNumber()));
                return true;
            }
            if (mergeData != null && mergeData.getMergeStatus().getFlow().isFlowSubmit()) {
                result.add(String.format(MergeMessage.HAS_SUBMIT.getText(), orgNode.getNumber()));
                return true;
            }
            return false;
        });
        return result;
    }

    @Override
    protected ResultBox submit() {
        DynamicObject[] mcData;
        ResultBox result = ResultBox.of();
        if (this.orgIds.isEmpty()) {
            return result;
        }
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long fyId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        for (DynamicObject dyn : mcData = MergeEntityService.getInstance().batchLoadMcData(modelId, scenarioId, fyId, periodId, this.orgIds)) {
            dyn.set("isversioned", (Object)false);
            dyn.set("modifytime", (Object)TimeServiceHelper.now());
        }
        if (mcData.length == 0) {
            return result;
        }
        try (TXHandle tx = TX.required();){
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.save((DynamicObject[])mcData, (OperateOption)op);
                this.execCubeDataScope();
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.getMessage());
            }
        }
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey(this.meService.packKey(modelId, scenarioId, fyId, periodId));
        return result;
    }

    @Override
    protected void execCubeDataScope() {
        long modelId = this.ctx.getModelId();
        Collection<String> orgNumbers = this.meService.getOrgNumber4Id(modelId, this.orgIds);
        HashSet<String> versionedOrgs = new HashSet<String>(orgNumbers);
        for (String orgNumber : orgNumbers) {
            IDNumberTreeNode org = MemberReader.findEntityMemberByNum((String)this.ctx.getModelNum(), (String)orgNumber);
            OrgBuilder build = OrgBuilder.build(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
            OrgNode orgNode = build.genOrgNode(org.getId());
            build.extendDirectChildren(orgNode);
            PairList<Long, String> pair = orgNode.getMergeChildrenRelaWithParentPair();
            versionedOrgs.addAll(pair.toList().stream().map(p -> (String)p.p2).collect(Collectors.toSet()));
        }
        PairList pairList = new PairList();
        if (!versionedOrgs.isEmpty()) {
            pairList.addPair((Object)PresetConstant.FY_DIM, (Object)this.ctx.getFyNum());
            pairList.addPair((Object)PresetConstant.PERIOD_DIM, (Object)this.ctx.getPeriodNum());
            pairList.addPair((Object)PresetConstant.ENTITY_DIM, versionedOrgs);
        }
        OlapServiceHelper.removePointScope(this.ctx.getModelNum(), this.ctx.getScenariodNum(), (PairList<String, Object>)pairList);
    }
}

