/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.versioned;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustAutoCopyOperation;
import kd.fi.bcm.business.adjust.operation.AdjustClearOperation;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataSourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;

public class DataVersionCopyService {
    protected FixedItem _item;
    protected SimpleItem targetScenario;

    private DataVersionCopyService() {
    }

    public static DataVersionCopyService getInstance() {
        return new DataVersionCopyService();
    }

    public void executeService(FixedItem ctx, SimpleItem targetScenario) {
        this.targetScenario = targetScenario;
        this._item = ctx;
        this.doExecute();
    }

    protected void doExecute() {
        this.copyElimOlapData();
    }

    private void copyElimOlapData() {
        this.copyProcessOlap("IRpt");
        this.copyProcessOlap("RAdj");
    }

    private void copyProcessOlap(String processNumber) {
        RunScriptBuilder run = new RunScriptBuilder(this._item.getModel().getNumber());
        PairList leftV = new PairList();
        leftV.addPair((Object)PresetConstant.SCENE_DIM, (Object)this.targetScenario.number);
        run.appendV((PairList<String, String>)leftV);
        run.appendEqualSign();
        PairList rigthV = new PairList();
        rigthV.addPair((Object)PresetConstant.SCENE_DIM, (Object)this._item.getScenario().number);
        run.appendV((PairList<String, String>)rigthV);
        run.endRunExpress();
        run.addDimensionScope(PresetConstant.FY_DIM, this._item.getFy().number);
        run.addDimensionScope(PresetConstant.PERIOD_DIM, this._item.getPeriod().number);
        Set<String> orgNumbers = this._item.getOrgList().stream().map(e -> e.getNumber()).collect(Collectors.toSet());
        run.addDimensionScope(PresetConstant.ENTITY_DIM, orgNumbers.toArray(new String[0]));
        run.addDimensionScope(PresetConstant.PROCESS_DIM, processNumber);
        if ("RAdj".equals(processNumber)) {
            QFilter qFilter = new QFilter("datasource", "=", (Object)DataSourceEnum.TABLEADJUSTMENT.getOIndex());
            qFilter.and("model", "=", this._item.getModel().getId());
            DynamicObjectCollection datasource = QueryServiceHelper.query((String)"bcm_audittrialmembertree", (String)"id,number", (QFilter[])qFilter.toArray());
            Set<String> auditTrialNumbers = datasource.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
            run.addDimensionScope(PresetConstant.AUDITTRIAL_DIM, auditTrialNumbers.toArray(new String[0]));
        }
        run.runScript();
    }

    private void copyAdjustData() {
        HashSet<Long> orgs = new HashSet<Long>(this._item.getOrgList().size());
        this._item.getOrgList().forEach(e -> {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((String)this._item.getModelNum(), (Long)((Long)e.getId()));
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                node = node.getBaseTreeNode();
                orgs.add(node.getId());
                node.getShareNodes().forEach(a -> orgs.add(a.getId()));
            }
        });
        this.clearAdjust(orgs);
        QFilter qf = new QFilter("process.number", "in", Arrays.asList("ERAdj", "RAdj")).and("entity", "in", orgs).and("adjust.status", "=", (Object)RptAdjustStatusEnum.AUDIT.status());
        Map<Long, Set<Object>> orgAdjustIdsMap = AdjustmentServiceHelper.collectAdjust((Long)this._item.getModel().getId(), (Long)this._item.getScenario().getId(), (Long)this._item.getFy().getId(), (Long)this._item.getPeriod().getId(), null, qf);
        if (!orgAdjustIdsMap.isEmpty()) {
            ArrayList<Long> adjustIds = new ArrayList<Long>(10);
            orgAdjustIdsMap.values().forEach(e -> e.forEach(a -> adjustIds.add((Long)a)));
            AdjustAutoCopyOperation copyOperation = new AdjustAutoCopyOperation((Long)this._item.getModel().getId(), (Long)this.targetScenario.getId(), (Long)this._item.getFy().getId(), (Long)this._item.getPeriod().getId(), adjustIds);
            copyOperation.excute();
            OperationResult operationResult = copyOperation.getOperationResult();
            if (!operationResult.isSuccess()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u8c03\u6574\u76f8\u5173\u5206\u5f55\u590d\u5236\u5931\u8d25 :Message:%1$s   AllErrorInfo :%2$s ", (String)"DataVersionCopyService_1", (String)"fi-bcm-business", (Object[])new Object[0]), operationResult.getMessage(), operationResult.getAllErrorInfo().toString()));
            }
        }
    }

    private void clearAdjust(Collection<Long> orgs) {
        QFilter qf = new QFilter("process.number", "in", Arrays.asList("ERAdj", "RAdj")).and("entity", "in", orgs);
        Map<Long, Set<Object>> orgAdjustIdsMap = AdjustmentServiceHelper.collectAdjust((Long)this._item.getModel().getId(), (Long)this.targetScenario.getId(), (Long)this._item.getFy().getId(), (Long)this._item.getPeriod().getId(), null, qf);
        if (!orgAdjustIdsMap.isEmpty()) {
            ArrayList<Long> adjustIds = new ArrayList<Long>(10);
            orgAdjustIdsMap.values().forEach(e -> e.forEach(a -> adjustIds.add((Long)a)));
            AdjustClearOperation copyOperation = new AdjustClearOperation((Long)this._item.getModel().getId(), (Long)this.targetScenario.getId(), (Long)this._item.getFy().getId(), (Long)this._item.getPeriod().getId(), adjustIds);
            copyOperation.excute();
        }
    }
}

