/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mergecontrol.versioned;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.OrgBuilder;
import kd.fi.bcm.business.allinone.model.McContext;
import kd.fi.bcm.business.allinone.model.OrgNode;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.mergecontrol.IMergeExecutor;
import kd.fi.bcm.business.mergecontrol.MergeEntityService;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.versioned.DataVersionCopyService;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.model.ResultBox;

public class DataVersionedExecutor
implements IMergeExecutor {
    MergeEntityService meService = MergeEntityService.getInstance();
    protected McContext ctx;
    Set<Long> orgIds = new HashSet<Long>();
    Set<String> orgNumbers = new HashSet<String>();
    SimpleItem quoteSceneItem;
    protected boolean OPEN_CM012 = false;

    @Override
    public ResultBox doSubmit(McContext mcContext) {
        this.ctx = mcContext;
        this.init();
        ResultBox check = this.check();
        ResultBox result = this.submit();
        result.append(check);
        return result;
    }

    public void init() {
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long fyId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Collection<SimpleItem> orgList = this.ctx.getOrgList();
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)this.ctx.getModelNum(), (Long)scenarioId);
        IDNumberTreeNode quoteScene = (IDNumberTreeNode)sceneNode.getProperty("quoteNode");
        this.quoteSceneItem = SimpleItem.newOne(quoteScene.getId(), quoteScene.getNumber());
        String opt = (String)this.ctx.getDataMap().get("includeOption");
        if ("1".equals(opt)) {
            this.orgIds = orgList.stream().map(SimpleItem::getId).collect(Collectors.toSet());
        } else if ("2".equals(opt)) {
            for (SimpleItem simpleItem : orgList) {
                long orgId = (Long)simpleItem.getId();
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                this.orgIds.add(orgId);
                if (orgNode == IDNumberTreeNode.NotFoundTreeNode || orgNode.isLeaf()) continue;
                this.orgIds.addAll(orgNode.getAllChildren().stream().map(IDNumberTreeNode::getId).collect(Collectors.toList()));
            }
        } else if ("3".equals(opt)) {
            for (SimpleItem simpleItem : orgList) {
                long orgId = (Long)simpleItem.getId();
                ArrayList<Long> pOrgIds = new ArrayList<Long>(16);
                this.searchParentId(modelId, orgId, pOrgIds);
                this.orgIds.addAll(pOrgIds);
            }
        } else if ("4".equals(opt)) {
            for (SimpleItem simpleItem : orgList) {
                long orgId = (Long)simpleItem.getId();
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
                this.orgIds.add(orgId);
                if (orgNode == IDNumberTreeNode.NotFoundTreeNode || orgNode.isLeaf()) continue;
                this.orgIds.addAll(orgNode.getAllChildren().stream().filter(r -> !r.isLeaf()).map(IDNumberTreeNode::getId).collect(Collectors.toList()));
            }
        }
        DynamicObjectCollection orgColl = OrgServiceHelper.getOrgList(modelId, new ArrayList<Long>(this.orgIds));
        FilterOrgStructParam filterOrgStructParam = new FilterOrgStructParam(modelId, scenarioId, fyId, periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(filterOrgStructParam, (List<DynamicObject>)orgColl);
        this.orgIds = orgColl.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        this.orgNumbers = orgColl.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
        this.OPEN_CM012 = ConfigServiceHelper.getBoolParam(modelId, "CM012");
    }

    private void searchParentId(long modelId, long orgId, List<Long> orgIds) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        if (orgNode == IDNumberTreeNode.NotFoundTreeNode || "Entity".equals(orgNode.getNumber())) {
            return;
        }
        if (!orgIds.contains(orgId)) {
            orgIds.add(orgId);
        }
        List shareNodes = orgNode.getBaseTreeNode().getShareNodes();
        shareNodes.add(orgNode.getBaseTreeNode());
        for (IDNumberTreeNode shareNode : shareNodes) {
            IDNumberTreeNode parent = shareNode.getParent();
            this.searchParentId(modelId, parent.getId(), orgIds);
        }
    }

    public ResultBox check() {
        ResultBox result = ResultBox.of();
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long fyId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        if (this.orgIds.isEmpty()) {
            result.add(MergeMessage.EMPTY_DATA.getText());
            return result;
        }
        if (!this.meService.isQuoteScene(modelId, scenarioId)) {
            result.add(MergeMessage.ONLY_VERSIONED.getText());
            this.orgIds.clear();
            return result;
        }
        Set<String> versionedOrgNumbers = this.meService.getAllVersionedOrgs(modelId, scenarioId, fyId, periodId);
        Set<String> periodStatusOpenOrgNumbers = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelId, this.orgNumbers, scenarioId, fyId, periodId, "datastatus");
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        Set<Long> writePermMembers = PermissionServiceImpl.getInstance(modelId).matchWritePermMembers(dimId, "bcm_entitymembertree", this.orgIds);
        this.orgIds.removeIf(o -> {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)o);
            if (versionedOrgNumbers.contains(orgNode.getNumber())) {
                result.add(String.format(MergeMessage.HAS_VERSIONED.getText(), orgNode.getNumber()));
                return true;
            }
            if (this.OPEN_CM012 && !periodStatusOpenOrgNumbers.contains(orgNode.getNumber())) {
                result.add(String.format(MergeMessage.NOT_OPENPERIOD.getText(), orgNode.getNumber()));
                return true;
            }
            if (!writePermMembers.contains(orgNode.getId())) {
                result.add(String.format(MergeMessage.NONE_WRITEPERM.getText(), orgNode.getNumber()));
                return true;
            }
            return false;
        });
        return result;
    }

    protected ResultBox submit() {
        DynamicObject[] mcData;
        ResultBox result = ResultBox.of();
        if (this.orgIds.isEmpty()) {
            return result;
        }
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long fyId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        this.meService.batchInitMcData(modelId, scenarioId, fyId, periodId, this.orgIds);
        for (DynamicObject dyn : mcData = this.meService.batchLoadMcData(modelId, scenarioId, fyId, periodId, this.orgIds)) {
            dyn.set("isversioned", (Object)true);
            dyn.set("modifytime", (Object)TimeServiceHelper.now());
        }
        if (mcData.length == 0) {
            return result;
        }
        try (TXHandle tx = TX.required();){
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("updateModifyDate", "false");
                SaveServiceHelper.save((DynamicObject[])mcData, (OperateOption)op);
                this.execCubeDataScope();
                this.dataCopy();
            }
            catch (Exception e) {
                tx.markRollback();
                result.addError(e.getMessage());
            }
        }
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey(this.meService.packKey(modelId, scenarioId, fyId, periodId));
        return result;
    }

    protected void execCubeDataScope() {
        long modelId = this.ctx.getModelId();
        long scenarioId = this.ctx.getScenarioId();
        long fyId = this.ctx.getFyId();
        long periodId = this.ctx.getPeriodId();
        Set<String> orgNumbers = this.meService.getAllVersionedOrgs(modelId, scenarioId, fyId, periodId);
        HashSet<String> versionedOrgs = new HashSet<String>(orgNumbers);
        for (String orgNumber : orgNumbers) {
            IDNumberTreeNode org = MemberReader.findEntityMemberByNum((String)this.ctx.getModelNum(), (String)orgNumber);
            OrgBuilder build = OrgBuilder.build(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyId(), this.ctx.getPeriodId());
            OrgNode orgNode = build.genOrgNode(org.getId());
            build.extendDirectChildren(orgNode);
            PairList<Long, String> pair = orgNode.getMergeChildrenRelaWithParentPair();
            versionedOrgs.addAll(pair.toList().stream().map(p -> (String)p.p2).collect(Collectors.toSet()));
        }
        PairList pairList = new PairList();
        if (!versionedOrgs.isEmpty()) {
            pairList.addPair((Object)PresetConstant.FY_DIM, (Object)this.ctx.getFyNum());
            pairList.addPair((Object)PresetConstant.PERIOD_DIM, (Object)this.ctx.getPeriodNum());
            pairList.addPair((Object)PresetConstant.ENTITY_DIM, versionedOrgs);
        }
        OlapServiceHelper.addOrgPointScope(this.ctx.getModelNum(), this.ctx.getScenariodNum(), (PairList<String, Object>)pairList);
    }

    private void dataCopy() {
        boolean isCopy = Boolean.TRUE.equals(this.ctx.getDataMap().get("iscopy"));
        if (isCopy && !this.orgIds.isEmpty()) {
            FixedItem fixedItem = FixedItem.newOne(SimpleItem.newOne(this.ctx.getModelId(), this.ctx.getModelNum()), this.quoteSceneItem, SimpleItem.newOne(this.ctx.getFyId(), this.ctx.getFyNum()), SimpleItem.newOne(this.ctx.getPeriodId(), this.ctx.getPeriodNum()));
            ArrayList<SimpleItem> orgList = new ArrayList<SimpleItem>(16);
            for (Long orgId : this.orgIds) {
                IDNumberTreeNode org = MemberReader.findEntityMemberById((String)this.ctx.getModelNum(), (Long)orgId);
                if (!org.isLeaf()) continue;
                orgList.add(SimpleItem.newOne(orgId, org.getNumber()));
            }
            if (!orgList.isEmpty()) {
                fixedItem.setOrgList(orgList);
                DataVersionCopyService.getInstance().executeService(fixedItem, SimpleItem.newOne(this.ctx.getScenarioId(), this.ctx.getScenariodNum()));
            }
        }
    }
}

