/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.TemplateUtils;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;

public class DataCollectModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DynamicObject[] dcs;
    private Map<Long, List<String>> relation;
    private String scenario;
    private String fy;
    private String period;
    private String currency;
    private long fyid;
    private Long scenarioid;
    private long periodid;
    private long currencyId;
    private String modelDy;
    private long modelid;
    private Map<Long, List<String>> idRowCols;
    private Map<Long, Map<String, String>> idMap;
    private Map<String, Map<String, String>> idMaps;
    private List<DynamicObject> list;
    private String userId;
    private Map<String, String> errorDcs;
    private boolean hasDim = true;
    private String msg;
    private Map<String, Object> result;
    private boolean withoutTmp;
    private Map<String, String> shortNumbers;
    private List<Long> allExcuteTempIds;
    private List<Long> sortTempids;
    private boolean isSort = false;
    private boolean isReCollect = true;
    private Map<Long, DynamicObject> reportMap;
    private boolean fromRpt = false;
    private Collection<Long> realselectTmp;
    private transient Map<String, SaveCommandInfo> temCmdInfos = new HashMap<String, SaveCommandInfo>();
    private transient Map<String, CellSet> temCellSets = new HashMap<String, CellSet>();

    public DataCollectModel() {
        this.temCmdInfos = new HashMap<String, SaveCommandInfo>();
        this.temCellSets = new HashMap<String, CellSet>();
        this.shortNumbers = new HashMap<String, String>();
    }

    public DataCollectModel(DynamicObject[] dcs, Map<Long, List<String>> relation, String scenario, String fy, String period, String modelDy, Map<Long, List<String>> idRowCols, Map<Long, Map<String, String>> idMap, List<DynamicObject> list) {
        this.dcs = dcs;
        this.relation = relation;
        this.scenario = scenario;
        this.fy = fy;
        this.period = period;
        this.modelDy = modelDy;
        this.idRowCols = idRowCols;
        this.idMap = idMap;
        this.list = list;
        this.temCmdInfos = new HashMap<String, SaveCommandInfo>();
        this.temCellSets = new HashMap<String, CellSet>();
        this.shortNumbers = new HashMap<String, String>();
    }

    public DynamicObject[] getDcs() {
        return this.dcs;
    }

    public void setDcs(DynamicObject[] dcs) {
        this.dcs = dcs;
    }

    public Map<Long, List<String>> getRelation() {
        return this.relation;
    }

    public void setRelation(Map<Long, List<String>> relation) {
        this.relation = relation;
    }

    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public Long getScenarioid() {
        return this.scenarioid;
    }

    public void setScenarioid(Long scenarioid) {
        this.scenarioid = scenarioid;
    }

    public String getFy() {
        return this.fy;
    }

    public void setFy(String fy) {
        this.fy = fy;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrencyId(long currencyId) {
        this.currencyId = currencyId;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getModelid() {
        return this.modelid;
    }

    public void setModelid(long modelid) {
        this.modelid = modelid;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String getModelDy() {
        return this.modelDy;
    }

    public void setModelDy(String modelDy) {
        this.modelDy = modelDy;
    }

    public Map<Long, List<String>> getIdRowCols() {
        return this.idRowCols;
    }

    public void setIdRowCols(Map<Long, List<String>> idRowCols) {
        this.idRowCols = idRowCols;
    }

    public Map<Long, Map<String, String>> getIdMap() {
        return this.idMap;
    }

    public void setIdMap(Map<Long, Map<String, String>> idMap) {
        this.idMap = idMap;
    }

    public List<DynamicObject> getList() {
        return this.list;
    }

    public void setList(List<DynamicObject> list) {
        this.list = list;
    }

    public Map<String, SaveCommandInfo> getTemCmdInfos() {
        return this.temCmdInfos;
    }

    public void setTemCmdInfos(Map<String, SaveCommandInfo> temCmdInfos) {
        this.temCmdInfos = temCmdInfos;
    }

    public Map<String, CellSet> getTemCellSets() {
        return this.temCellSets;
    }

    public void setTemCellSets(Map<String, CellSet> temCellSets) {
        this.temCellSets = temCellSets;
    }

    public long getFyid() {
        return this.fyid;
    }

    public void setFyid(long fyid) {
        this.fyid = fyid;
    }

    public long getPeriodid() {
        return this.periodid;
    }

    public void setPeriodid(long periodid) {
        this.periodid = periodid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAllDimensionText(Long temid) {
        StringBuilder sb = new StringBuilder();
        for (String dimNum : this.getIdMap().get(temid).keySet()) {
            sb.append(dimNum).append(':').append(this.getIdMap().get(temid).get(dimNum)).append(',');
        }
        return sb.toString().substring(0, sb.lastIndexOf(","));
    }

    public String getDimensionText(Long temid, String orgNum) {
        StringBuilder sb = new StringBuilder();
        for (String dimNum : this.getIdMaps().get(temid + "||" + orgNum).keySet()) {
            String shortNumber;
            if (PresetConstant.ENTITY_DIM.equals(dimNum) || PresetConstant.FY_DIM.equals(dimNum) || PresetConstant.PERIOD_DIM.equals(dimNum)) continue;
            if (!this.shortNumbers.containsKey(dimNum)) {
                shortNumber = DimTypesEnum.getShortNumberByNumber((String)dimNum);
                if (StringUtils.isEmpty((CharSequence)shortNumber)) {
                    QFilter qf1 = new QFilter("model", "=", (Object)this.getModelid());
                    QFilter qf2 = new QFilter("number", "=", (Object)dimNum);
                    DynamicObject dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"ShortNumber", (QFilter[])new QFilter[]{qf1, qf2});
                    shortNumber = dim.getString("ShortNumber");
                }
                this.shortNumbers.put(dimNum, shortNumber);
            }
            shortNumber = this.shortNumbers.get(dimNum);
            sb.append(shortNumber).append(':').append(this.getIdMaps().get(temid + "||" + orgNum).get(dimNum)).append(',');
        }
        return sb.toString().substring(0, sb.lastIndexOf(","));
    }

    public Map<String, Map<String, String>> getIdMaps() {
        return this.idMaps;
    }

    public void setIdMaps(Map<String, Map<String, String>> idMaps) {
        this.idMaps = idMaps;
    }

    public Map<String, String> getErrorDcs() {
        return this.errorDcs;
    }

    public void setErrorDcs(Map<String, String> errorDcs) {
        this.errorDcs = errorDcs;
    }

    public boolean isHasDim() {
        return this.hasDim;
    }

    public void setHasDim(boolean hasDim) {
        this.hasDim = hasDim;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Map<String, Object> getResult() {
        return this.result;
    }

    public void setResult(Map<String, Object> result) {
        this.result = result;
    }

    public void addResult(String key, Object value) {
        if (this.result == null) {
            this.result = new HashMap<String, Object>();
        }
        this.result.put(key, value);
    }

    public void setWithoutTmp(boolean withoutTmp) {
        this.withoutTmp = withoutTmp;
    }

    public boolean isWithoutTmp() {
        return this.withoutTmp;
    }

    public List<Long> getAllExcuteTempIds() {
        return this.allExcuteTempIds;
    }

    public void setAllExcuteTempIds(List<Long> allExcuteTempIds) {
        this.allExcuteTempIds = allExcuteTempIds;
    }

    private void sortTmp() {
        if (this.isSort) {
            Set<Long> groupIds = this.getGroupIds();
            int maxNum = this.getMaxNum(groupIds);
            DynamicObjectCollection allSortGroups = this.getAllSortGroups(maxNum);
            Map<String, Long> map = this.getMap();
            ArrayList<Long> isReCollectTempIds = new ArrayList<Long>(10);
            ArrayList<Long> isNotReCollectTempIds = new ArrayList<Long>(10);
            ArrayList<Long> isWeavingTempIds = new ArrayList<Long>(10);
            for (DynamicObject sortGroup : allSortGroups) {
                String group = sortGroup.getString("group");
                Long templateid = map.get(group);
                isReCollectTempIds.add(templateid);
                isNotReCollectTempIds.add(templateid);
                String reportStatus = ReportStatusEnum.UNWEAVE.status();
                if (this.reportMap.get(templateid) != null) {
                    reportStatus = this.reportMap.get(templateid).getString("reportstatus");
                }
                if (this.realselectTmp != null && this.realselectTmp.contains(templateid) || StringUtils.isEmpty((CharSequence)reportStatus) || !reportStatus.equals(ReportStatusEnum.WEAVING.status())) continue;
                isWeavingTempIds.add(templateid);
            }
            isNotReCollectTempIds.removeAll(isWeavingTempIds);
            if (this.isSort) {
                this.sortTempids = this.isReCollect ? isReCollectTempIds : isNotReCollectTempIds;
            }
        }
        if (this.sortTempids == null) {
            this.sortTempids = new ArrayList<Long>();
        }
    }

    private Set<Long> getGroupIds() {
        QFilter modelQFilter = new QFilter("model", "=", (Object)this.modelid);
        QFilter idQFilters = new QFilter("id", "in", this.allExcuteTempIds);
        String selectFields = "id,group";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, idQFilters}, null);
        HashSet groupIds = Sets.newHashSet();
        queryResult.forEach(c -> {
            Long groupId = c.getLong("group");
            groupIds.add(groupId);
        });
        return groupIds;
    }

    private int getMaxNum(Set<Long> groupIds) {
        QFilter modelQFilter = new QFilter("model", "=", (Object)this.modelid);
        QFilter groupQFilter = new QFilter("group", "in", groupIds);
        String selectFields = "id,setorder";
        DynamicObjectCollection allGroupTemp = QueryServiceHelper.query((String)"bcm_datacollectorder", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, groupQFilter}, (String)"setorder asc");
        int maxNum = 1;
        for (DynamicObject temp : allGroupTemp) {
            int setorder = Integer.parseInt(temp.getString("setorder"));
            maxNum = setorder > maxNum ? setorder : maxNum;
        }
        return maxNum;
    }

    private DynamicObjectCollection getAllSortGroups(int maxNum) {
        QFilter modelQFilter = new QFilter("model", "=", (Object)this.modelid);
        String selectFields = "id,group,template";
        QFilter maxQFilter = new QFilter("setorder", "<=", (Object)maxNum);
        DynamicObjectCollection allSortGroups = QueryServiceHelper.query((String)"bcm_datacollectorder", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, maxQFilter}, (String)"setorder asc");
        return allSortGroups;
    }

    private Map<String, Long> getMap() {
        QFilter modelQFilter = new QFilter("model", "=", (Object)this.modelid);
        String queryFields = "id,group";
        DynamicObjectCollection tempIds = QueryServiceHelper.query((String)"bcm_templateentity", (String)queryFields, (QFilter[])new QFilter[]{modelQFilter}, null);
        HashSet templateIds = Sets.newHashSet();
        for (DynamicObject template : tempIds) {
            templateIds.add(template.getLong("id"));
        }
        Map<Long, Long> source2Right = TemplateUtils.getRightTplIdByVersioned(this.modelid, this.fyid, this.periodid, templateIds);
        HashMap<String, Long> map = new HashMap<String, Long>(10);
        for (DynamicObject template : tempIds) {
            Long sourceTempId = template.getLong("id");
            Long rightTempId = source2Right.get(sourceTempId);
            if (rightTempId == null) continue;
            map.put(template.getString("group"), rightTempId);
        }
        return map;
    }

    public List<Long> getSortTempids() {
        if (this.sortTempids == null) {
            this.sortTmp();
        }
        return this.sortTempids;
    }

    public boolean isSort() {
        return this.isSort;
    }

    public void setSort(boolean sort) {
        this.isSort = sort;
    }

    public void setReCollect(boolean reCollect) {
        this.isReCollect = reCollect;
    }

    public boolean isReCollect() {
        return this.isReCollect;
    }

    public Map<Long, DynamicObject> getReportMap() {
        return this.reportMap;
    }

    public void setReportMap(Map<Long, DynamicObject> reportMap) {
        this.reportMap = reportMap;
    }

    public void setFromRpt(boolean fromRpt) {
        this.fromRpt = fromRpt;
    }

    public boolean isFromRpt() {
        return this.fromRpt;
    }

    public void setRealselectTmp(Collection<Long> realselectTmp) {
        this.realselectTmp = realselectTmp;
    }

    public Collection<Long> getRealselectTmp() {
        return this.realselectTmp;
    }
}

