/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Date;
import kd.fi.bcm.common.cache.MemberReader;

public class FilterOrgStructParam {
    public static int FROM_COMMON = 1;
    public static int FROM_REPORT = 2;
    public static int FROM_REPORT_SAME = 7;
    public static int FROM_CHECK = 3;
    public static int FROM_TASK = 4;
    public static int FROM_CHECKELIM = 5;
    public static int FROM_MERGESTRUCT = 6;
    private long modelId;
    private long sceneId;
    private String yearNum;
    private long periodId;
    private Date specialLastDate;
    private int from = FROM_COMMON;
    private boolean autoDelChild = true;
    private boolean checkStructInfo = true;
    private boolean isOpenSortedDictionary = false;
    private Table<String, Long, Integer> sortedDictionary;

    public FilterOrgStructParam(long modelId, long sceneId, String yearNum, long periodId) {
        this.modelId = modelId;
        this.sceneId = sceneId;
        this.yearNum = yearNum;
        this.periodId = periodId;
    }

    public FilterOrgStructParam(long modelId, long sceneId, long yearId, long periodId) {
        this.modelId = modelId;
        this.sceneId = sceneId;
        this.yearNum = MemberReader.findFyMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)yearId).getNumber();
        this.periodId = periodId;
    }

    public FilterOrgStructParam(long modelId, long sceneId, long yearId, long periodId, boolean checkStructInfo, boolean autoDelChild) {
        this(modelId, sceneId, yearId, periodId);
        this.autoDelChild = autoDelChild;
        this.checkStructInfo = checkStructInfo;
    }

    public long getModelId() {
        return this.modelId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    public long getSceneId() {
        return this.sceneId;
    }

    public void setSceneId(long sceneId) {
        this.sceneId = sceneId;
    }

    public String getYearNum() {
        return this.yearNum;
    }

    public void setYearNum(String yearNum) {
        this.yearNum = yearNum;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(long periodId) {
        this.periodId = periodId;
    }

    public int getFrom() {
        return this.from;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public boolean isAutoDelChild() {
        return this.autoDelChild;
    }

    public FilterOrgStructParam setAutoDelChild(boolean autoDelChild) {
        this.autoDelChild = autoDelChild;
        return this;
    }

    public boolean isCheckStructInfo() {
        return this.checkStructInfo;
    }

    public FilterOrgStructParam setCheckStructInfo(boolean checkStructInfo) {
        this.checkStructInfo = checkStructInfo;
        return this;
    }

    public FilterOrgStructParam setOpenSortedDictionary(boolean openSortedDictionary) {
        this.isOpenSortedDictionary = openSortedDictionary;
        return this;
    }

    public boolean isOpenSortedDictionary() {
        return this.isOpenSortedDictionary;
    }

    public Table<String, Long, Integer> getSortedDictionary() {
        if (this.sortedDictionary == null) {
            this.sortedDictionary = HashBasedTable.create();
        }
        return this.sortedDictionary;
    }

    public Date specialLastDate() {
        return this.specialLastDate;
    }

    public FilterOrgStructParam setSpecialLastDate(Date specialLastDate) {
        this.specialLastDate = specialLastDate;
        return this;
    }

    public String getUniqueKey() {
        return String.join((CharSequence)"-", "" + this.modelId, "" + this.sceneId, "" + this.yearNum, "" + this.periodId);
    }
}

