/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.fi.bcm.business.model.SimpleItem;

public class FixedItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SimpleItem model;
    private SimpleItem fy;
    private SimpleItem period;
    private SimpleItem scenario;
    private SimpleItem entity;
    private SimpleItem org;
    private SimpleItem scheme;
    private List<SimpleItem> orgList = new ArrayList<SimpleItem>(10);

    private FixedItem(SimpleItem model, SimpleItem scenario, SimpleItem fy, SimpleItem period) {
        this.model = model;
        this.scenario = scenario;
        this.fy = fy;
        this.period = period;
    }

    private FixedItem(SimpleItem model, SimpleItem scenario, SimpleItem fy, SimpleItem period, SimpleItem entity) {
        this.model = model;
        this.scenario = scenario;
        this.fy = fy;
        this.period = period;
        this.entity = entity;
    }

    @JsonCreator
    public static FixedItem newOne(@JsonProperty(value="model") SimpleItem model, @JsonProperty(value="scenario") SimpleItem scenario, @JsonProperty(value="fy") SimpleItem fy, @JsonProperty(value="period") SimpleItem period) {
        return new FixedItem(model, scenario, fy, period);
    }

    @JsonCreator
    public static FixedItem newOne(@JsonProperty(value="model") SimpleItem model, @JsonProperty(value="scenario") SimpleItem scenario, @JsonProperty(value="fy") SimpleItem fy, @JsonProperty(value="period") SimpleItem period, @JsonProperty(value="org") SimpleItem entity) {
        return new FixedItem(model, scenario, fy, period, entity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || this.hashCode() != o.hashCode()) {
            return false;
        }
        FixedItem fixedItem = (FixedItem)o;
        return this.model == fixedItem.model && this.fy == fixedItem.fy && this.period == fixedItem.period && this.scenario == fixedItem.scenario && this.scheme == fixedItem.scheme;
    }

    public int hashCode() {
        return Objects.hash(this.model.getId(), this.fy.getId(), this.period.getId(), this.scenario.getId(), this.scheme.getId());
    }

    public SimpleItem getModel() {
        return this.model;
    }

    public SimpleItem getFy() {
        return this.fy;
    }

    public SimpleItem getPeriod() {
        return this.period;
    }

    public SimpleItem getScenario() {
        return this.scenario;
    }

    public SimpleItem getEntity() {
        return this.entity;
    }

    public void setOrg(SimpleItem org) {
        this.org = org;
    }

    public SimpleItem getOrg() {
        return this.org;
    }

    public SimpleItem getScheme() {
        return this.scheme;
    }

    public void setScheme(SimpleItem scheme) {
        this.scheme = scheme;
    }

    public void setOrgList(List<SimpleItem> orgList) {
        this.orgList = orgList;
    }

    public Collection<SimpleItem> getOrgList() {
        return this.orgList;
    }

    public long getModelId() {
        return (Long)this.model.getId();
    }

    public long getScenarioId() {
        return (Long)this.scenario.getId();
    }

    public long getFyId() {
        return (Long)this.fy.getId();
    }

    public long getPeriodId() {
        return (Long)this.period.getId();
    }

    public long getEntityId() {
        return (Long)this.entity.getId();
    }

    public long getOrgId() {
        return (Long)this.org.getId();
    }

    public long getSchemeId() {
        return (Long)this.scheme.getId();
    }

    public String getModelNum() {
        return this.model.getNumber();
    }

    public String getScenarioNum() {
        return this.scenario.getNumber();
    }

    public String getFyNum() {
        return this.fy.getNumber();
    }

    public String getPeriodNum() {
        return this.period.getNumber();
    }

    public String getEntityNum() {
        return this.entity.getNumber();
    }

    public String getOrgNum() {
        return this.org.getNumber();
    }

    public String getSchemeNum() {
        return this.scheme.getNumber();
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder(this.getEntityNum());
        sb.append("-");
        sb.append(this.getScenarioNum());
        sb.append("-");
        sb.append(this.getFyNum());
        sb.append("-");
        sb.append(this.getPeriodNum());
        return sb.toString();
    }

    public String getNoEntityInfo() {
        StringBuilder sb = new StringBuilder(this.getScenarioNum());
        sb.append("-");
        sb.append(this.getFyNum());
        sb.append("-");
        sb.append(this.getPeriodNum());
        return sb.toString();
    }
}

