/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.integrationnew.ctx.IIntegrateContext;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.business.model.BalanceQueryParam;
import kd.fi.bcm.business.model.BalanceQueryParamApi;
import kd.fi.bcm.business.model.BalanceReClassNumberParam;
import kd.fi.bcm.business.model.CashflowQueryParam;
import kd.fi.bcm.business.model.CashflowQueryParamApi;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class GlServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(GlServiceHelper.class);

    public static List<Map<String, Object>> getBalance(BalanceQueryParam param, IIntegrateContext _ctx) {
        log.startWatch();
        Long startTime = System.currentTimeMillis();
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{param.toString()});
        IntegrationUtil.addTimeUse(_ctx, startTime, "BalanceService:getBalance");
        log.info("BalanceQueryParam\u5355\u6b21\u53d6\u6570\u8017\u65f6");
        if (result == null) {
            return null;
        }
        try {
            return (List)JSONUtils.cast((String)result, List.class);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    public static Map<String, Object> getBalance(BalanceQueryParamApi param, IIntegrateContext _ctx) {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("data", param.toString());
        String schemeAndOrg = (String)_ctx.getSchema().p2 + "|" + (String)_ctx.getOrg().p2;
        ErrorLogServiceHelper.saveErrorLog((Long)_ctx.getModel().p1, "getBalanceParam", schemeAndOrg + ":" + param.toString());
        Long startTime = System.currentTimeMillis();
        Map res = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BanlanceServiceApiHelper", (String)"getBalance", (Object[])new Object[]{temp});
        IntegrationUtil.addTimeUse(_ctx, startTime, "BanlanceServiceApiHelper:getBalance");
        ErrorLogServiceHelper.saveErrorLog((Long)_ctx.getModel().p1, "getBalanceResult", schemeAndOrg + ":" + res.toString());
        return res;
    }

    public static String getBalance(BalanceReClassNumberParam param, IIntegrateContext _ctx) {
        String schemeAndOrg = (String)_ctx.getSchema().p2 + "|" + (String)_ctx.getOrg().p2;
        ErrorLogServiceHelper.saveErrorLog((Long)_ctx.getModel().p1, "getBalanceParam", schemeAndOrg + ":" + param.toString());
        Long startTime = System.currentTimeMillis();
        String res = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getReClassBalance", (Object[])new Object[]{param.toString()});
        IntegrationUtil.addTimeUse(_ctx, startTime, "BalanceService:getReClassBalance");
        ErrorLogServiceHelper.saveErrorLog((Long)_ctx.getModel().p1, "getBalanceResult", schemeAndOrg + ":" + res);
        return res;
    }

    public static List<Map<String, Object>> getCashFlowAmount(CashflowQueryParam param, IIntegrateContext _ctx) {
        Long startTime = System.currentTimeMillis();
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"CashflowService", (String)"getCashFlowAmount", (Object[])new Object[]{param.toString()});
        IntegrationUtil.addTimeUse(_ctx, startTime, "CashflowService:getCashFlowAmount");
        if (result == null) {
            return null;
        }
        try {
            return (List)JSONUtils.cast((String)result, List.class);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    public static Map<String, Object> getCashFlowAmount(CashflowQueryParamApi param, IIntegrateContext _ctx) {
        HashMap<String, String> temp = new HashMap<String, String>();
        try {
            temp.put("data", param.toString());
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        String schemeAndOrg = (String)_ctx.getSchema().p2 + "|" + (String)_ctx.getOrg().p2;
        ErrorLogServiceHelper.saveErrorLog((Long)_ctx.getModel().p1, "getCashFlowAmountParam", schemeAndOrg + ":" + param.toString());
        Long startTime = System.currentTimeMillis();
        Map res = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"CashflowServiceApiHelper", (String)"getCashflow", (Object[])new Object[]{temp});
        IntegrationUtil.addTimeUse(_ctx, startTime, "CashflowServiceApiHelper:getCashflow");
        ErrorLogServiceHelper.saveErrorLog((Long)_ctx.getModel().p1, "getCashFlowAmountResult", schemeAndOrg + ":" + res.toString());
        return res;
    }

    public static boolean isAccountBookClose(IIntegrateContext _ctx, String orgNumber, String bookType, String yearNum, String periodNum) {
        boolean allowFetchingData = ConfigServiceHelper.getBoolParam((Long)_ctx.getModel().p1, "CM042");
        if (!allowFetchingData) {
            Boolean result = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"GLAccountBookService", (String)"isAccountBookClose", (Object[])new Object[]{orgNumber, bookType, yearNum, periodNum});
            ErrorLogServiceHelper.saveErrorLog((Long)_ctx.getModel().p1, "isAccountBookClose", orgNumber + "|" + bookType + "|" + yearNum + "|" + periodNum + ":" + result);
            return result;
        }
        return true;
    }
}

