/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model.formula;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bcm.business.integration.util.IntergrationUtil;
import kd.fi.bcm.business.model.AbstractFormula;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import org.apache.commons.lang3.StringUtils;

public class AccountCheckParser {
    private Map<String, Set<String>> orgBookType_AccountNums = Maps.newTreeMap();

    public Set<String> getExitAccount(List<String> accounts, String orgNum, String bookeType) {
        String key = orgNum + "|" + bookeType;
        LinkedHashSet exitAccounts = Sets.newLinkedHashSet();
        if (this.orgBookType_AccountNums.get(key) == null) {
            QFilter orgFilter = new QFilter("number", "=", (Object)orgNum);
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{orgFilter});
            long orgid = org.getLong("id");
            QFilter qc = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgid);
            QFBuilder qf = new QFBuilder();
            StringBuilder sb = new StringBuilder();
            sb.append(orgNum).append('|');
            long tableId = AccountCheckParser.getAcctTable(orgid, bookeType, sb);
            qf.clear();
            qf.add(qc);
            qf.add("accounttable", "=", (Object)tableId);
            HashSet accountNums = Sets.newHashSet();
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bd_accountview", (String)"number", (QFilter[])qf.toArray(), (String)"number");
            for (DynamicObject object : doc) {
                accountNums.add(object.getString("number"));
                if (!accounts.contains(object.getString("number"))) continue;
                exitAccounts.add(object.getString("number"));
            }
            this.orgBookType_AccountNums.put(sb.toString(), accountNums);
        } else {
            for (String accountNum : this.orgBookType_AccountNums.get(key)) {
                if (!accounts.contains(accountNum)) continue;
                exitAccounts.add(accountNum);
            }
        }
        return exitAccounts;
    }

    public static List<String> analyAccounts(String startS, String endS) {
        int i;
        ArrayList accounts = Lists.newArrayList();
        String[] sPFloats = startS.split("\\.");
        String[] ePFloats = endS.split("\\.");
        int sIntscale = 0;
        int eIntscale = 0;
        int sscale = 0;
        int escale = 0;
        if (startS.contains(".")) {
            sIntscale = sPFloats[0].length();
            sscale = sPFloats[1].length();
        } else {
            sIntscale = startS.length();
        }
        if (endS.contains(".")) {
            eIntscale = ePFloats[0].length();
            escale = ePFloats[1].length();
        } else {
            eIntscale = endS.length();
        }
        int scale = sscale > escale ? sscale : escale;
        int intScale = sIntscale > eIntscale ? sIntscale : eIntscale;
        double sresult = Double.parseDouble(startS);
        double eresult = Double.parseDouble(endS);
        int multiple = 1;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < intScale; ++i) {
            sb.append('0');
        }
        if (scale > 0) {
            sb.append('.');
        }
        for (i = 0; i < scale; ++i) {
            sresult *= 10.0;
            eresult *= 10.0;
            multiple *= 10;
            sb.append('0');
        }
        for (double next = sresult; next <= eresult; next += 1.0) {
            DecimalFormat format = new DecimalFormat(sb.toString());
            accounts.add(format.format(next / (double)multiple));
        }
        return accounts;
    }

    public static long getAcctTable(long orgid, String bookTypeNum, StringBuilder sb) {
        DynamicObject bookType;
        QFilter bookTypeFilter;
        long bookTypeId = 0L;
        if (!StringUtils.isEmpty((CharSequence)bookTypeNum)) {
            bookTypeFilter = new QFilter("number", "=", (Object)bookTypeNum);
            if (!QueryServiceHelper.exists((String)"bd_accountbookstype", (QFilter[])new QFilter[]{bookTypeFilter})) {
                throw new KDBizException(ResManager.loadKDString((String)"\u516c\u5f0f\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u9519\u8bef\uff0c\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"AccountCheckParser_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            bookType = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id,number,name", (QFilter[])new QFilter[]{bookTypeFilter});
            bookTypeId = bookType.getLong("id");
            sb.append(bookTypeNum);
        } else {
            sb.append(bookTypeNum);
            bookTypeFilter = new QFilter("accounttype", "=", (Object)"1");
            bookType = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id,number,name", (QFilter[])new QFilter[]{bookTypeFilter});
            bookTypeId = bookType.getLong("id");
        }
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgid);
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)bookTypeId);
        DynamicObject book = QueryServiceHelper.queryOne((String)IntergrationUtil.getAccountBookMetadataNumber(), (String)"startperiod,accounttable,periodType", (QFilter[])new QFilter[]{orgFilter, bookFilter});
        if (book == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u8d26\u7c3f\u3002", (String)"AccountCheckParser_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return book.getLong("accounttable");
    }

    public void analyAcctAccount(AbstractFormula formula) {
        String orgNum = formula.getParams().get("orgNum") != null ? (String)formula.getParams().get("orgNum") : "";
        String formulaStr = formula.getFormulaStr();
        if (StringUtils.isNotEmpty((CharSequence)(formulaStr = this.getFuncFormula(formulaStr, orgNum)))) {
            formula.setFormulaStr("=" + formulaStr);
        } else {
            formula.setMsg(ResManager.loadKDString((String)"\u8fde\u7eed\u79d1\u76ee\u90fd\u4e0d\u5b58\u5728\u3002", (String)"AccountCheckParser_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private String getAnalyFormula(String formulaStr, String orgNum) {
        if (formulaStr.toLowerCase(Locale.ENGLISH).contains("acct(")) {
            int acctIndex = formulaStr.toLowerCase(Locale.ENGLISH).indexOf("acct");
            String funcStr = "";
            if (acctIndex > 0) {
                funcStr = formulaStr.substring(0, acctIndex - 1);
                formulaStr = formulaStr.substring(acctIndex, formulaStr.length() - 1);
            }
            if (formulaStr.contains("\"[") && formulaStr.contains("]")) {
                String[] strs = formulaStr.split("\\[");
                String[] strs1 = strs[1].split("\\]");
                String[] accountStrs = strs1[0].split(",");
                String startAccount = accountStrs[0];
                String endAccount = accountStrs[1];
                String startAccount_Add = "";
                if (startAccount.contains("|")) {
                    startAccount = accountStrs[0].split("\\|")[0];
                    endAccount = accountStrs[1].split("\\|")[0];
                    startAccount_Add = accountStrs[0].substring(startAccount.length());
                }
                String first = strs[0];
                List<String> accounts = AccountCheckParser.analyAccounts(startAccount, endAccount);
                String[] formulaStrs = formulaStr.split(",");
                String booktype = "\"\"".equals(formulaStrs[1].trim()) ? "" : formulaStrs[1].trim().substring(1, formulaStrs[1].length() - 2);
                Set<String> exitAccounts = this.getExitAccount(accounts, orgNum, booktype);
                ArrayList aformulas = Lists.newArrayListWithCapacity((int)exitAccounts.size());
                for (String exitAccount : exitAccounts) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(first);
                    sb.append(exitAccount);
                    sb.append(startAccount_Add);
                    sb.append(strs1[1]);
                    aformulas.add(sb.toString());
                }
                formulaStr = aformulas.size() > 0 ? String.join((CharSequence)"+", aformulas) : "";
            } else {
                String[] formulaStrs = formulaStr.split(",");
                if (formulaStrs.length > 7) {
                    String account_lastStr = formulaStrs[formulaStrs.length - 5];
                    String lastaccount = StringUtils.remove((String)account_lastStr, (String)"\"");
                    if (formulaStrs[2].contains("\"") && account_lastStr.contains("\"")) {
                        ArrayList accounts = Lists.newArrayList();
                        String checkAct = "";
                        if (lastaccount.contains("|")) {
                            int index = lastaccount.indexOf(124);
                            checkAct = lastaccount.substring(index);
                            accounts.add(StringUtils.remove((String)formulaStrs[2].trim(), (String)"\""));
                            for (int i = 3; i < formulaStrs.length - 5; ++i) {
                                accounts.add(formulaStrs[i]);
                            }
                            int endIndex = lastaccount.indexOf(124);
                            accounts.add(lastaccount.substring(0, endIndex));
                            accounts.add(lastaccount.substring(0, index));
                        } else {
                            accounts.add(formulaStrs[2].trim().substring(1));
                            for (int i = 3; i < formulaStrs.length - 5; ++i) {
                                accounts.add(formulaStrs[i]);
                            }
                            accounts.add(lastaccount);
                        }
                        String accountTypeStr = formulaStrs[1].trim();
                        String bookeType = StringUtils.isEmpty((CharSequence)accountTypeStr) || "\"\"".equals(accountTypeStr) ? "" : accountTypeStr.substring(1, formulaStrs[1].length() - 2);
                        Set<String> exitAccounts = this.getExitAccount(accounts, orgNum, bookeType);
                        ArrayList aformulas = Lists.newArrayListWithCapacity((int)exitAccounts.size());
                        for (String exitAccount : exitAccounts) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(formulaStrs[0]).append(',');
                            sb.append(formulaStrs[1]).append(',');
                            sb.append('\"').append(exitAccount).append(checkAct).append('\"').append(',');
                            sb.append(formulaStrs[formulaStrs.length - 4]).append(',');
                            sb.append(formulaStrs[formulaStrs.length - 3]).append(',');
                            sb.append(formulaStrs[formulaStrs.length - 2]).append(',');
                            sb.append(formulaStrs[formulaStrs.length - 1]);
                            aformulas.add(sb.toString());
                        }
                        formulaStr = aformulas.size() > 0 ? String.join((CharSequence)"+", aformulas) : "";
                    }
                }
            }
            if (!funcStr.isEmpty()) {
                formulaStr = funcStr + "(" + formulaStr + ")";
            }
        }
        return formulaStr;
    }

    public String getFuncFormula(String formulastr, String orgNum) {
        try {
            Expression exp = ExcelFormulaPaserHelper.parse((String)formulastr);
            if (exp instanceof BinaryOperationExpr) {
                Expression leftExp = ((BinaryOperationExpr)exp).getLeft();
                Expression rightExp = ((BinaryOperationExpr)exp).getRight();
                String operation = ((BinaryOperationExpr)exp).getOperation();
                String left = leftExp.toString();
                String right = rightExp.toString();
                String leftresult = this.getFuncFormula(left, orgNum);
                String rightresult = this.getFuncFormula(right, orgNum);
                if (StringUtils.isEmpty((CharSequence)leftresult)) {
                    return rightresult;
                }
                return "(" + leftresult + ")" + operation + "(" + rightresult + ")";
            }
            if (exp instanceof FunctionExpr) {
                if ("acct".equalsIgnoreCase(((FunctionExpr)exp).getFuncionName())) {
                    return this.getAnalyFormula(exp.toString(), orgNum);
                }
                return exp.toString();
            }
            return exp.toString();
        }
        catch (Exception e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
    }
}

