/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model.formula;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.model.AbstractFormula;
import kd.fi.bcm.business.model.FormulaModel;
import kd.fi.bcm.business.model.formula.AccountCheckParser;
import kd.fi.bcm.business.model.formula.FormulaModelArray;
import kd.fi.bcm.business.model.formula.ParseFormula;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;

public class AcctJudgeFormula
extends FormulaModel {
    private List<AbstractFormula> accts;
    private Set<String> formulastr;
    private Map<String, Object> inParams;
    private AccountCheckParser checkParser;
    private String resultString;
    private ExpressStatus resultStatus;

    public String getResultString() {
        return this.resultString;
    }

    public void setResultString(String resultString) {
        this.resultString = resultString;
    }

    public ExpressStatus getResultStatus() {
        return this.resultStatus;
    }

    public void setResultStatus(ExpressStatus resultStatus) {
        this.resultStatus = resultStatus;
    }

    public AcctJudgeFormula(String formulaStr, Expression e, Map<String, Object> inParams, AccountCheckParser checkParser) {
        super(formulaStr);
        this.inParams = inParams;
        this.checkParser = checkParser;
        this.setParams(inParams);
        this.accts = new ArrayList<AbstractFormula>();
        this.formulastr = new HashSet<String>();
        if (e instanceof FunctionExpr) {
            this.analysisFun((FunctionExpr)e);
        } else if (e instanceof BinaryOperationExpr) {
            this.analysisBinaryOperation((BinaryOperationExpr)e);
        } else if (e instanceof UnaryOperationExpr) {
            this.analysisUnaryOperation((UnaryOperationExpr)e);
        } else {
            this.setMsg(ResManager.loadKDString((String)"\u516c\u5f0f\u9519\u8bef\uff01", (String)"AcctJudgeFormula_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private String getAcctCfg() {
        if (ThreadCache.get((Object)"accttype") != null) {
            return ThreadCache.get((Object)"accttype").toString();
        }
        String type = AcctJudgeFormula.isOpenNewAcct() ? "acctcf001" : "acct";
        ThreadCache.put((Object)"accttype", (Object)type);
        return type;
    }

    static boolean isOpenNewAcct() {
        if (ThreadCache.get((Object)"openNewAcct") != null) {
            return (Boolean)ThreadCache.get((Object)"openNewAcct");
        }
        boolean openNewAcct = QueryServiceHelper.exists((String)"bcm_formularegister", (QFilter[])new QFilter[]{QFilter.of((String)"service = ? and isenable =?", (Object[])new Object[]{"AcctService", "1"})});
        ThreadCache.put((Object)"openNewAcct", (Object)openNewAcct);
        return openNewAcct;
    }

    private void analysisFun(FunctionExpr ex) {
        if (ex.getFuncionName().toLowerCase(Locale.ENGLISH).contains(this.getAcctCfg())) {
            if (this.formulastr.contains(ex.toString())) {
                return;
            }
            this.formulastr.add(ex.toString());
            AbstractFormula f = ParseFormula.analyFunctionType("=" + ex, this.inParams);
            if (f instanceof FormulaModelArray) {
                this.checkParser.analyAcctAccount(f);
                if (StringUtils.isNotEmpty((String)f.getMsg())) {
                    this.setMsg(f.getMsg());
                } else {
                    try {
                        Expression e = ExcelFormulaPaserHelper.parse((String)f.getFormulaStr());
                        f = new AcctJudgeFormula(f.getFormulaStr(), e, this.inParams, this.checkParser);
                        f.setOriginalFormula(ex.toString());
                    }
                    catch (Exception e1) {
                        this.setMsg(ResManager.loadKDString((String)"\u516c\u5f0f\u9519\u8bef\uff01", (String)"AcctJudgeFormula_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                }
            }
            f.setComplete(false);
            this.accts.add(f);
            return;
        }
        for (Object o : ex.getParameters()) {
            if (o instanceof FunctionExpr) {
                this.analysisFun((FunctionExpr)o);
                continue;
            }
            if (!(o instanceof BinaryOperationExpr)) continue;
            this.analysisBinaryOperation((BinaryOperationExpr)o);
        }
    }

    private void analysisUnaryOperation(UnaryOperationExpr e) {
        if (e.getOperand() instanceof FunctionExpr) {
            this.analysisFun((FunctionExpr)e.getOperand());
        } else if (e.getOperand() instanceof BinaryOperationExpr) {
            this.analysisBinaryOperation((BinaryOperationExpr)e.getOperand());
        }
    }

    private void analysisBinaryOperation(BinaryOperationExpr be) {
        if (be.getRight() instanceof FunctionExpr) {
            this.analysisFun((FunctionExpr)be.getRight());
        } else if (be.getRight() instanceof BinaryOperationExpr) {
            this.analysisBinaryOperation((BinaryOperationExpr)be.getRight());
        }
        if (be.getLeft() instanceof FunctionExpr) {
            this.analysisFun((FunctionExpr)be.getLeft());
        } else if (be.getLeft() instanceof BinaryOperationExpr) {
            this.analysisBinaryOperation((BinaryOperationExpr)be.getLeft());
        }
    }

    @Override
    public void getAccountItem(long accounttable, long orgid) {
    }

    @Override
    public void parseAssvalStr(String formulaStr, String subjectStr, boolean checkAccoutExists) {
    }

    @Override
    public String unParse() {
        return null;
    }

    @Override
    public List<Map<String, Object>> query() {
        return null;
    }

    @Override
    public void setTempleId(long templeId) {
        super.setTempleId(templeId);
        for (AbstractFormula acct : this.accts) {
            acct.setTempleId(templeId);
        }
    }

    @Override
    public void setOrgMemberId(long orgMemberId) {
        super.setOrgMemberId(orgMemberId);
        for (AbstractFormula acct : this.accts) {
            acct.setOrgMemberId(orgMemberId);
        }
    }

    @Override
    public void setOrgMemberNum(String orgMemberNum) {
        super.setOrgMemberNum(orgMemberNum);
        for (AbstractFormula acct : this.accts) {
            acct.setOrgMemberNum(orgMemberNum);
        }
    }

    @Override
    public void setRowcols(String[] rowcols) {
        super.setRowcols(rowcols);
        for (AbstractFormula acct : this.accts) {
            acct.setRowcols(rowcols);
        }
    }

    @Override
    public void setRowcolMemNum(String[] rowcolMemNum) {
        super.setRowcolMemNum(rowcolMemNum);
        for (AbstractFormula acct : this.accts) {
            acct.setRowcolMemNum(rowcolMemNum);
        }
    }

    public Map<String, Object> getInParams() {
        return this.inParams;
    }

    public List<AbstractFormula> getAccts() {
        return this.accts;
    }
}

