/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model.formula;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.model.AbstractFormula;
import kd.fi.bcm.business.model.FormulaModel;
import kd.fi.bcm.business.model.formula.CreateFormulaFactory;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import org.apache.commons.lang3.StringUtils;

public class FormulaModelArray
extends AbstractFormula {
    public FormulaModelArray(String formulaStr, Map<String, Object> inParams) {
        super(formulaStr);
        this.setParams(inParams);
    }

    @Override
    public void excute(Long modelId) {
        try {
            Expression exp = ExcelFormulaPaserHelper.parse((String)this.formulaStr);
            if (exp instanceof BinaryOperationExpr) {
                Expression leftExp = ((BinaryOperationExpr)exp).getLeft();
                Expression rightExp = ((BinaryOperationExpr)exp).getRight();
                String operation = ((BinaryOperationExpr)exp).getOperation();
                String left = leftExp.toString();
                String right = rightExp.toString();
                FormulaModelArray leftFormulaModelArray = new FormulaModelArray(left, this.params);
                if (StringUtils.isNotEmpty((CharSequence)this.getMsg())) {
                    leftFormulaModelArray.setMsg(this.getMsg());
                }
                leftFormulaModelArray.excute(modelId);
                if (StringUtils.isNotEmpty((CharSequence)leftFormulaModelArray.getMsg())) {
                    this.setMsg(leftFormulaModelArray.getMsg());
                    return;
                }
                FormulaModelArray rightFormulaModelArray = new FormulaModelArray(right, this.params);
                if (StringUtils.isNotEmpty((CharSequence)this.getMsg())) {
                    rightFormulaModelArray.setMsg(this.getMsg());
                }
                rightFormulaModelArray.excute(modelId);
                if (StringUtils.isNotEmpty((CharSequence)rightFormulaModelArray.getMsg())) {
                    this.setMsg(rightFormulaModelArray.getMsg());
                    return;
                }
                if (leftFormulaModelArray.getResult() == null && rightFormulaModelArray.getResult() == null) {
                    this.setResult(null);
                } else {
                    double l = leftFormulaModelArray.getResult() == null ? 0.0 : leftFormulaModelArray.getResult();
                    double r = rightFormulaModelArray.getResult() == null ? 0.0 : rightFormulaModelArray.getResult();
                    CalContext ctx = new CalContext("", "", "", "", "", "");
                    String finalExp = "(" + l + ")" + operation + "(" + r + ")";
                    CalculateService service = new CalculateService(ctx);
                    service.singleCalculate(finalExp);
                    this.setResult((Double)service.singleCalculate(finalExp));
                }
            } else if (exp instanceof FunctionExpr) {
                FormulaModel formulaModel = CreateFormulaFactory.getFormulaWithParam(this.formulaStr, this.params);
                formulaModel.excute(modelId);
                if (StringUtils.isNotEmpty((CharSequence)formulaModel.getMsg())) {
                    this.setMsg(formulaModel.getMsg());
                    return;
                }
                if (((FunctionExpr)exp).getFuncionName().equalsIgnoreCase("abs")) {
                    this.setResult(Math.abs(formulaModel.getResult()));
                } else {
                    this.setResult(formulaModel.getResult());
                }
            } else {
                this.setResult(new Double(this.formulaStr));
            }
        }
        catch (Exception e) {
            this.setMsg(ResManager.loadKDString((String)"\u516c\u5f0f\u8ba1\u7b97\u51fa\u9519\u3002", (String)"FormulaModelArray_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }
}

