/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model.formula;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.model.FormulaModel;
import kd.fi.bcm.business.model.formula.CreateFormulaFactory;
import kd.fi.bcm.business.model.formula.FormulaModelArray;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import org.apache.commons.lang3.StringUtils;

public class FunctionFormulaModel
extends FormulaModel {
    public static final String ABS = "ABS";

    public FunctionFormulaModel(String formulaStr, Map<String, Object> inParams) {
        super(formulaStr);
        this.setParams(inParams);
    }

    public FunctionFormulaModel(String formulaStr) {
        super(formulaStr);
    }

    @Override
    public void excute(Long modelId) {
        try {
            Expression exp = ExcelFormulaPaserHelper.parse((String)this.formulaStr);
            if (exp instanceof BinaryOperationExpr) {
                if (this.calculateExpression(modelId, (BinaryOperationExpr)exp)) {
                    return;
                }
            } else if (exp instanceof FunctionExpr) {
                int indexabs2;
                int indexabs1 = this.formulaStr.indexOf(40);
                String inlineFormula = this.formulaStr.substring(indexabs1 + 1, indexabs2 = this.formulaStr.lastIndexOf(41));
                if (inlineFormula.toLowerCase(Locale.ENGLISH).startsWith("acct")) {
                    Expression fexp = ExcelFormulaPaserHelper.parse((String)inlineFormula);
                    if (fexp instanceof BinaryOperationExpr) {
                        if (this.calculateExpression(modelId, (BinaryOperationExpr)fexp)) {
                            return;
                        }
                    } else {
                        FormulaModel formulaModel = CreateFormulaFactory.getFormulaWithParam(inlineFormula, this.params);
                        formulaModel.excute(modelId);
                        if (StringUtils.isNotEmpty((CharSequence)formulaModel.getMsg())) {
                            this.setMsg(formulaModel.getMsg());
                            return;
                        }
                        if (((FunctionExpr)exp).getFuncionName().equalsIgnoreCase("abs")) {
                            this.setResult(Math.abs(formulaModel.getResult()));
                        } else {
                            this.setResult(formulaModel.getResult());
                        }
                    }
                } else {
                    FormulaModel formulaModel = CreateFormulaFactory.getFormulaWithParam(inlineFormula, this.params);
                    formulaModel.excute(modelId);
                    if (StringUtils.isNotEmpty((CharSequence)formulaModel.getMsg())) {
                        this.setMsg(formulaModel.getMsg());
                        return;
                    }
                    if (((FunctionExpr)exp).getFuncionName().equalsIgnoreCase("abs")) {
                        this.setResult(Math.abs(formulaModel.getResult()));
                    } else {
                        this.setResult(formulaModel.getResult());
                    }
                }
            } else {
                this.setResult(new Double(this.formulaStr));
            }
        }
        catch (Exception e) {
            this.setMsg(ResManager.loadKDString((String)"\u516c\u5f0f\u8ba1\u7b97\u51fa\u9519\u3002", (String)"FunctionFormulaModel_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    private boolean calculateExpression(Long modelId, BinaryOperationExpr exp) throws ScriptException {
        Expression leftExp = exp.getLeft();
        Expression rightExp = exp.getRight();
        String operation = exp.getOperation();
        String left = leftExp.toString();
        String right = rightExp.toString();
        FormulaModelArray leftFormulaModelArray = new FormulaModelArray(left, this.params);
        leftFormulaModelArray.excute(modelId);
        if (StringUtils.isNotEmpty((CharSequence)leftFormulaModelArray.getMsg())) {
            this.setMsg(leftFormulaModelArray.getMsg());
            return true;
        }
        FormulaModelArray rightFormulaModelArray = new FormulaModelArray(right, this.params);
        rightFormulaModelArray.excute(modelId);
        if (StringUtils.isNotEmpty((CharSequence)rightFormulaModelArray.getMsg())) {
            this.setMsg(rightFormulaModelArray.getMsg());
            return true;
        }
        if (leftFormulaModelArray.getResult() == null && rightFormulaModelArray.getResult() == null) {
            this.setResult(null);
        } else {
            double l = leftFormulaModelArray.getResult() == null ? 0.0 : leftFormulaModelArray.getResult();
            double r = rightFormulaModelArray.getResult() == null ? 0.0 : rightFormulaModelArray.getResult();
            String finalExp = "(" + l + ")" + operation + "(" + r + ")";
            CalContext ctx = new CalContext("", "", "", "", "", "");
            CalculateService service = new CalculateService(ctx);
            this.setResult((Double)service.singleCalculate(finalExp));
        }
        return false;
    }

    @Override
    public void getAccountItem(long accounttable, long orgid) {
    }

    @Override
    public void parseAssvalStr(String formulaStr, String subjectStr, boolean checkAccoutExists) {
    }

    @Override
    public String unParse() {
        return null;
    }

    @Override
    public List<Map<String, Object>> query() {
        return null;
    }
}

