/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.model.formula;

import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.model.AbstractFormula;
import kd.fi.bcm.business.model.FormulaModel;
import kd.fi.bcm.business.model.formula.AccountCheckParser;
import kd.fi.bcm.business.model.formula.AcctJudgeFormula;
import kd.fi.bcm.business.model.formula.CreateFormulaFactory;
import kd.fi.bcm.business.model.formula.FormulaModelArray;
import kd.fi.bcm.common.enums.AcctTypeEnum;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.Expression;

public class ParseFormula {
    public static AbstractFormula parse(String formulaStr, Map<String, Object> inParams, AccountCheckParser checkParser) {
        try {
            String formulaStrUp = formulaStr.toUpperCase(Locale.ENGLISH);
            Expression e = ExcelFormulaPaserHelper.parse((String)formulaStr);
            return new AcctJudgeFormula(formulaStr, e, inParams, checkParser);
        }
        catch (Exception e1) {
            FormulaModel formula = CreateFormulaFactory.getFormulaByType(AcctTypeEnum.ACCTCF.index);
            formula.setFormulaStr(formulaStr);
            formula.setMsg(ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u9519\u8bef\u3002", (String)"ParseFormula_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            return formula;
        }
    }

    public static AbstractFormula analyFunctionType(String formulaStr, Map<String, Object> inParams) {
        String[] params = formulaStr.split(",");
        if (params.length == 8 && params[2].contains("[") && params[3].contains("]")) {
            return new FormulaModelArray(formulaStr, inParams);
        }
        String lastaccount = params[params.length - 5];
        if (params.length != 7 && params[2].contains("\"") && lastaccount.contains("\"")) {
            return new FormulaModelArray(formulaStr, inParams);
        }
        return CreateFormulaFactory.getFormulaWithParam(formulaStr, inParams);
    }
}

