/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mq.consumer;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mq.MessageAcker;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.trace.TraceLogUtil;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.consumer.IConsumer;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import org.apache.commons.compress.utils.Lists;

public class AdjustDimOperationLogMsgConsumer
implements IConsumer {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjustDimOperationLogMsgConsumer.class);

    public void onMessage(MQMessage message, String messageId, boolean resend, MessageAcker acker) {
        Long modelId = (Long)message.getSendMessageValue("modelId", (Object)0L);
        Long sceneId = (Long)message.getSendMessageValue("sceneId", (Object)0L);
        Long yearId = (Long)message.getSendMessageValue("yearId", (Object)0L);
        Long periodId = (Long)message.getSendMessageValue("periodId", (Object)0L);
        Date opTime = new Date((Long)message.getSendMessageValue("createTime", (Object)0L));
        String content = (String)message.getSendMessageValue("content", null);
        String source = (String)message.getSendMessageValue("source", null);
        String traceId = (String)message.getSendMessageValue("traceId", null);
        String specialSourceKey = (String)message.getSendMessageValue("specialSourceKey", (Object)"");
        try {
            Map logQueueMap;
            AdjustOperTypeEnum operTypeEnum = AdjustOperTypeEnum.getEnumByValue((int)((Integer)message.getSendMessageValue("opertype", (Object)-1)));
            List dimKeys = (List)message.getSendMessageValue("dimKeys", (Object)Lists.newArrayList());
            if (operTypeEnum == null) {
                return;
            }
            if (StringUtils.isNotEmpty((String)content) && (logQueueMap = (Map)ObjectSerialUtil.deSerializedBytes((String)content)) != null && !logQueueMap.isEmpty()) {
                DynamicObject errorLog = BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjustoper_log");
                errorLog.set("model", (Object)modelId);
                errorLog.set("scenario", (Object)sceneId);
                errorLog.set("year", (Object)yearId);
                errorLog.set("period", (Object)periodId);
                errorLog.set("opertype", (Object)(operTypeEnum.getValue() + ""));
                errorLog.set("source", (Object)source);
                errorLog.set("user", (Object)RequestContext.get().getCurrUserId());
                errorLog.set("optime", (Object)opTime);
                errorLog.set("traceid", (Object)traceId);
                errorLog.set("source", (Object)specialSourceKey);
                errorLog.set("dimensionkey", (Object)TraceLogUtil.packDimIndexKey(new HashSet<String>(dimKeys)));
                if (AdjustOperTypeEnum.OLAPDATALOCKCHECK_OPERATION == operTypeEnum) {
                    errorLog.set("detaillog", (Object)String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ef4\u5ea6\u7ec4\u5408\u6570\u636e\u9501\u5b9a : %1$s ", (String)"AdjustDimOperationLogMsgConsumer_1", (String)"fi-bcm-business", (Object[])new Object[0]), logQueueMap.keySet()));
                } else {
                    errorLog.set("detaillog", (Object)logQueueMap.toString());
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{errorLog});
            }
        }
        catch (Throwable t) {
            LOG.error(String.format("save AdjustDimOperationLog error : param [traceid : %s ; detaillog : %s]", traceId, content), t);
        }
    }
}

