/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mq.consumer;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.integrationnew.model.DataTraceInfo;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.consumer.IConsumer;
import kd.fi.bcm.common.util.ThrowableHelper;

public class DataTraceFromConsumer
implements IConsumer {
    private static final Log LOG = LogFactory.getLog(DataTraceFromConsumer.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(MQMessage message, String messageId, boolean resend, MessageAcker acker) {
        Map messageBody = message.getSendMessage();
        Long modelId = (Long)messageBody.get("modelId");
        LOG.info("DataTraceFrom consume message: " + messageId + " modelId: " + modelId);
        String dataFromListStr = (String)messageBody.get("dataFromList");
        List dataFromTempList = JSON.parseArray((String)dataFromListStr, DataTraceInfo.class);
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(dataFromTempList.size());
        HashMap<String, List> searchKeyMap = new HashMap<String, List>(16);
        for (DataTraceInfo info : dataFromTempList) {
            String year = info.getYear();
            String period = info.getPeriod();
            String string = info.getSearchKey();
            long saveId = info.getSaveId();
            if (info.getDtf() != null) {
                DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_isdatatrace_from");
                dataEntity.set("model", (Object)modelId);
                dataEntity.set("yearnumber", (Object)year);
                dataEntity.set("periodnumber", (Object)period);
                dataEntity.set("saveId", (Object)saveId);
                dataEntity.set("modifydate", (Object)info.getUpdateDate());
                dataEntity.set("modifier", (Object)info.getModifierId());
                dataEntity.set("searchkey", (Object)string);
                dataEntity.set("datafrom", (Object)JacksonUtils.toJson((Object)info.getDtf()));
                dataEntities.add(dataEntity);
            }
            String key = String.join((CharSequence)";", year, period, String.valueOf(saveId));
            searchKeyMap.computeIfAbsent(key, l -> new ArrayList());
            List searchKeyList = (List)searchKeyMap.get(key);
            searchKeyList.add(string);
        }
        try (TXHandle tx = TX.required();){
            SqlBuilder sqlb = new SqlBuilder();
            try {
                if (!searchKeyMap.isEmpty()) {
                    for (Map.Entry entry : searchKeyMap.entrySet()) {
                        if (entry.getValue() == null) return;
                        if (((List)entry.getValue()).isEmpty()) {
                            return;
                        }
                        String[] keys = ((String)entry.getKey()).split(";");
                        sqlb = new SqlBuilder();
                        sqlb.append("delete from t_bcm_isdatatrace_from where fmodelid = ? and fyearnumber = ? and fperiodnumber = ? and fsaveid <> ? and ", new Object[]{modelId, keys[0], keys[1], Long.parseLong(keys[2])});
                        sqlb.appendIn("fsearchkey", (List)entry.getValue());
                        DB.execute((DBRoute)BCMConstant.DBROUTE, (SqlBuilder)sqlb);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])dataEntities.toArray(new DynamicObject[0]));
                return;
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"SQL\u8bed\u53e5\uff1a%1$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s\u3002", (String)"AdjustmentServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), "delete t_bcm_isdatatrace_from:" + sqlb, ThrowableHelper.toString((Exception)e)));
            }
        }
    }
}

