/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mq.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.DataCollectLogEnum;
import kd.fi.bcm.common.enums.invest.InvFormulaLogTypeEnum;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.consumer.IConsumer;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class InvFormulaTraceLogConsumer
implements IConsumer {
    private static final Log LOG = LogFactory.getLog(InvFormulaTraceLogConsumer.class);

    public void onMessage(MQMessage message, String messageId, boolean resend, MessageAcker acker) {
        InvFormulaLogTypeEnum logType = InvFormulaLogTypeEnum.getEnumByNumber((String)((String)message.getSendMessageValue("logType", (Object)"")));
        if (logType == null) {
            return;
        }
        Long modelId = LongUtil.toLong((Object)message.getSendMessageValue("modelId", (Object)0L));
        Long sceneId = LongUtil.toLong((Object)message.getSendMessageValue("sceneId", (Object)0L));
        Long yearId = LongUtil.toLong((Object)message.getSendMessageValue("yearId", (Object)0L));
        Long periodId = LongUtil.toLong((Object)message.getSendMessageValue("periodId", (Object)0L));
        IDNumberTreeNode orgunit = MemberReader.findEntityMemberById((Long)modelId, (Long)LongUtil.toLong((Object)message.getSendMessageValue("orgunit", (Object)0L)));
        Long userId = LongUtil.toLong((Object)message.getSendMessageValue("userId", (Object)0L));
        Date opdate = new Date((Long)message.getSendMessageValue("createTime", (Object)System.currentTimeMillis()));
        String content = (String)message.getSendMessageValue("content", null);
        Long tempId = LongUtil.toLong((Object)message.getSendMessageValue("tempId", (Object)0L));
        try {
            QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
            qf.add("scenario", "=", (Object)sceneId);
            qf.add("fy", "=", (Object)yearId);
            qf.add("period", "=", (Object)periodId);
            qf.add("org", "=", (Object)orgunit.getId());
            qf.add("logtype", "=", (Object)logType.getLogType());
            qf.add("template", "=", (Object)tempId);
            DeleteServiceHelper.delete((String)logType.getLogEntity(), (QFilter[])qf.toArray());
            List detailLogMsgList = (List)ObjectSerialUtil.deSerializedBytes((String)content);
            if (!CollectionUtil.isEmpty((Collection)detailLogMsgList)) {
                ArrayList<DynamicObject> logResultList = new ArrayList<DynamicObject>(detailLogMsgList.size());
                switch (logType) {
                    case InvSheetFormulaLog: {
                        DynamicObject template = QueryServiceHelper.queryOne((String)logType.getTemplateEntity(), (String)"extdimid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tempId)});
                        if (template == null) break;
                        for (Map detailMsgInfo : detailLogMsgList) {
                            String catalog = (String)detailMsgInfo.get("categorized");
                            String relationtype = (String)detailMsgInfo.get("relationtype");
                            if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(catalog)) {
                                catalog = InvRelationTypeConstant.CatalogEnum.relation.getName();
                                InvRelaTypeEnum relaTypeEnum = InvRelaTypeEnum.findEnumByType((String)relationtype);
                                relationtype = relaTypeEnum == null ? relationtype : relaTypeEnum.getDesc();
                            } else {
                                catalog = InvRelationTypeConstant.CatalogEnum.change_type.getName();
                            }
                            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)logType.getLogEntity());
                            log.set("model", (Object)modelId);
                            log.set("extdimid", (Object)template.getLong("extdimid"));
                            log.set("collecttime", (Object)opdate);
                            log.set("collector", (Object)userId);
                            log.set("fy", (Object)yearId);
                            log.set("period", (Object)periodId);
                            log.set("scenario", (Object)sceneId);
                            log.set("type", detailMsgInfo.computeIfAbsent("logMsgType", a -> Character.valueOf(DataCollectLogEnum.ERROR.index)));
                            log.set("org", (Object)orgunit.getId());
                            log.set("template", (Object)tempId);
                            log.set("logtype", (Object)logType.getLogType());
                            log.set("dims", (Object)new StringJoiner("|").add(detailMsgInfo.computeIfAbsent("account", a -> IDNumberTreeNode.NotFoundTreeNode.getNumber()).toString()).add(catalog).add(relationtype).add(String.format("%s(%s -> %s)", orgunit.getNumber(), detailMsgInfo.computeIfAbsent("shareholder", a -> IDNumberTreeNode.NotFoundTreeNode.getNumber()).toString(), detailMsgInfo.computeIfAbsent("investeecompany", a -> IDNumberTreeNode.NotFoundTreeNode.getNumber()).toString())).toString());
                            log.set("pos", detailMsgInfo.get("pos"));
                            log.set("datafrom", detailMsgInfo.get("formula"));
                            log.set("error", detailMsgInfo.get("error"));
                            logResultList.add(log);
                        }
                        break;
                    }
                    case InvTemplateFormulaLog: {
                        for (Map detailMsgInfo : detailLogMsgList) {
                            String catalog = (String)detailMsgInfo.get("categorized");
                            String relationtype = (String)detailMsgInfo.get("relationtype");
                            if (InvRelationTypeConstant.CatalogEnum.relation.getCode().equals(catalog)) {
                                catalog = InvRelationTypeConstant.CatalogEnum.relation.getName();
                                InvRelaTypeEnum relaTypeEnum = InvRelaTypeEnum.findEnumByType((String)relationtype);
                                relationtype = relaTypeEnum == null ? relationtype : relaTypeEnum.getDesc();
                            } else {
                                catalog = InvRelationTypeConstant.CatalogEnum.change_type.getName();
                            }
                            DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)logType.getLogEntity());
                            log.set("model", (Object)modelId);
                            log.set("collecttime", (Object)opdate);
                            log.set("collector", (Object)userId);
                            log.set("fy", (Object)yearId);
                            log.set("period", (Object)periodId);
                            log.set("scenario", (Object)sceneId);
                            log.set("type", detailMsgInfo.computeIfAbsent("logMsgType", a -> Character.valueOf(DataCollectLogEnum.ERROR.index)));
                            log.set("org", (Object)orgunit.getId());
                            log.set("template", (Object)tempId);
                            log.set("logtype", (Object)logType.getLogType());
                            log.set("dims", (Object)new StringJoiner("|").add(catalog).add(relationtype).add(String.format("%s -> %s", detailMsgInfo.computeIfAbsent("shareholder", a -> IDNumberTreeNode.NotFoundTreeNode.getNumber()).toString(), detailMsgInfo.computeIfAbsent("investeecompany", a -> IDNumberTreeNode.NotFoundTreeNode.getNumber()).toString())).toString());
                            log.set("pos", detailMsgInfo.get("pos"));
                            log.set("datafrom", detailMsgInfo.get("formula"));
                            log.set("error", detailMsgInfo.get("error"));
                            logResultList.add(log);
                        }
                        break;
                    }
                }
                SaveServiceHelper.save((DynamicObject[])logResultList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            LOG.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
        }
    }
}

