/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mq.consumer;

import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.fi.bcm.business.mq.consumer.MessageConsumerFactory;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.MQMsServiceMessage;

public class MQConsumerFacade
implements MessageConsumer {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, MQConsumerFacade.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String jsonString = message instanceof byte[] ? new String((byte[])message) : message.toString();
        try {
            MQMessage msg = MQMessage.cast((String)jsonString);
            try {
                log.startWatch();
                MessageConsumerFactory.getConsumer(msg).onMessage(msg, messageId, resend, acker);
                log.infoEnd(String.format("bcm-consumer message-->%s", msg.genSendMQFormatMessage()));
                acker.ack(messageId);
            }
            catch (Exception e) {
                acker.discard(messageId);
                log.error(String.format("bcm-consumer-error,message is::%s", msg.genSendMQFormatMessage()), (Throwable)e);
            }
        }
        catch (Exception ex) {
            MQMsServiceMessage msServiceMessage = MQMsServiceMessage.cast((String)jsonString);
            try {
                log.startWatch();
                msServiceMessage.onMessage(messageId, resend, acker);
                log.infoEnd(String.format("ms-consumer message-->%s", msServiceMessage.genSendMQFormatMessage()));
                acker.ack(messageId);
            }
            catch (Exception e) {
                acker.discard(messageId);
                log.error(String.format("ms-consumer-error,message is::%s", msServiceMessage.genSendMQFormatMessage()), (Throwable)e);
            }
        }
    }
}

