/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mq.consumer;

import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.fi.bcm.business.mq.consumer.MessageConsumerFactory;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.MQMessageTypeEnum;
import kd.fi.bcm.common.util.MapInitHelper;

public final class MQMessagePublisherServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MQMessagePublisherServiceHelper.class);

    private static void publishMessageAtLoacal(MQMessage msg, boolean isTranscation) {
        if (ThreadCache.get((Object)msg.genSendMQFormatMessage()) != null) {
            return;
        }
        log.info(String.format("publish-bcm-mq-message{%s}", msg.genSendMQFormatMessage()));
        MessageConsumerFactory.getConsumer(msg).onMessage(msg, null, false, null);
        ThreadCache.put((Object)msg.genSendMQFormatMessage(), (Object)Boolean.TRUE);
    }

    public static void publishClearDimMemberCache(String modelNum, String dimNum) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Local_Cache_Clear);
        msg.setSendMessage(MapInitHelper.ofMap((Object)"cache_type", (Object)CacheTypeEnum.DimMemberCache, (Object)"clear_type", (Object)"clear_all_like", (Object)"model", (Object)modelNum, (Object)"dim", (Object)dimNum));
        MQMessagePublisherServiceHelper.publishMessageAtLoacal(msg, false);
    }

    public static void publishClearAllCacheByType(CacheTypeEnum cacheType) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Local_Cache_Clear);
        msg.setSendMessage(MapInitHelper.ofMap((Object)"clear_type", (Object)"clear_all_cache", (Object)"cache_type", (Object)cacheType));
        MQMessagePublisherServiceHelper.publishMessageAtLoacal(msg, false);
        log.info(String.format("MQMessagePublisherServiceHelper clear all cache trace id:%s", RequestContext.get().getTraceId()));
    }

    public static void publishInvalidateTemplateModel(List<String> ids) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_Template_Cache_Clear);
        msg.setSendMessage(MapInitHelper.ofMap((Object)"templateIds", ids));
        MQMessagePublisherServiceHelper.publishMessageAtLoacal(msg, false);
    }

    public static void publishInvalidateTemplateDispense(String modelNum) {
        MQMessage msg = new MQMessage(MQMessageTypeEnum.Type_TemplateDispense_Cache_Clear);
        msg.setSendMessage(MapInitHelper.ofMap((Object)"modelNum", (Object)modelNum));
        MQMessagePublisherServiceHelper.publishMessageAtLoacal(msg, false);
    }
}

