/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mq.consumer;

import java.text.DateFormat;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.fi.bcm.common.auditlog.ESClient;
import kd.fi.bcm.common.auditlog.LocalDateFormat;
import kd.fi.bcm.common.auditlog.LogESHelper;
import kd.fi.bcm.common.json.JacksonUtils;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.consumer.IConsumer;
import kd.fi.bcm.common.oplog.OpLogs;
import org.apache.commons.lang3.StringUtils;

public class OpEventLogConsumer
implements IConsumer {
    private static final Log LOG = LogFactory.getLog(OpEventLogConsumer.class);

    public void onMessage(MQMessage message, String messageId, boolean resend, MessageAcker acker) {
        LOG.debug("op_event_log consume message: " + messageId);
        String indexName = (String)message.getSendMessageValue("_esindex", null);
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw new IllegalArgumentException("message body does not contain 'indexName'");
        }
        LogESHelper.createOpLogIndex((String)indexName);
        Map messageBody = message.getSendMessage();
        messageBody.remove("_esindex");
        OpLogs.OpEventLog content = (OpLogs.OpEventLog)JacksonUtils.fromJson((String)((String)messageBody.get("content")), OpLogs.OpEventLog.class, (DateFormat)new LocalDateFormat());
        String pkId = content.getPkId();
        if (null != pkId) {
            content.setPkId(null);
            ESClient.insertDoc((String)indexName, (String)JacksonUtils.toJson((Object)content, (DateFormat)new LocalDateFormat()), (String)pkId);
        } else {
            ESClient.insertDoc((String)indexName, (String)((String)messageBody.get("content")));
        }
    }
}

