/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mq.consumer;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.localcache.SyncCacheUtil;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.mq.MQMessage;
import kd.fi.bcm.common.mq.consumer.IBroadcastConsumer;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;

public class ReloadLocalCacheConsumer
implements IBroadcastConsumer {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ReloadLocalCacheConsumer.class);

    public void onMessage(MQMessage message) {
        try {
            Map messageBody = message.getSendMessage();
            String modelNum = (String)messageBody.get("modelNum");
            String dimNum = (String)messageBody.get("dimNum");
            String accountId = (String)messageBody.get("accountId");
            String tenantId = (String)messageBody.get("tenantId");
            boolean isSchedule = (Boolean)messageBody.get("isSchedule");
            log.error(String.format("reloadDimensionCache consumer. modelNum::%s,dimNum::%s,isSchedule::%s", modelNum, dimNum, isSchedule));
            RequestContext context = RequestContext.getOrCreate();
            if (StringUtils.isEmpty((CharSequence)context.getAccountId())) {
                context.setAccountId(accountId);
            }
            if (StringUtils.isEmpty((CharSequence)context.getTenantId())) {
                context.setTenantId(tenantId);
            }
            if (isSchedule) {
                String cacheKey = GlobalCacheServiceHelper.packAboutDimCacheKey((String)modelNum, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum));
                long localCacheTime = SyncCacheUtil.getTimeFromLocalCache((String)cacheKey);
                long cacheTime = (localCacheTime == 0L ? System.currentTimeMillis() : localCacheTime) - 172800000L;
                SyncCacheUtil.updateLocalCacheTime((String)cacheKey, (long)cacheTime);
            }
            GlobalCacheServiceHelper.reloadLocalCache((String)modelNum, (String)dimNum);
        }
        catch (Exception ex) {
            log.error(String.format("reloadDimensionCache consumer fail, error msg::%s", ThrowableHelper.toString((Exception)ex)));
        }
    }
}

