/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.mutexRequest;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;

public class AppCacheMutexRequestService {
    private IFormView iFormView;
    private String mutexCacheKey;

    public AppCacheMutexRequestService(IFormView iFormView, String mutexCacheKey) {
        this.iFormView = iFormView;
        this.mutexCacheKey = mutexCacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestMutex(String mutexKey) {
        Object o;
        if (StringUtils.isEmpty((CharSequence)this.mutexCacheKey)) {
            return true;
        }
        Object object = o = new Object();
        synchronized (object) {
            boolean mutex;
            HashMap<String, String> mutexCache = AppCacheServiceHelper.get(this.getMutexCacheKey(), Map.class);
            if (mutexCache == null) {
                mutexCache = new HashMap<String, String>();
            }
            String userName = RequestContext.get().getUserName();
            boolean bl = mutex = !mutexCache.containsKey(mutexKey);
            if (!mutex) {
                boolean currrentUserHoldMutex = false;
                String[] info = ((String)mutexCache.get(mutexKey)).split(",");
                String mutexHolder = info[0];
                if (!ObjectUtils.isEmpty((Object)this.getView().getParentView()) && this.getView().getParentView().existView(mutexHolder)) {
                    currrentUserHoldMutex = userName.equals(info[1]);
                    if (!currrentUserHoldMutex) {
                        String tips = String.format(ResManager.loadKDString((String)"\u5df2\u88ab %s \u9501\u5b9a\uff0c\u53ea\u80fd\u67e5\u770b", (String)"AppCacheMutexRequestService_0", (String)"fi-bcm-business", (Object[])new Object[0]), info[1]);
                        this.getView().showTipNotification(tips, Integer.valueOf(3000));
                    } else {
                        mutex = true;
                    }
                } else {
                    mutexCache.remove(mutexKey);
                    mutex = true;
                }
            }
            if (mutex) {
                String pageId = this.getView().getPageId();
                mutexCache.put(mutexKey, pageId + "," + userName);
                AppCacheServiceHelper.put(this.getMutexCacheKey(), mutexCache);
            }
            return mutex;
        }
    }

    public boolean releaseMutexLock(Object oldMutexKey, boolean ischeckview) {
        if (StringUtils.isEmpty((CharSequence)this.mutexCacheKey)) {
            return true;
        }
        if (!ObjectUtils.isEmpty((Object)oldMutexKey)) {
            Map mutexCache = AppCacheServiceHelper.get(this.getMutexCacheKey(), Map.class);
            String oldMutexKeyString = oldMutexKey.toString();
            if (mutexCache != null && mutexCache.get(oldMutexKeyString) != null) {
                String[] info = ((String)mutexCache.get(oldMutexKeyString)).split(",");
                String pageId = this.getView().getPageId();
                if (!ischeckview || info[0].equals(pageId)) {
                    mutexCache.remove(oldMutexKeyString);
                    AppCacheServiceHelper.put(this.getMutexCacheKey(), mutexCache);
                    return true;
                }
            }
        }
        return false;
    }

    private String getMutexCacheKey() {
        return this.mutexCacheKey;
    }

    private IFormView getView() {
        return this.iFormView;
    }

    public void setiFormView(IFormView iFormView) {
        this.iFormView = iFormView;
    }
}

