/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.olap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.api.ApiResultDTO;
import kd.fi.bcm.business.dimension.api.QueryOlapDataDTO;
import kd.fi.bcm.business.dimension.api.QueryOlapScope;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.sql.MDResultSetReader;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;

public class OlapDataQueryHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(OlapDataQueryHelper.class);

    public static ApiResultDTO queryData(String modelNum, QueryOlapDataDTO dto) {
        Set process;
        boolean includeParentChild;
        Map<String, String> fixDims = dto.getFixDim();
        if (fixDims == null || fixDims.isEmpty()) {
            return ApiResultDTO.fail("fixDim is required.");
        }
        String year = fixDims.get("Year");
        String period = fixDims.get("Period");
        String scenario = fixDims.get("Scenario");
        if (StringUtils.isEmpty((CharSequence)year) || StringUtils.isEmpty((CharSequence)period) || StringUtils.isEmpty((CharSequence)scenario)) {
            return ApiResultDTO.fail("Year|Period|Scenario is required.");
        }
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Map allDimMap = MemberReader.getDimNumberMapNameById((long)modelId);
        LinkedHashSet<String> showDims = dto.getShowDims();
        showDims.removeIf(k -> StringUtils.trimToNull((String)k) == null);
        for (String showDim : showDims) {
            if (allDimMap.containsKey(showDim)) continue;
            return ApiResultDTO.fail(String.format("showDim:%s is not exists.", showDim));
        }
        HashMap<String, Set<String>> membersMap = new HashMap<String, Set<String>>(16);
        List<QueryOlapScope> filters = dto.getFilters();
        for (QueryOlapScope dim : filters) {
            if (!allDimMap.containsKey(dim.getDim())) {
                return ApiResultDTO.fail(String.format("dim:%s is not exists.", dim.getDim()));
            }
            if (CollectionUtils.isEmpty(dim.getVal())) {
                return ApiResultDTO.fail(String.format("dim:%s val is required.", dim.getDim()));
            }
            if (StringUtils.isEmpty((CharSequence)dim.getScope()) || dim.getScope().equals(String.valueOf(RangeEnum.VALUE_10.getValue()))) {
                membersMap.computeIfAbsent(dim.getDim(), m -> new HashSet(16)).addAll(dim.getVal());
                continue;
            }
            String entityName = MemberReader.getEntityNumberByDim((String)modelNum, (String)dim.getDim());
            for (String val : dim.getVal()) {
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dim.getDim(), (String)val);
                if (node == null || node == IDNumberTreeNode.NotFoundTreeNode) {
                    return ApiResultDTO.fail(String.format("dim:%s val:%s is not exists.", dim.getDim(), val));
                }
                Set<String> numbers = QueryMemberDetailsHelper.getMemberIdsByRange4Number(entityName, node.getId(), node.getNumber(), Integer.parseInt(dim.getScope()), String.valueOf(modelId));
                membersMap.computeIfAbsent(dim.getDim(), m -> new HashSet(numbers.size())).addAll(numbers);
            }
        }
        if (!membersMap.containsKey("Entity") || ((Set)membersMap.get("Entity")).isEmpty()) {
            return ApiResultDTO.fail("not found the effective entity.");
        }
        if (!dto.isIgnorePermission() && !MemberPermHelper.isModelAdmin(modelId)) {
            long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
            Set numbers = (Set)membersMap.get("Entity");
            HashMap numberIdMap = new HashMap(numbers.size());
            numbers.forEach(n -> {
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)"Entity", (String)n);
                numberIdMap.put(node.getId(), node.getNumber());
            });
            Set<Long> noPermIds = PermissionServiceImpl.getInstance(modelId).matchNoPermMembers(dimId, "bcm_entitymembertree", numberIdMap.keySet());
            Set noPermNumbers = noPermIds.stream().map(n -> (String)numberIdMap.get(n)).collect(Collectors.toSet());
            boolean ignorePermCheck = Boolean.parseBoolean(System.getProperty("fi.bcm.queryolapdata.ignorePermCheck", "false"));
            if (!(ignorePermCheck || dto.isIgnoreNoPermissionMember() || noPermIds.isEmpty())) {
                return ApiResultDTO.fail(String.format("Entity:%s don't have read or write permission.", String.join((CharSequence)",", noPermNumbers)));
            }
            if (!noPermNumbers.isEmpty()) {
                numbers.removeAll(noPermNumbers);
            }
        }
        boolean bl = includeParentChild = (process = (Set)membersMap.get("Process")) != null && CollectionUtils.containsAny((Collection)OrgRelaProcessMembPool.getRelaProcessMembPool(), (Collection)process);
        if (includeParentChild) {
            Set entity = (Set)membersMap.get("Entity");
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("number", "in", (Object)entity));
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("number", "!=", (Object)"Entity"));
            QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"parent.number, number", (QFilter[])filter.toArray()).forEach(e -> entity.add(e.getString("parent.number") + "_" + e.getString("number")));
        }
        showDims = showDims == null || showDims.isEmpty() ? new LinkedHashSet(allDimMap.keySet()) : showDims;
        Map<String, Object> data = OlapDataQueryHelper.queryOlap(modelNum, showDims, membersMap, dto);
        return ApiResultDTO.success(data);
    }

    public static Map<String, Object> queryOlap(String modelNum, Set<String> showDims, Map<String, Set<String>> members, QueryOlapDataDTO dto) {
        log.startWatch();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        MultiKeyMap nameMap = new MultiKeyMap();
        if (dto.isIncludeName()) {
            members.forEach((k, v) -> v.forEach(num -> {
                String name = MemberReader.findMemberByNumber((String)modelNum, (String)k, (String)num).getName();
                name = StringUtils.isNotEmpty((CharSequence)name) ? num + "|" + name : num;
                nameMap.put(k, num, (Object)name);
            }));
        }
        SQLBuilder sql = new SQLBuilder(modelNum);
        sql.addMeasures(FacTabFieldDefEnum.FIELD_MONEY.getField());
        sql.addSelectField(showDims.toArray(new String[0]));
        int top = Integer.parseInt(System.getProperty("fi.bcm.queryolapdata.top", "200000"));
        sql.setIncludeNull(dto.isIncludeNull());
        sql.setExcludeDynaData(dto.isExcludeDynaData());
        dto.getFixDim().forEach((k, v) -> sql.addFilter((String)k, (String)v));
        members.forEach((k, v) -> sql.addFilter((String)k, v.toArray(new String[0])));
        ArrayList rowList = new ArrayList(1024);
        try (MDResultSetReader resultSet = OlapServiceHelper.queryDataReader(sql);){
            while (resultSet.next()) {
                ArrayList<Object> row = new ArrayList<Object>(16);
                showDims.forEach(dim -> {
                    String number = resultSet.getString((String)dim);
                    if (dto.isIncludeName()) {
                        if (!nameMap.containsKey(dim, (Object)number)) {
                            String name = MemberReader.findMemberByNumber((String)modelNum, (String)dim, (String)number).getName();
                            name = StringUtils.isNotEmpty((CharSequence)name) ? number + "|" + name : number;
                            nameMap.put(dim, (Object)number, (Object)name);
                        }
                        row.add(nameMap.get(dim, (Object)resultSet.getString((String)dim)));
                    } else {
                        row.add(number);
                    }
                });
                row.add(resultSet.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                rowList.add(row);
                if (rowList.size() <= top) continue;
                throw new RuntimeException("olap data is too large,limit:" + top);
            }
        }
        catch (Exception e) {
            log.error(ThrowableHelper.generatekernelMessageInfo((Throwable)e, (int)20));
        }
        result.put("dimension", showDims);
        result.put("datas", rowList);
        log.infoEnd("query olap data end,result size is:" + rowList.size());
        return result;
    }
}

