/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.util.OlapCommandUtil;

public class OlapSaveBuilder {
    private String modelNum;
    private List<Pair<String, String>> fixDimensions = new ArrayList<Pair<String, String>>();
    private String[] crossDimensions;
    private String[] measures;
    private Collection<Pair<String[], Object>> values;
    private boolean isNeedUpdateDataStatus = true;
    private OlapSourceEnum sourceEnum;

    public OlapSaveBuilder(String modelNum) {
        this.modelNum = modelNum;
    }

    public void setSourceEnum(OlapSourceEnum sourceEnum) {
        this.sourceEnum = sourceEnum;
    }

    public void addFixedDimension(String dimNum, String dimMemNum) {
        this.fixDimensions.add((Pair<String, String>)Pair.onePair((Object)dimNum, (Object)dimMemNum));
    }

    public void setCrossDimensions(String ... dimNums) {
        this.crossDimensions = dimNums;
    }

    public void setMeasures(String ... measures) {
        this.measures = measures;
    }

    public void setCellSet(Collection<Pair<String[], Object>> values) {
        this.values = values;
    }

    public void doSave() {
        String[] stringArray;
        if (this.values == null) {
            return;
        }
        this.checkCondition();
        SaveCommandInfo info = new SaveCommandInfo();
        this.fixDimensions.forEach(e -> info.addfixedDimension(new String[]{(String)e.p1, (String)e.p2}));
        if (this.measures == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = FacTabFieldDefEnum.FIELD_MONEY.getField();
        } else {
            stringArray = this.measures;
        }
        this.measures = stringArray;
        info.setMeasures(this.measures);
        info.addDimensions(this.crossDimensions);
        if (this.sourceEnum != null) {
            OlapCommandUtil.addSourceMeasure((String)this.modelNum, (CommandInfo)info, (OlapSourceEnum)this.sourceEnum);
        }
        CellSet cellSets = new CellSet(this.crossDimensions, this.measures);
        cellSets.setFromQuery(false);
        this.values.removeIf(p -> Arrays.stream((Object[])p.p1).anyMatch(dim -> dim == null));
        this.values.iterator().forEachRemaining(v -> cellSets.set((String[])v.p1, this.measures[0], v.p2));
        OlapServiceHelper.saveData(info, cellSets, this.modelNum, this.isNeedUpdateDataStatus);
    }

    private void checkCondition() {
        if (this.crossDimensions == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u4ea4\u53c9\u7ef4\u5ea6\u7ec4\u5408\u672a\u8bbe\u7f6e\u3002", (String)"OlapSaveBuilder_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public boolean isNeedMonitorDataStatus() {
        return this.isNeedUpdateDataStatus;
    }

    public void setNeedMonitorDataStatus(boolean isNeedUpdateDataStatus) {
        this.isNeedUpdateDataStatus = isNeedUpdateDataStatus;
    }
}

