/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.olap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;

public class OrgRelaMembSupplier
implements IRelaMembSupplier<String, String> {
    private static final long serialVersionUID = 1L;
    private Long _mainOrgId;
    private String _mainOrgNum;
    private Long _modelId;
    private String cube;
    private String superParentLongNum;
    private Map<String, String> snapshot;

    public Long get_mainOrgId() {
        return this._mainOrgId;
    }

    public Long get_modelId() {
        return this._modelId;
    }

    public OrgRelaMembSupplier(Long mainOrgId, String mainOrgNum, Long modelId) {
        this._mainOrgId = mainOrgId;
        this._mainOrgNum = mainOrgNum;
        this._modelId = modelId;
        this.snapshot = new HashMap<String, String>(1);
        this.initSuperParentLongNumber();
    }

    public String getCube() {
        if (this.cube == null) {
            this.cube = MemberReader.findModelNumberById((Object)this._modelId);
        }
        return this.cube;
    }

    @Override
    public String access(String orgNum) {
        if (!this.snapshot.containsKey(orgNum)) {
            this.snapshot.put(orgNum, this.getRelaMembInMainOrgTreeStruct(orgNum));
        }
        return this.snapshot.get(orgNum);
    }

    @Override
    public String getCurrentPeriod() {
        return null;
    }

    @Override
    public String getCurrentYear() {
        return null;
    }

    @Override
    public String getCurrentScenario() {
        return null;
    }

    @Override
    public String getModelNumber() {
        return this.cube;
    }

    private String getRelaMembInMainOrgTreeStruct(String orgNum) {
        String pNum;
        IDNumberTreeNode org = null;
        IDNumberTreeNode baseOrg = MemberReader.findMemberByNumber((String)this.getCube(), (String)DimEntityNumEnum.ENTITY.getNumber(), (String)orgNum);
        ArrayList<IDNumberTreeNode> nodes = new ArrayList<IDNumberTreeNode>();
        if (baseOrg != null) {
            if (baseOrg.getLongNumber().startsWith(this.superParentLongNum)) {
                nodes.add(baseOrg);
            }
            for (IDNumberTreeNode node : baseOrg.getShareNodes()) {
                if (!node.getLongNumber().startsWith(this.superParentLongNum)) continue;
                nodes.add(node);
            }
        }
        if (nodes.size() == 1) {
            org = (IDNumberTreeNode)nodes.get(0);
        } else if (nodes.isEmpty()) {
            org = baseOrg;
        }
        String string = pNum = org == null || org.getParent() == null ? null : org.getParent().getNumber();
        if (org == null || "RateEntity".equals(pNum)) {
            return orgNum;
        }
        return String.join((CharSequence)"_", pNum, org.getNumber());
    }

    private void initSuperParentLongNumber() {
        IDNumberTreeNode org = MemberReader.findMemberById((long)this._modelId, (String)DimEntityNumEnum.ENTITY.getEntityNum(), (Long)this._mainOrgId);
        String pNum = org.getParent() == null ? null : org.getParent().getNumber();
        String split = String.valueOf('!');
        String[] splitArr = org.getLongNumber().split(split);
        String string = this.superParentLongNum = splitArr.length >= 2 ? String.join((CharSequence)split, splitArr[0], splitArr[1]) : splitArr[0];
        if (!"RateEntity".equals(pNum)) {
            this.snapshot.put(this._mainOrgNum, String.join((CharSequence)"_", pNum, this._mainOrgNum));
            if (pNum == null) {
                this.snapshot.put(this._mainOrgNum, this._mainOrgNum);
            }
        }
    }
}

