/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.olap;

import java.util.Optional;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.common.util.PeriodUtils;

public class PeriodRelaMembSupplier
implements IRelaMembSupplier<String, String> {
    private static final long serialVersionUID = 1L;
    private String cube;
    private String year;
    private String period;
    private String scenario;
    private boolean isIncludeAdjust = false;
    private String lastPeriod;
    private String lastYear;

    public PeriodRelaMembSupplier(String cube, String year, String period, boolean isIncludeAdjust) {
        this.cube = cube;
        this.year = year;
        this.period = period;
        this.isIncludeAdjust = isIncludeAdjust;
    }

    public PeriodRelaMembSupplier(String cube, String year, String period, String scenario) {
        this.cube = cube;
        this.year = year;
        this.period = period;
        this.scenario = scenario;
        this.isIncludeAdjust = false;
    }

    public PeriodRelaMembSupplier(String cube, String year, String period) {
        this(cube, year, period, false);
    }

    @Override
    public String access(String member) {
        if ("CurrentPeriod".equals(member)) {
            return this.period;
        }
        if ("LastPeriod".equals(member)) {
            if (this.lastPeriod == null) {
                Optional opt = PeriodUtils.getLastPeriod((String)this.cube, (String)this.period, (boolean)this.isIncludeAdjust);
                this.lastPeriod = opt.isPresent() ? (String)opt.get() : "";
            }
            return this.lastPeriod;
        }
        if ("CurrentYear".equals(member)) {
            return this.year;
        }
        if ("LastYear".equals(member)) {
            if (this.lastYear == null) {
                Optional opt = PeriodUtils.getLastYear((String)this.cube, (String)this.year);
                this.lastYear = opt.isPresent() ? (String)opt.get() : "";
            }
            return this.lastYear;
        }
        return member;
    }

    @Override
    public String getCurrentPeriod() {
        return this.period;
    }

    @Override
    public String getCurrentYear() {
        return this.year;
    }

    @Override
    public String getCurrentScenario() {
        return this.scenario;
    }

    @Override
    public String getModelNumber() {
        return this.cube;
    }
}

