/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.olap.dynamic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.model.MemberTreeNode;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.ThrowableHelper;

public class DynamicOlapHelper {
    public static void setDynamicModel(long modelId, String cube, boolean isDynamic) {
        if (StringUtils.isEmpty((String)cube)) {
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)});
            cube = model.getString("number");
        }
        ArrayList<DynamicObject> changeDim = new ArrayList<DynamicObject>();
        for (DynamicObject dim : BusinessDataServiceHelper.load((String)"bcm_dimension", (String)"id,number,membermodel,isexcdycompute", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)})) {
            String membermodel = dim.getString("membermodel");
            if (isDynamic && (DimEntityNumEnum.ENTITY.getEntityNum().equals(membermodel) || DimEntityNumEnum.YEAR.getEntityNum().equals(membermodel) || DimEntityNumEnum.PERIOD.getEntityNum().equals(membermodel) || DimEntityNumEnum.SCENARIO.getEntityNum().equals(membermodel) || DimEntityNumEnum.CURRENCY.getEntityNum().equals(membermodel))) continue;
            String number = dim.getString("number");
            dim.set("isexcdycompute", (Object)isDynamic);
            changeDim.add(dim);
            if (isDynamic) {
                DynamicOlapHelper.setDynamicDim(modelId, cube, number);
                continue;
            }
            DynamicOlapHelper.unSetDynamicDim(modelId, cube, number);
        }
        if (!changeDim.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])changeDim.toArray(new DynamicObject[0]));
        }
    }

    public static void setDynamicDim(long modelId, String cube, String dimnum) {
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimnum);
        Map<Long, MemberTreeNode> membersMap = TreeStructureServiceHelper.getAllMember(entity, modelId, (Pair<Supplier<String>, Function<DynamicObject, Map<String, Object>>>)Pair.onePair(() -> "storagetype,aggoprt,", obj -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("storagetype", obj.getString("storagetype"));
            map.put("aggoprt", obj.getString("aggoprt"));
            return map;
        }));
        List<Long> ids = DynamicOlapHelper.getCanChangeIds(membersMap);
        if (!ids.isEmpty()) {
            DynamicObject[] mbs = BusinessDataServiceHelper.load((String)entity, (String)"number,storagetype", (QFilter[])new QFilter[]{new QFilter("dimension.number", "=", (Object)dimnum), new QFilter("id", "in", ids)});
            try (TXHandle tx = TX.required();){
                try {
                    for (DynamicObject mb : mbs) {
                        if (dimnum.equals(mb.getString("number"))) continue;
                        mb.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.index);
                    }
                    SaveServiceHelper.update((DynamicObject[])mbs);
                    DynamicComputingServiceHelper.repairModelByDim(cube, dimnum, true);
                    if (DimEntityNumEnum.INTERCOMPANY.getNumber().equals(dimnum)) {
                        DynamicOlapHelper.updateInternalDimension(modelId, 4, 5);
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(ThrowableHelper.printError((Throwable)e));
                }
            }
        }
    }

    public static void unSetDynamicDim(long modelId, String cube, String dimnum) {
        String entity = DimEntityNumEnum.getEntieyNumByNumber((String)dimnum);
        DynamicObject dim = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)dimnum)});
        DynamicObject[] mems = BusinessDataServiceHelper.load((String)entity, (String)"number,storagetype", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("dimension", "=", dim.get("id")), new QFilter("storagetype", "=", (Object)StorageTypeEnum.DYNAMIC.index)});
        if (mems != null && mems.length > 0) {
            try (TXHandle tx = TX.required();){
                try {
                    HashMap<String, MemberStorageTypes> storageMap = new HashMap<String, MemberStorageTypes>();
                    boolean internalBol = DimEntityNumEnum.INTERCOMPANY.getNumber().equals(dimnum);
                    for (DynamicObject mb : mems) {
                        if (dimnum.equals(mb.getString("number")) && !internalBol) continue;
                        mb.set("storagetype", (Object)StorageTypeEnum.STORAGE.index);
                        storageMap.put(mb.getString("number"), MemberStorageTypes.Stored);
                    }
                    OlapServiceHelper.batchAlterMemberStorageType(cube, dimnum, storageMap);
                    SaveServiceHelper.update((DynamicObject[])mems);
                    if (internalBol) {
                        DynamicOlapHelper.updateInternalDimension(modelId, 5, 4);
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw new KDBizException(ThrowableHelper.printError((Throwable)e));
                }
            }
        }
    }

    private static void updateInternalDimension(long modelId, int old, int newVal) {
        if (modelId == 0L) {
            return;
        }
        String fields = "model,number,storagetype";
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("number", "=", (Object)DimEntityNumEnum.INTERCOMPANY.getNumber()));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)fields, (QFilter[])qFilter.toArray());
        int storagtype = dynamicObject.getInt("storagetype");
        if (storagtype == old) {
            dynamicObject.set("storagetype", (Object)newVal);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }

    private static List<Long> getCanChangeIds(Map<Long, MemberTreeNode> membersMap) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (MemberTreeNode m : membersMap.values()) {
            boolean canChange;
            boolean bl = canChange = m.getChildren() != null && !m.getChildren().isEmpty();
            if (canChange) {
                String st = m.getData().get("storagetype").toString();
                boolean bl2 = canChange = StorageTypeEnum.STORAGE.index.equals(st) || StorageTypeEnum.UNSHARE.index.equals(st) || StorageTypeEnum.DYNAMIC.index.equals(st);
            }
            if (canChange) {
                for (MemberTreeNode c : m.getChildren()) {
                    String agg = c.getData().get("aggoprt").toString();
                    if (AggOprtEnum.ADD.sign.equals(agg) || AggOprtEnum.SUBSTRACT.sign.equals(agg) || AggOprtEnum.SKIP.sign.equals(agg) || AggOprtEnum.NONE.sign.equals(agg)) continue;
                    canChange = false;
                    break;
                }
            }
            if (!canChange) continue;
            ids.add(m.getId());
        }
        return ids;
    }

    public static boolean checkCanPaste(String storagetype, DynamicObject mem) {
        String aggoprt = mem.getString("aggoprt");
        if (StorageTypeEnum.DYNAMIC.getOIndex().equals(storagetype)) {
            return DynamicOlapHelper.ifCanbeDynamicChild(aggoprt);
        }
        return true;
    }

    public static boolean ifCanbeDynamicChild(String aggoprt) {
        return AggOprtEnum.SUBSTRACT.getSign().equals(aggoprt) || AggOprtEnum.ADD.getSign().equals(aggoprt) || AggOprtEnum.SKIP.getSign().equals(aggoprt);
    }
}

