/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.olap.scale;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CurrencyScaleEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kotlin.Pair;

public class CurrencyScaleHandler {
    public static final int DEF_CURRENCY_SCALE = 2;
    public static final int DISABLE_ACCOUNT_SCALE = -5;

    private CurrencyScaleHandler() {
        throw new IllegalStateException("Illegal Class Constructor");
    }

    public static void handle(SaveCommandInfo info, CellSet cellSets, String cubeNumber) {
        List dims = info.getDimensions();
        List fixedDimensions = info.getFixedDimensions();
        Long modelId = MemberReader.findModelIdByNum((String)cubeNumber);
        Map userDefines = MemberReader.getUsetDefineDimNumberMapNameById((long)modelId);
        ArrayList<String> dimlist = new ArrayList<String>();
        dimlist.addAll(DataTypeEnum.getDataTypePerSetDims((Object)modelId));
        dimlist.addAll(userDefines.keySet());
        Map<String, DataTypeEnum> dataTypeCache = CurrencyScaleHandler.getDataTypeMap(modelId, dimlist);
        HashMap<String, String> cellDim = new HashMap<String, String>(16);
        for (FixedDimension fixedDimension : fixedDimensions) {
            cellDim.put(fixedDimension.getName(), fixedDimension.getValue());
        }
        String fMoney = FacTabFieldDefEnum.FIELD_MONEY.getField();
        Iterator accountIterator = cellSets.getMetricEntries(fMoney);
        HashSet<String> accountNumberSet = new HashSet<String>(10);
        while (accountIterator.hasNext()) {
            MembersKey key = (MembersKey)((Pair)accountIterator.next()).getFirst();
            String accountMember = CurrencyScaleHandler.getMemberNumberByKey("Account", key, info);
            accountNumberSet.add(accountMember);
        }
        Map<String, Integer> accountMap = CurrencyScaleHandler.getAccountScale(modelId, accountNumberSet);
        for (String measure : info.getMeasures()) {
            if (!measure.equals(fMoney)) {
                return;
            }
            Iterator it = cellSets.getMetricEntries(fMoney);
            Pair<Integer, String> processPair = CurrencyScaleHandler.getMemberInfoPair("Process", info);
            int processIndex = (Integer)processPair.getFirst();
            Set<String> tcfNumbers = CurrencyScaleHandler.getAllTcfChildMember(cubeNumber);
            HashMap<String, Integer> scaleCache = new HashMap<String, Integer>(16);
            ArrayList<String[]> coordinates = new ArrayList<String[]>(10);
            while (it.hasNext()) {
                Pair entry = (Pair)it.next();
                Object value = entry.getSecond();
                MembersKey key = (MembersKey)entry.getFirst();
                for (int i = 0; i < dims.size(); ++i) {
                    cellDim.put((String)dims.get(i), key.get(i).toString());
                }
                DataTypeEnum dimCellDataType = CurrencyScaleHandler.getDimCellDataType(dataTypeCache, cellDim, dimlist);
                if (DataTypeEnum.DATETP == dimCellDataType) {
                    cellSets.set(CurrencyScaleHandler.getCoordinates(key), fMoney, (Object)DateTimeUtils.formatDateToUTC((String)String.valueOf(value)));
                    continue;
                }
                if (!(value instanceof Number)) {
                    DataTypeEnum oriDimCellDataType = CurrencyScaleHandler.getDimCellDataTypeNoEnum(dataTypeCache, cellDim, dimlist);
                    if (DataTypeEnum.DEFAULT != oriDimCellDataType && DataTypeEnum.CURRENCY != oriDimCellDataType && DataTypeEnum.UNCURRENCY != oriDimCellDataType && DataTypeEnum.PROPORTION != oriDimCellDataType) continue;
                    coordinates.add(CurrencyScaleHandler.getCoordinates(key));
                    continue;
                }
                String processMember = processIndex == -1 ? (String)processPair.getSecond() : key.getKey(processIndex);
                if (!tcfNumbers.contains(processMember) && DataTypeEnum.CURRENCY == dimCellDataType) {
                    String currencyMember = CurrencyScaleHandler.getMemberNumberByKey("Currency", key, info);
                    String scenarioMember = CurrencyScaleHandler.getMemberNumberByKey("Scenario", key, info);
                    String accountMember = CurrencyScaleHandler.getMemberNumberByKey("Account", key, info);
                    int accountScale = -5;
                    if (accountMap.get(accountMember) != null) {
                        accountScale = accountMap.get(accountMember);
                    }
                    CurrencyScaleHandler.handleCurrency(cubeNumber, cellSets, fMoney, (Pair<String, String>)new Pair((Object)scenarioMember, (Object)currencyMember), (Pair<MembersKey, Object>)entry, scaleCache, accountScale);
                    continue;
                }
                BigDecimal bigDecimal = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
                if (bigDecimal.scale() <= 15) continue;
                value = bigDecimal.setScale(15, RoundingMode.HALF_UP);
                cellSets.set(CurrencyScaleHandler.getCoordinates(key), fMoney, value);
            }
            if (coordinates.size() <= 0) continue;
            coordinates.forEach(ele -> cellSets.remove(ele));
        }
    }

    public static void handleToOlapScale(SaveCommandInfo info, CellSet cellSets) {
        String fMoney = FacTabFieldDefEnum.FIELD_MONEY.getField();
        for (String measure : info.getMeasures()) {
            if (!measure.equals(fMoney)) {
                return;
            }
            Iterator it = cellSets.getMetricEntries(fMoney);
            while (it.hasNext()) {
                BigDecimal bigDecimal;
                Pair entry = (Pair)it.next();
                MembersKey key = (MembersKey)entry.getFirst();
                Object value = entry.getSecond();
                if (!(value instanceof BigDecimal) || (bigDecimal = (BigDecimal)value).scale() <= 15) continue;
                value = bigDecimal.setScale(15, RoundingMode.HALF_UP);
                cellSets.set(CurrencyScaleHandler.getCoordinates(key), fMoney, value);
            }
        }
    }

    public static void handleCurrency(String cubeNumber, CellSet cellSets, String fMoney, Pair<String, String> pair, Pair<MembersKey, Object> entry, Map<String, Integer> scaleCache, int accountScale) {
        String combinaKey = (String)pair.getFirst() + (String)pair.getSecond();
        Integer scale = scaleCache.get(combinaKey);
        if (accountScale != -5) {
            scale = accountScale;
        } else if (scale == null) {
            scale = CurrencyScaleHandler.getCurrencyScale((String)pair.getFirst(), (String)pair.getSecond(), cubeNumber);
            scaleCache.put(combinaKey, scale);
        }
        MembersKey key = (MembersKey)entry.getFirst();
        Object value = entry.getSecond();
        BigDecimal result = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        result = CurrencyScaleHandler.handleByScaleEnum(result, scale);
        cellSets.set(CurrencyScaleHandler.getCoordinates(key), fMoney, (Object)result);
    }

    public static BigDecimal handleByScaleEnum(BigDecimal value, Integer scale) {
        CurrencyScaleEnum scaleEnum = CurrencyScaleEnum.value((String)scale.toString());
        int unit = Math.abs(Integer.parseInt(scaleEnum.value));
        switch (scaleEnum) {
            case TENTHOUSAND: 
            case THOUSAND: 
            case HUNDRED: 
            case TEN: 
            case ONE: {
                BigDecimal tenNum = BigDecimal.TEN.pow(unit);
                value = value.divide(tenNum, 0, RoundingMode.HALF_UP);
                value = value.multiply(tenNum);
                break;
            }
            case ONESCALE: 
            case TWOSCALE: 
            case THIRDSCALE: 
            case FOURSCALE: 
            case FIVESCALE: 
            case SIXSCALE: 
            case SEVENSCALE: 
            case EIGHTSCALE: 
            case NINESCALE: 
            case TENSCALE: 
            case ELEVENSCALE: 
            case TWELVESCALE: 
            case THIRTYSCALE: 
            case FOURTYSCALE: 
            case FIFTYSCALE: {
                value = value.setScale((int)scale, RoundingMode.HALF_UP);
                break;
            }
        }
        return value;
    }

    public static Integer getCurrencyScale(String scenarioNumber, String currencyNumber, String cubeNumber) {
        Long modelId = MemberReader.findModelIdByNum((String)cubeNumber);
        return (Integer)ThreadCache.get((Object)("getCurrencyScale" + cubeNumber + "_" + scenarioNumber + "_" + currencyNumber), () -> {
            String selectFields = "scaleentry.scale as scale";
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)modelId);
            qf.add("number", "=", (Object)scenarioNumber);
            qf.add("scaleentry.currency.number", "=", (Object)currencyNumber);
            DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_scenemembertree", (String)selectFields, (QFilter[])qf.toArray());
            if (dimObj == null || dimObj.get("scale") == null) {
                return 2;
            }
            return dimObj.getInt("scale");
        });
    }

    public static Map<String, Integer> getAccountScale(long modelId, Collection<String> accountNumberList) {
        Map<String, Integer> accountMap = CurrencyScaleHandler.getAccountScale(modelId);
        HashMap<String, Integer> accountMapinlist = new HashMap<String, Integer>(accountNumberList.size());
        for (String account : accountNumberList) {
            accountMapinlist.put(account, accountMap.get(account));
        }
        return accountMapinlist;
    }

    public static Map<String, Integer> getAccountScale(long modelId) {
        return (Map)ThreadCache.get((Object)("accountScale" + modelId), () -> {
            String selectField = "accountnumber,scale";
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
            DynamicObjectCollection accountList = QueryServiceHelper.query((String)"bcm_accountscale", (String)selectField, (QFilter[])qfBuilder.toArray());
            HashMap<String, Integer> accountMap = new HashMap<String, Integer>(accountList.size());
            for (DynamicObject account : accountList) {
                accountMap.put(account.getString("accountnumber"), account.getInt("scale"));
            }
            return accountMap;
        });
    }

    public static Integer getNewCurrencyScale(long modelId, String scenario, String currency, String accNum) {
        Map<String, Integer> accScaleMap = CurrencyScaleHandler.getAccountScale(modelId);
        return accScaleMap.getOrDefault(accNum, CurrencyScaleHandler.getCurrencyScale(scenario, currency, MemberReader.findModelNumberById((Object)modelId)));
    }

    private static Set<String> getAllTcfChildMember(String cubeNumber) {
        return (Set)GlobalCacheServiceHelper.getOrLoadNode((String)("getAllTcfChild" + cubeNumber), () -> {
            QFilter tcfFilter = new QFilter("longnumber", "like", (Object)"Process!TCF%");
            QFilter modelFilter = new QFilter("model.number", "=", (Object)cubeNumber);
            Map dimObj = BusinessDataServiceHelper.loadFromCache((String)"bcm_processmembertree", (String)"number", (QFilter[])new QFilter[]{tcfFilter, modelFilter});
            return new ArrayList(dimObj.values()).stream().map(dyna -> dyna.getString("number")).collect(Collectors.toSet());
        });
    }

    private static Map<String, DataTypeEnum> getDataTypeMap(Long modelId, List<String> dimNumbers) {
        HashMap<String, DataTypeEnum> dataTypeCache = new HashMap<String, DataTypeEnum>();
        for (String dimNum : dimNumbers) {
            Map dataTypeMap = MemberReader.getMemberDataType((long)modelId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (String)dimNum);
            dataTypeCache.putAll(dataTypeMap);
        }
        return dataTypeCache;
    }

    private static DataTypeEnum getDimCellDataType(Map<String, DataTypeEnum> dataTypeCache, Map<String, String> cellDim, List<String> dimList) {
        for (String dimNum : dimList) {
            DataTypeEnum dataTypeEnum = dataTypeCache.get(dimNum + "_" + cellDim.get(dimNum));
            if (dataTypeEnum == null) continue;
            if (DataTypeEnum.ENUMTP == dataTypeEnum) {
                return dataTypeCache.get(dimNum + "_" + cellDim.get(dimNum) + "_item");
            }
            return dataTypeEnum;
        }
        return DataTypeEnum.CURRENCY;
    }

    private static String getMemberNumberByKey(String dimKey, MembersKey key, SaveCommandInfo info) {
        Pair<Integer, String> pair = CurrencyScaleHandler.getMemberInfoPair(dimKey, info);
        int index = (Integer)pair.getFirst();
        String member = null;
        member = index == -1 ? (String)pair.getSecond() : key.getKey(index);
        return member;
    }

    private static String[] getCoordinates(MembersKey key) {
        int count = key.getCount();
        String[] coordinates = new String[count];
        for (int i = 0; i < count; ++i) {
            coordinates[i] = key.getKey(i);
        }
        return coordinates;
    }

    private static Pair<Integer, String> getMemberInfoPair(String dimension, SaveCommandInfo info) {
        List fixedDimensions = info.getFixedDimensions();
        List dimensions = info.getDimensions();
        for (Object dim : fixedDimensions) {
            if (!dim.getName().equals(dimension)) continue;
            return new Pair((Object)-1, (Object)dim.getValue());
        }
        for (int i = 0; i < dimensions.size(); ++i) {
            Object dim;
            dim = (String)dimensions.get(i);
            if (!((String)dim).equals(dimension)) continue;
            return new Pair((Object)i, (Object)"");
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff0c\u5904\u7406\u7cbe\u5ea6\u65f6\u672a\u83b7\u53d6\u5230\u76f8\u5173\u7ef4\u5ea6\u6210\u5458\uff1a%s\u3002", (String)"CurrencyScaleHandler_0", (String)"fi-bcm-business", (Object[])new Object[0]), dimension));
    }

    private static DataTypeEnum getDimCellDataTypeNoEnum(Map<String, DataTypeEnum> dataTypeCache, Map<String, String> cellDim, List<String> dimList) {
        for (String dimNum : dimList) {
            DataTypeEnum dataTypeEnum = dataTypeCache.get(dimNum + "_" + cellDim.get(dimNum));
            if (dataTypeEnum == null) continue;
            return dataTypeEnum;
        }
        return DataTypeEnum.CURRENCY;
    }
}

