/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.olap.shield;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class ShieldRuleBulider {
    private Object modelId;
    private String modelNumber;
    private Collection<DynamicObject> dimObjs;
    public static final String other = "other";
    public static final String all = "all";
    public static final String none = "none";
    public static final String NUMBER = "number";
    public static final String MEMBER = "member";
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ShieldRuleBulider.class);

    public ShieldRuleBulider(Object modelId) {
        this.modelId = modelId;
    }

    private String getModelNumber() {
        if (StringUtils.isEmpty((String)this.modelNumber)) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.modelId, (String)"bcm_model", (String)NUMBER);
            this.modelNumber = obj.getString(NUMBER);
        }
        return this.modelNumber;
    }

    private Collection<DynamicObject> getDimObjs() {
        if (this.dimObjs == null) {
            this.dimObjs = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"id,name,shortnumber,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.modelId))}).values();
        }
        return this.dimObjs;
    }

    public long getShieldRule(Object dimensionId, String dims) {
        if (StringUtils.isEmpty((String)dims)) {
            return 0L;
        }
        Object[] ds = dims.split(",");
        Arrays.sort(ds);
        ArrayList<Object> dimensions = new ArrayList<Object>();
        for (Object object : ds) {
            if (!StringUtils.isNotEmpty((String)object)) continue;
            dimensions.add(object);
        }
        if (dimensions.isEmpty()) {
            return 0L;
        }
        ArrayList<String> others = new ArrayList<String>();
        String thisDim = "";
        for (DynamicObject dynamicObject : this.getDimObjs()) {
            if (!dimensionId.toString().equals(dynamicObject.getString("id"))) {
                others.add(dynamicObject.getString("shortnumber"));
                continue;
            }
            thisDim = dynamicObject.getString("shortnumber");
        }
        if (dimensions.containsAll(others) && !dimensions.contains(thisDim)) {
            return this.getRule(other, other, other);
        }
        String dimStr = String.join((CharSequence)",", dimensions);
        String string = String.join((CharSequence)"", dimensions);
        return this.getRule(string, string, dimStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRule(String number, String name, String rule) {
        DynamicObject obj;
        block32: {
            obj = QueryServiceHelper.queryOne((String)"bcm_aggshieldrule", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.modelId)), new QFilter("rule", "=", (Object)rule)});
            if (obj == null) {
                try (DLock lock = DLock.create((String)("SRU" + rule + this.modelId));){
                    try {
                        if (!lock.tryLock(1000L)) break block32;
                        obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_aggshieldrule");
                        obj.set(NUMBER, (Object)number);
                        obj.set("name", (Object)name);
                        obj.set("model", this.modelId);
                        obj.set("rule", (Object)rule);
                        try (TXHandle tx = TX.required();){
                            try {
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                            }
                            catch (Throwable e) {
                                tx.markRollback();
                                throw new KDBizException(e.getMessage());
                            }
                        }
                        if (!other.equals(number)) {
                            this.addToOlap(number, rule);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        }
        if (obj != null) {
            return obj.getLong("id");
        }
        return 0L;
    }

    private List<String> changeShortNumToNum(String rule) {
        ArrayList<String> nums = new ArrayList<String>();
        List<String> shortnums = Arrays.asList(rule.split(","));
        for (DynamicObject dim : this.getDimObjs()) {
            String sn = dim.getString("shortnumber");
            if (!shortnums.contains(sn)) continue;
            nums.add(dim.getString(NUMBER));
        }
        return nums;
    }

    private void addToOlap(String number, String rule) {
        if (all.equals(number) || other.equals(number) || none.equals(number)) {
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((Object)this.modelId), (String)"bcm_model", (String)NUMBER);
        String cubeNum = obj.getString(NUMBER);
        List<String> dims = this.changeShortNumToNum(rule);
        if (!OlapServiceHelper.existAggShieldRule(cubeNum, number)) {
            OlapServiceHelper.createAggShieldRule(cubeNum, number, dims);
        }
    }

    public List<ComboItem> getComboItem(Object dimensionId) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"id,name,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)this.modelId))}, (String)"dseq").values().forEach(d -> {
            if (!dimensionId.toString().equals(d.getString("id"))) {
                items.add(new ComboItem(new LocaleString(d.getString("name")), d.getString("shortnumber")));
            }
        });
        return items;
    }

    public void saveDynOlapInfo(String includeYear, String excludeYear, long dimId, long membId, long ruleId, String mounthArray, Boolean hasExcePeriod) {
        DeleteServiceHelper.delete((String)"bcm_aggshieldruledis", (QFilter[])new QFilter[]{new QFilter(MEMBER, "=", (Object)membId)});
        String dimNum = "";
        for (DynamicObject dim : this.getDimObjs()) {
            if (dimId != dim.getLong("id")) continue;
            dimNum = dim.getString(NUMBER);
            break;
        }
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)membId, (String)MemberReader.getEntityNumberByDim((String)this.getModelNumber(), (String)dimNum), (String)NUMBER);
        String cubeNum = this.getModelNumber();
        if (ruleId == 0L) {
            OlapServiceHelper.setMemberAggShieldRule(cubeNum, dimNum, member.getString(NUMBER), all);
            return;
        }
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"bcm_aggshieldrule", (String)"number,rule");
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_aggshieldruledis");
        obj.set(MEMBER, (Object)membId);
        obj.set("rule", (Object)ruleId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        if (!OlapServiceHelper.existAggShieldRule(this.getModelNumber(), rule.getString(NUMBER))) {
            try {
                this.addToOlap(rule.getString(NUMBER), rule.getString("rule"));
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        Boolean hasShieldRule = OlapServiceHelper.existAggShieldRule(this.getModelNumber(), "ExcludeMonths");
        if (hasExcePeriod.booleanValue()) {
            OlapServiceHelper.excludeMonth(cubeNum, mounthArray, includeYear, dimNum, hasShieldRule);
        }
        if (excludeYear != null) {
            OlapServiceHelper.setMemberAggShieldRule(this.getModelNumber(), dimNum, member.getString(NUMBER), rule.getString(NUMBER));
        }
    }

    public void save(long dimId, long membId, long ruleId) {
        DeleteServiceHelper.delete((String)"bcm_aggshieldruledis", (QFilter[])new QFilter[]{new QFilter(MEMBER, "=", (Object)membId)});
        String dimNum = "";
        for (DynamicObject dim : this.getDimObjs()) {
            if (dimId != dim.getLong("id")) continue;
            dimNum = dim.getString(NUMBER);
            break;
        }
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)membId, (String)MemberReader.getEntityNumberByDim((String)this.getModelNumber(), (String)dimNum), (String)NUMBER);
        if (ruleId == 0L) {
            OlapServiceHelper.setMemberAggShieldRule(this.getModelNumber(), dimNum, member.getString(NUMBER), all);
            return;
        }
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"bcm_aggshieldrule", (String)"number,rule");
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_aggshieldruledis");
        obj.set(MEMBER, (Object)membId);
        obj.set("rule", (Object)ruleId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        if (!OlapServiceHelper.existAggShieldRule(this.getModelNumber(), rule.getString(NUMBER))) {
            try {
                this.addToOlap(rule.getString(NUMBER), rule.getString("rule"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OlapServiceHelper.setMemberAggShieldRule(this.getModelNumber(), dimNum, member.getString(NUMBER), rule.getString(NUMBER));
    }

    public void changeDynOlapInfo(String exceperiod, String includeYear) {
        String cubNum = this.getModelNumber();
        OlapServiceHelper.changeExcludeMonth(cubNum, exceperiod, includeYear);
    }

    public static String getRuleStrByMem(Object dimensionId, Object membId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_aggshieldruledis", (String)"rule.rule,rule.model.id", (QFilter[])new QFilter[]{new QFilter(MEMBER, "=", (Object)LongUtil.toLong((Object)membId))});
        return ShieldRuleBulider.getSortedRuleStrByMem(dimensionId, obj);
    }

    public static Map<Long, String> getRuleStrByMemList(long modelId, long dimensionId, Set<Long> memberIds) {
        HashMap<Long, String> allRuleStrByMems = new HashMap<Long, String>(16);
        DynamicObjectCollection ruleObjects = new DynamicObjectCollection();
        BatchProcessHelper.batchConsume((List)Lists.newArrayList(memberIds), (int)100000, batchIds -> {
            QFilter qfIds = new QFilter(MEMBER, "in", batchIds);
            ruleObjects.addAll((Collection)QueryServiceHelper.query((String)"bcm_aggshieldruledis", (String)"member, rule.rule", (QFilter[])qfIds.toArray()));
        });
        Map<Long, String> map = ShieldRuleBulider.getAllDimId2Number(modelId);
        for (DynamicObject value : ruleObjects) {
            String rule = ShieldRuleBulider.getSortedRuleStrByMem(dimensionId, value, map);
            if (rule == null || rule.length() == 0) continue;
            rule = rule.substring(0, rule.length() - 1);
            allRuleStrByMems.put(value.getLong(MEMBER), rule);
        }
        return allRuleStrByMems;
    }

    private static String getSortedRuleStrByMem(Object dimensionId, DynamicObject obj) {
        if (obj != null) {
            String rule = obj.getString("rule.rule");
            if (other.equals(rule)) {
                StringBuilder sb = new StringBuilder();
                BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"id,name,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)obj.get("rule.model.id")))}, (String)"dseq").values().forEach(d -> {
                    if (!dimensionId.toString().equals(d.getString("id"))) {
                        sb.append(d.getString("shortnumber"));
                        sb.append(',');
                    }
                });
                rule = sb.toString();
            } else {
                List<String> dims = Arrays.asList(rule.split(","));
                StringBuilder sb = new StringBuilder();
                BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"id,name,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)obj.get("rule.model.id")))}, (String)"dseq").values().forEach(d -> {
                    String sn = d.getString("shortnumber");
                    if (dims.contains(sn)) {
                        sb.append(sn);
                        sb.append(',');
                    }
                });
                rule = sb.toString();
            }
            return rule;
        }
        return null;
    }

    private static String getSortedRuleStrByMem(long dimensionId, DynamicObject obj, Map<Long, String> map) {
        if (obj != null) {
            String rule = obj.getString("rule.rule");
            if (other.equals(rule)) {
                StringBuilder sb = new StringBuilder();
                map.forEach((k, v) -> {
                    if (dimensionId != k) {
                        sb.append((String)v);
                        sb.append(",");
                    }
                });
                rule = sb.toString();
            } else {
                List<String> dims = Arrays.asList(rule.split(","));
                StringBuilder sb = new StringBuilder();
                map.forEach((k, v) -> {
                    if (dims.contains(v)) {
                        sb.append((String)v);
                        sb.append(",");
                    }
                });
                rule = sb.toString();
            }
            return rule;
        }
        return null;
    }

    private static Map<Long, String> getAllDimId2Number(long modelId) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        Map dimSNum2DimInfo = MemberReader.getDimeId2Dyn((Long)LongUtil.toLong((Object)modelId));
        dimSNum2DimInfo.forEach((k, v) -> result.put((Long)k, v.getString("shortnumber")));
        return result;
    }
}

