/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.olap.verify;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.olap.verify.VerifyResult;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class OlapDataVerifyServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, OlapDataVerifyServiceHelper.class);
    private static Set<String> VERIFY_DIM = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{PresetConstant.ENTITY_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM, PresetConstant.CURRENCY_DIM}));

    public static void handleCellSetAndCheck(SaveCommandInfo info, CellSet cs) {
        OlapDataVerifyServiceHelper.adjustAndCheckSaveCommandInfo(info);
        OlapDataVerifyServiceHelper.adjustAndCheckCellSet(info, cs);
    }

    public static VerifyResult verifyDataFlowControl(SaveCommandInfo info, CellSet cs, String cubecatalog) {
        VerifyResult vr = new VerifyResult();
        if (cs.getCount() <= 0) {
            return vr;
        }
        List<Map<String, String>> fixDims = OlapDataVerifyServiceHelper.fetchVerifyDimsFromFixDimInfo(info);
        List<Object> crossDims = new ArrayList(0);
        if (fixDims.size() != VERIFY_DIM.size()) {
            crossDims = OlapDataVerifyServiceHelper.fetchVerifyDimsFromCellSet(info, cs);
        }
        HashMultimap dimMembMap = HashMultimap.create();
        fixDims.forEach(f -> f.entrySet().forEach(e -> dimMembMap.put(e.getKey(), e.getValue())));
        crossDims.forEach(f -> f.entrySet().forEach(e -> dimMembMap.put(e.getKey(), e.getValue())));
        Collection entities = (Collection)dimMembMap.asMap().get(PresetConstant.ENTITY_DIM);
        HashMap entityNum2IDMap = new HashMap(entities.size());
        MemberReader.findMemberByConsumer((String)cubecatalog, (String)PresetConstant.ENTITY_DIM, m -> {
            boolean isEqualsBase = entities.contains(m.getNumber()) && !m.isShare();
            boolean isEqualsVir = entities.contains(m.getVirtualEntityForSearch());
            if (isEqualsBase || isEqualsVir) {
                entityNum2IDMap.put(isEqualsBase ? m.getNumber() : m.getVirtualEntityForSearch(), m);
            }
        });
        if (entityNum2IDMap.isEmpty()) {
            return vr;
        }
        ArrayList carst = fixDims.isEmpty() || crossDims.isEmpty() ? Lists.newArrayList((Object[])new List[]{fixDims, crossDims}) : Lists.cartesianProduct((List[])new List[]{fixDims, crossDims});
        long entityId = 0L;
        long scenarioId = 0L;
        long yearId = 0L;
        long periodId = 0L;
        String entityNum = null;
        String storageCurrencyNum = null;
        String scenarioNum = null;
        String fyNum = null;
        String periodNum = null;
        ArrayList<Object> invalidateCrossMap = new ArrayList<Object>(4);
        for (List cross : carst) {
            if (cross.isEmpty()) continue;
            for (Map one : cross) {
                for (Map.Entry e : one.entrySet()) {
                    if (((String)e.getKey()).equals(PresetConstant.ENTITY_DIM)) {
                        entityId = OlapDataVerifyServiceHelper.findMemberIdByNumber(cubecatalog, PresetConstant.ENTITY_DIM, (String)e.getValue());
                        entityNum = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).equals(PresetConstant.SCENE_DIM)) {
                        scenarioId = OlapDataVerifyServiceHelper.findMemberIdByNumber(cubecatalog, PresetConstant.SCENE_DIM, (String)e.getValue());
                        scenarioNum = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).equals(PresetConstant.FY_DIM)) {
                        yearId = OlapDataVerifyServiceHelper.findMemberIdByNumber(cubecatalog, PresetConstant.FY_DIM, (String)e.getValue());
                        fyNum = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).equals(PresetConstant.PERIOD_DIM)) {
                        periodId = OlapDataVerifyServiceHelper.findMemberIdByNumber(cubecatalog, PresetConstant.PERIOD_DIM, (String)e.getValue());
                        periodNum = (String)e.getValue();
                        continue;
                    }
                    if (!((String)e.getKey()).equals(PresetConstant.CURRENCY_DIM)) continue;
                    storageCurrencyNum = (String)e.getValue();
                }
            }
            if (OlapDataVerifyServiceHelper.verifyCanExecute(cubecatalog, entityId, scenarioId, yearId, periodId, storageCurrencyNum)) continue;
            vr.addVerifyMsgWithLineBreak(String.format(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u6d41\u7a0b\u5df2\u63d0\u4ea4\u6216\u5f52\u6863\uff0c\u6216\u671f\u95f4\u672a\u5f00\u542f\uff0c\u76f8\u5173\u6570\u636e\u4e0d\u80fd\u4fdd\u5b58\u3002\uff08\u7ec4\u7ec7\uff1a%1$s\uff0c\u5e74\uff1a%2$s\uff0c\u671f\u95f4\uff1a%3$s\uff0c\u60c5\u666f\uff1a%4$s\uff09\u3002", (String)"OlapDataVerifyServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), entityNum, fyNum, periodNum, scenarioNum));
            HashMap map = new HashMap(5);
            map.put(PresetConstant.ENTITY_DIM, entityNum);
            map.put(PresetConstant.SCENE_DIM, scenarioNum);
            map.put(PresetConstant.FY_DIM, fyNum);
            map.put(PresetConstant.PERIOD_DIM, periodNum);
            map.put(PresetConstant.CURRENCY_DIM, storageCurrencyNum);
            invalidateCrossMap.add(map);
        }
        if (!invalidateCrossMap.isEmpty() && !cs.isFromQuery()) {
            for (FixedDimension d : info.getFixedDimensions()) {
                invalidateCrossMap.forEach(m -> m.remove(d.getName()));
            }
            if (((Map)invalidateCrossMap.get(0)).size() <= 0) {
                Iterator it = cs.getMutableMetricEntries(FacTabFieldDefEnum.FIELD_MONEY.getField());
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
                return vr;
            }
            LinkedHashMap<String, Integer> sortMap = new LinkedHashMap<String, Integer>(5);
            int index = 0;
            for (String dim : info.getDimensions()) {
                if (VERIFY_DIM.contains(dim)) {
                    sortMap.put(dim, index);
                }
                ++index;
            }
            HashSet compareKeys = new HashSet(2);
            ArrayList keyLine = new ArrayList(5);
            invalidateCrossMap.forEach(c -> {
                keyLine.clear();
                sortMap.entrySet().forEach(s -> keyLine.add(c.get(s.getKey())));
                compareKeys.add(Joiner.on((char)'|').join((Iterable)keyLine));
            });
            Object[] csKeys = new String[sortMap.size()];
            Integer[] dimSort = sortMap.values().toArray(new Integer[0]);
            Iterator it = cs.getMutableMetricEntries(FacTabFieldDefEnum.FIELD_MONEY.getField());
            while (it.hasNext()) {
                kotlin.Pair vp = (kotlin.Pair)it.next();
                for (int idx = 0; idx < dimSort.length; ++idx) {
                    csKeys[idx] = ((MembersKey)vp.getFirst()).getKey(dimSort[idx].intValue());
                }
                if (!compareKeys.contains(Joiner.on((char)'|').join(csKeys))) continue;
                it.remove();
            }
        }
        if (!vr.isEmpty() && cs.isFromQuery()) {
            throw new KDBizException(((Object)invalidateCrossMap).toString());
        }
        if (!vr.isEmpty()) {
            log.error("don't save olap-data because:" + vr.toString());
        }
        return vr;
    }

    public static boolean verifyCanExecute(String modelNum, long entityId, long scenarioId, long fyId, long periodId, String execCurrency) {
        return (Boolean)ThreadCache.get((Object)Joiner.on((char)'|').join((Object)modelNum, (Object)entityId, new Object[]{scenarioId, fyId, periodId, execCurrency}), () -> {
            IDNumberTreeNode baseTreeNode = MemberReader.findEntityMemberById((String)modelNum, (Long)entityId).getBaseTreeNode();
            McStatus mc = McStatus.getMcStatusByCurrencyNumber(MemberReader.findModelIdByNum((String)modelNum), baseTreeNode.getId(), scenarioId, fyId, periodId, execCurrency);
            String ec = baseTreeNode.getCurrency();
            if (ec == null) {
                return true;
            }
            return (!mc.getArchive().isArchive() && !mc.getFlow().isSubmit() || !ec.equals(execCurrency)) && (!mc.getPcFlow().isSubmit() || ec.equals(execCurrency)) && OlapDataVerifyServiceHelper.checkPeriodOpenStatus(baseTreeNode.getModelId(), modelNum, baseTreeNode.getNumber(), scenarioId, fyId, periodId);
        });
    }

    @SDKMark
    public static boolean checkPeriodOpenStatus(long modelId, String modelNum, String orgNum, long scenarioId, long fyId, long periodId) {
        if (ConfigServiceHelper.getBoolParam(modelNum, "CM012")) {
            return PeriodSettingHelper.checkPeriodStatus(modelId, orgNum, scenarioId, fyId, periodId, "datastatus");
        }
        return true;
    }

    private static long findMemberIdByNumber(String modelNumber, String dim, String member) {
        return (Long)ThreadCache.get((Object)(modelNumber + "|" + dim + "|" + member), () -> {
            IDNumberTreeNode node = null;
            String tempMemb = member;
            if (PresetConstant.ENTITY_DIM.equals(dim)) {
                tempMemb = OlapDataVerifyServiceHelper.isVirtualEntity(tempMemb) ? tempMemb.split("_")[0] : tempMemb;
            }
            node = MemberReader.findMemberByNumber((String)modelNumber, (String)dim, (String)tempMemb);
            return node.getId();
        });
    }

    public static boolean isVirtualEntity(String entityNum) {
        return entityNum != null && entityNum.contains("_");
    }

    private static List<Map<String, String>> fetchVerifyDimsFromFixDimInfo(SaveCommandInfo info) {
        ArrayList<Map<String, String>> dimMembMap = new ArrayList<Map<String, String>>(4);
        HashMap item = new HashMap(5);
        info.getFixedDimensions().forEach(f -> {
            if (VERIFY_DIM.contains(f.getName())) {
                item.put(f.getName(), f.getValue());
            }
        });
        if (!item.isEmpty()) {
            dimMembMap.add(item);
        }
        return dimMembMap;
    }

    private static List<Map<String, String>> fetchVerifyDimsFromCellSet(SaveCommandInfo info, CellSet cs) {
        HashMap csDims = new HashMap(8);
        int index = 0;
        HashMap<String, Integer> dimMap = new HashMap<String, Integer>(4);
        for (String dim : info.getDimensions()) {
            if (VERIFY_DIM.contains(dim)) {
                dimMap.put(dim, index);
            }
            ++index;
        }
        if (dimMap.size() == 0) {
            return new ArrayList<Map<String, String>>(0);
        }
        Set entries = dimMap.entrySet();
        String[] membKeys = new String[entries.size()];
        HashMap mapItem = new HashMap(16);
        cs.getMutableMetricEntries(FacTabFieldDefEnum.FIELD_MONEY.getField()).forEachRemaining(vp -> {
            int idx = 0;
            mapItem.clear();
            for (Map.Entry entry : entries) {
                membKeys[idx++] = ((MembersKey)vp.getFirst()).getKey(((Integer)entry.getValue()).intValue());
                mapItem.put(entry.getKey(), ((MembersKey)vp.getFirst()).getKey(((Integer)entry.getValue()).intValue()));
            }
            String key = Joiner.on((String)"|").join((Object[])membKeys);
            if (!csDims.containsKey(key)) {
                csDims.put(key, new HashMap(mapItem));
            }
        });
        return new ArrayList<Map<String, String>>(csDims.values());
    }

    private static void adjustAndCheckCellSet(SaveCommandInfo info, CellSet cs) {
        int bp_index = -1;
        int c_index = -1;
        int index = 0;
        for (String dim : info.getDimensions()) {
            if (PresetConstant.CURRENCY_DIM.equals(dim)) {
                c_index = index;
            } else if (PresetConstant.PROCESS_DIM.equals(dim)) {
                bp_index = index;
            }
            ++index;
        }
        if (bp_index == -1 && c_index == -1) {
            return;
        }
        int bpIndex = bp_index;
        int cIndex = c_index;
        ArrayList removeItems = new ArrayList(2);
        ArrayList addItems = new ArrayList(2);
        cs.getMutableMetricEntries(FacTabFieldDefEnum.FIELD_MONEY.getField()).forEachRemaining(vp -> {
            if (bpIndex != -1 && SysMembConstant.ProcessMap.containsKey(((MembersKey)vp.getFirst()).get(bpIndex))) {
                String[] keys = new String[((MembersKey)vp.getFirst()).getCount()];
                int s = ((MembersKey)vp.getFirst()).getCount();
                for (int i = 0; i < s; ++i) {
                    keys[i] = ((MembersKey)vp.getFirst()).getKey(i);
                }
                keys[bpIndex] = (String)SysMembConstant.ProcessMap.get(((MembersKey)vp.getFirst()).get(bpIndex));
                addItems.add(Pair.onePair((Object)keys, (Object)vp.getSecond()));
                removeItems.add(vp.getFirst());
            }
            if (cIndex != -1) {
                OlapDataVerifyServiceHelper.checkCurrencyMember(((MembersKey)vp.getFirst()).get(cIndex).toString());
            }
        });
        removeItems.forEach(r -> cs.set(r, null));
        addItems.forEach(add -> cs.set((Object[])add.p1, add.p2));
    }

    private static void checkCurrencyMember(String member) {
        if (SysMembConstant.CurrencyVariable.contains(member)) {
            RuntimeException e = new RuntimeException(String.format("Currency dimension is not supported member %s storage.", member));
            log.error((Throwable)e);
            throw e;
        }
    }

    private static void adjustAndCheckSaveCommandInfo(SaveCommandInfo info) {
        int idx = 0;
        PairList plist = new PairList();
        for (FixedDimension d : info.getFixedDimensions()) {
            if (PresetConstant.PROCESS_DIM.equals(d.getName())) {
                if (SysMembConstant.ProcessMap.containsKey(d.getValue())) {
                    plist.addPair((Object)idx, (Object)new FixedDimension(PresetConstant.PROCESS_DIM, (String)SysMembConstant.ProcessMap.get(d.getValue())));
                }
            } else if (PresetConstant.CURRENCY_DIM.equals(d.getName())) {
                OlapDataVerifyServiceHelper.checkCurrencyMember(d.getValue());
            }
            ++idx;
        }
        plist.forEach(p -> info.getFixedDimensions().set((Integer)p.p1, p.p2));
    }
}

