/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.page.model;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.fi.bcm.business.page.model.Element;

public class ButtonElement
extends Element {
    private static final long serialVersionUID = 1L;
    private String id;
    private String operationKey;

    public ButtonElement(String sign, String name) {
        this.setSign(sign);
        this.setName(name);
    }

    public ButtonElement(String sign, String name, String id) {
        this.setSign(sign);
        this.setName(name);
        this.setId(id);
    }

    public ButtonElement(String sign, String name, LocaleString height) {
        this.setSign(sign);
        this.setName(name);
        this.setHeight(height);
    }

    public final void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Control getControl(IFormView view) {
        Button button = new Button();
        button.setModel(view.getModel());
        button.setView(view);
        button.setKey(this.getSign());
        button.setDraggable(this.isDragable());
        button.setOperationKey(this.getOperationKey());
        return button;
    }

    @Override
    public void addToFront() {
        ButtonAp buttonAp = new ButtonAp();
        buttonAp.setName(new LocaleString(this.getName()));
        buttonAp.setKey(this.getSign());
        buttonAp.setAutoTextWrap(true);
        this.setDefaultStyle((ControlAp)buttonAp);
        this.getArea().getContainerap().getItems().add(buttonAp);
    }

    @Override
    public void bindCtrlMapping(IFormView view) {
        MainEntityType mainEntityType = view.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        if (!props.containsKey((Object)this.getSign())) {
            this.addLabelToMainEntity((Container)view.getControl(this.getArea().getSign()), mainEntityType, this.entityMeta, this.getSign(), view.getModel(), view);
        }
    }

    private void addLabelToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey, IDataModel model, IFormView view) {
        TextProp fieldprop = new TextProp();
        fieldprop.setName(fieldKey);
        targetEntity.addProperty((DynamicProperty)fieldprop);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldprop);
        }
        ButtonAp field = new ButtonAp();
        field.setName(new LocaleString(fieldKey));
        field.setKey(fieldKey);
        Control control = field.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public String getOperationKey() {
        return this.operationKey;
    }

    public void setOperationKey(String operationKey) {
        this.operationKey = operationKey;
    }
}

