/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateCatalog;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateStatusEnum;
import kd.fi.bcm.common.util.ISupportGZip;
import kd.fi.bcm.common.util.ThrowableHelper;

public class CommonPaperTemplateModel
extends DynaEntityObject
implements ISupportGZip {
    private static final long serialVersionUID = 1L;
    private boolean isModify = true;

    public CommonPaperTemplateModel() {
        this.setDataEntityNumber("bcm_papertemplate");
    }

    public Object getMultilingualName() {
        return this.get("name");
    }

    @Override
    public String getName() {
        Object value = this.get("name");
        if (value instanceof OrmLocaleValue) {
            OrmLocaleValue localValue = (OrmLocaleValue)value;
            return localValue.getLocaleValue();
        }
        return value == null ? null : value.toString();
    }

    public void setName(Object name) {
        this.put("name", name);
    }

    public void setModelId(long modelId) {
        this.put("model", (Object)modelId);
    }

    public long getModelId() {
        return this.get("model") == null ? 0L : (Long)this.get("model");
    }

    public PaperTemplateCatalog getTemplateCatalog() {
        return (PaperTemplateCatalog)this.get("templatecatalog");
    }

    public void setTemplateCatalog(PaperTemplateCatalog catalog) {
        this.put("templatecatalog", (Object)catalog);
    }

    public void setVersionNumber(BigDecimal versionNumber) {
        this.put("versionnumber", (Object)versionNumber);
    }

    public BigDecimal getVersionNumber() {
        return (BigDecimal)this.get("versionnumber");
    }

    public void setGroup(long group) {
        this.put("group", (Object)group);
    }

    public long getGroup() {
        if (this.get("group") == null) {
            this.setGroup(DBServiceHelper.genGlobalLongId());
        }
        return (Long)this.get("group");
    }

    public void setVersionDescription(String versionDescription) {
        this.put("versiondescription", (Object)versionDescription);
    }

    public String getVersionDescription() {
        return (String)this.get("versiondescription");
    }

    public PaperTemplateStatusEnum getStatus() {
        return PaperTemplateStatusEnum.getStatus((String)((String)this.get("status")));
    }

    public void setStatus(String statusValue) {
        this.put("status", (Object)statusValue);
    }

    public Date getEffectiveDate() {
        return (Date)this.get("effectivedate");
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.put("effectivedate", (Object)effectiveDate);
    }

    public Date getExpiringDate() {
        return (Date)this.get("expiringdate");
    }

    public void setExpiringDate(Date expiringDate) {
        this.put("expiringdate", (Object)expiringDate);
    }

    public long getCreatorId() {
        return (Long)this.get("creator");
    }

    public void setCreatorId(long creatorId) {
        this.put("creator", (Object)creatorId);
    }

    public Date getCreateTime() {
        return (Date)this.get("createtime");
    }

    public void setCreateTime(Date createTime) {
        this.put("createtime", (Object)createTime);
    }

    public long getModifierId() {
        return (Long)this.get("modifier");
    }

    public void setModifierId(long modifierId) {
        this.put("modifier", (Object)modifierId);
    }

    public Date getModifyTime() {
        return (Date)this.get("modifyTime");
    }

    public void setModifyTime(Date modifyTime) {
        this.put("modifyTime", (Object)modifyTime);
    }

    public Integer getSequence() {
        return (Integer)this.get("sequence");
    }

    public void setSequence(int sequence) {
        this.put("sequence", (Object)sequence);
    }

    public void setScenario(Long scenarioId) {
        this.put("scenario", (Object)scenarioId);
    }

    public Long getScenario() {
        return (Long)this.get("scenario");
    }

    public void setTemplateType(String templateType) {
        this.put("templatetype", (Object)templateType);
    }

    public String getTemplateType() {
        return (String)this.get("templatetype");
    }

    public void setDescription(String description) {
        this.put("description", (Object)description);
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public void setSpreadJson(String spreadJson) {
        this.put("spreadjson", (Object)spreadJson);
    }

    public String getSpreadJson() {
        return (String)this.get("spreadjson");
    }

    public void setData(String data) {
        this.put("data", (Object)data);
    }

    public String getData() {
        return (String)this.get("data");
    }

    public void setSeller(Long seller) {
        this.put("seller", (Object)seller);
    }

    public Long getSeller() {
        return (Long)this.get("seller");
    }

    public void setPurchaser(Long purchaser) {
        this.put("purchaser", (Object)purchaser);
    }

    public Long getPurchaser() {
        return (Long)this.get("purchaser");
    }

    public void setMergeNode(Long mergenode) {
        this.put("mergenode", (Object)mergenode);
    }

    public Long getMergeNode() {
        return (Long)this.get("mergenode");
    }

    public void setEffectivescope(String effectivescope) {
        this.put("effectivescope", (Object)effectivescope);
    }

    public String getEffectivescope() {
        return (String)this.get("effectivescope");
    }

    public void setAreaPoint(String areaPoint) {
        this.put("areapoint", (Object)areaPoint);
    }

    public String getAreaPoint() {
        return (String)this.get("areapoint");
    }

    public void setMfFormula(String mfFormula) {
        this.put("mfformula", (Object)mfFormula);
    }

    public String getMfFormula() {
        return (String)this.get("mfformula");
    }

    public String getUsage() {
        return (String)this.get("usage");
    }

    public void setUsage(String usage) {
        this.put("usage", (Object)usage);
    }

    public static CommonPaperTemplateModel genImmutableModel(DynamicObject dyna) {
        CommonPaperTemplateModel template = new CommonPaperTemplateModel();
        template.loadDynaObj2Model(dyna);
        template.isModify = false;
        return template;
    }

    public void loadDynaObj2Model(DynamicObject dyna) {
        try {
            this.transferDynaObj2Model(dyna);
        }
        catch (Throwable t) {
            throw new KDBizException(String.format("load [%s] template to model error!\n %s", dyna.getString("number"), ThrowableHelper.toString((Throwable)t)));
        }
    }

    private void transferDynaObj2Model(DynamicObject dyna) {
        Predicate<String> pexist = prop -> dyna.getDataEntityType().getProperties().containsKey(prop) && dyna.get(prop) != null;
        this.setId(dyna.getLong("id"));
        this.setName(dyna.get("name"));
        this.setScenario(this.defaultIfNotExist(pexist, "scenario", 0L, () -> dyna.getDynamicObject("scenario").getLong("id")));
        this.setNumber(dyna.getString("number"));
        this.setModelId(this.defaultIfNotExist(pexist, "model", 0L, () -> dyna.getDynamicObject("model").getLong("id")));
        this.setUsage(dyna.getString("usage"));
        this.setSeller(this.defaultIfNotExist(pexist, "seller", 0L, () -> dyna.getDynamicObject("seller").getLong("id")));
        this.setPurchaser(this.defaultIfNotExist(pexist, "purchaser", 0L, () -> dyna.getDynamicObject("purchaser").getLong("id")));
        this.setMergeNode(this.defaultIfNotExist(pexist, "mergenode", 0L, () -> dyna.getDynamicObject("mergenode").getLong("id")));
        this.setAreaPoint(dyna.getString("areapoint"));
        this.setData(this.defaultIfNotExist(pexist, "data", null, () -> dyna.getString("data")));
        this.setSpreadJson(this.defaultIfNotExist(pexist, "spreadjson", null, () -> dyna.getString("spreadjson")));
        this.setGroup(this.defaultIfNotExist(pexist, "group", 0L, () -> dyna.getLong("group")));
        this.setSequence(dyna.getInt("sequence"));
        this.setCreateTime(this.defaultIfNotExist(pexist, "createtime", null, () -> dyna.getDate("createtime")));
        this.setCreatorId(this.defaultIfNotExist(pexist, "creator", 0L, () -> dyna.getDynamicObject("creator").getLong("id")));
        this.setModifierId(this.defaultIfNotExist(pexist, "modifier", 0L, () -> dyna.getDynamicObject("modifier").getLong("id")));
        this.setModifyTime(this.defaultIfNotExist(pexist, "modifytime", null, () -> dyna.getDate("modifytime")));
        this.setVersionNumber(this.defaultIfNotExist(pexist, "versionnumber", new BigDecimal("1.0"), () -> dyna.getBigDecimal("versionnumber")));
        this.setVersionDescription(this.defaultIfNotExist(pexist, "versiondescription", null, () -> dyna.getString("versiondescription")));
        this.setStatus(this.defaultIfNotExist(pexist, "status", "1", () -> dyna.getString("status")));
        this.setEffectiveDate(this.defaultIfNotExist(pexist, "effectivedate", null, () -> dyna.getDate("effectivedate")));
        this.setEffectivescope(this.defaultIfNotExist(pexist, "effectivescope", "", () -> dyna.getString("effectivescope")));
        this.setExpiringDate(this.defaultIfNotExist(pexist, "expiringdate", null, () -> dyna.getDate("expiringdate")));
        this.setDescription(this.defaultIfNotExist(pexist, "description", "", () -> dyna.getString("description")));
        this.setTemplateCatalog(this.defaultIfNotExist(pexist, "templatecatalog", null, () -> {
            PaperTemplateCatalog catalog = new PaperTemplateCatalog();
            DynamicObject v = dyna.getDynamicObject("templatecatalog");
            catalog.setId(v.getLong("id"));
            catalog.setName(v.getString("name"));
            return catalog;
        }));
        DynamicObject classEntity = PermClassEntityHelper.getPermissionClassEntity(dyna);
        if (classEntity != null) {
            this.setPermClass(classEntity.getLong("permclass.id"));
        }
        this.setMfFormula(this.defaultIfNotExist(pexist, "mfformula", "", () -> dyna.getString("mfformula")));
    }

    private <R> R defaultIfNotExist(Predicate<String> p, String prop, R defaultValue, Supplier<R> supplier) {
        if (!p.test(prop)) {
            return defaultValue;
        }
        return supplier.get();
    }
}

