/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.basedata.MultiF7Results;
import kd.fi.bcm.business.dimension.enumvalue.EnumItemServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.innertrade.model.IntrField;
import kd.fi.bcm.common.IntrConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class ExtDimHelper {
    public static List<IntrField> getTmpFieldInludeBuySelll(Long extModelId) {
        return ExtDimHelper.getTmpFields4Tmpl(extModelId, true);
    }

    public static List<IntrField> getTmpFieldByExtModelId(Long extModelId) {
        return ExtDimHelper.getTmpFields4Tmpl(extModelId, false);
    }

    public static List<IntrField> getTmpFields4Tmpl(Long extModelId, boolean isIncludeBuySellField) {
        List<IntrField> tmpFields = ExtDimHelper.getTmpFields(extModelId);
        if (isIncludeBuySellField) {
            ArrayList<IntrField> reulst = new ArrayList<IntrField>(16);
            reulst.add(IntrField.getSellField());
            reulst.add(IntrField.getBuyField());
            reulst.addAll(tmpFields);
            return reulst;
        }
        return tmpFields;
    }

    public static List<IntrField> getTmpFields(Long extModelId) {
        QFBuilder extBuilder = new QFBuilder();
        extBuilder.add("extmodelid", "=", (Object)extModelId);
        QFBuilder dimBuilder = new QFBuilder();
        dimBuilder.add("extmodelid", "=", (Object)extModelId);
        return ExtDimHelper.getTmpFields(extBuilder.toArray(), dimBuilder.toArray());
    }

    public static List<IntrField> getTmpFields(QFilter[] extFieldQFilter, QFilter[] dimFieldQFilter) {
        ArrayList<IntrField> result = new ArrayList<IntrField>(16);
        DynamicObjectCollection extmodelfield = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield.model,extfield.id,extfield.number,extfield.name,extfield.datatype,sequence,isnecessary,uniquecheck", (QFilter[])extFieldQFilter, (String)"sequence,extfield.number");
        if (extmodelfield != null) {
            long modelId = ((DynamicObject)extmodelfield.get(0)).getLong("extfield.model");
            Map<Long, MultiF7Results> linkDimMap = ExtDataUtil.getMultiF7ValueByExtMemIds(extmodelfield.stream().map(e -> e.getLong("extfield.id")).collect(Collectors.toList()), modelId);
            for (DynamicObject extField : extmodelfield) {
                IntrField field = new IntrField(extField.getLong("extfield.id"), extField.getLong("id"), "ext", extField.getString("extfield.number"), extField.getString("extfield.name"), extField.getString("extfield.datatype"), extField.getInt("sequence"));
                MultiF7Results link = linkDimMap.get(field.getId());
                if (link != null) {
                    field.setShowType("F7");
                    field.setLinkDim(true);
                    DynamicObject dimDy = link.getDimDy();
                    field.setDimInfo((Tuple<Long, String, String>)Tuple.create((Object)dimDy.getLong("id"), (Object)dimDy.getString("number"), (Object)dimDy.getString("membermodel")));
                }
                result.add(field);
            }
        }
        result.addAll(ExtDimHelper.getDimFieldsQFilter(dimFieldQFilter));
        result.sort(Comparator.comparing(IntrField::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
        return result;
    }

    public static List<IntrField> getDimFields(Long extModelId) {
        QFBuilder dimBuilder = new QFBuilder();
        dimBuilder.add("extmodelid", "=", (Object)extModelId);
        return ExtDimHelper.getDimFieldsQFilter(dimBuilder.toArray());
    }

    public static List<IntrField> getDimFieldByRefIds(Set<Long> refIds) {
        QFBuilder dimBuilder = new QFBuilder();
        dimBuilder.add("id", "in", refIds);
        return ExtDimHelper.getDimFieldsQFilter(dimBuilder.toArray());
    }

    private static List<IntrField> getDimFieldsQFilter(QFilter[] dimFieldQFilter) {
        ArrayList<IntrField> result = new ArrayList<IntrField>(16);
        DynamicObjectCollection extmodeldim = QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension.id,dimension.number,dimension.name,sequence,isnecessary,uniquecheck", (QFilter[])dimFieldQFilter, (String)"sequence");
        if (extmodeldim != null) {
            for (DynamicObject dimField : extmodeldim) {
                String dimNum = dimField.getString("dimension.number");
                if (DimTypesEnum.INTERCOMPANY.getNumber().equals(dimNum) || DimTypesEnum.MYCOMPANY.getNumber().equals(dimNum)) continue;
                result.add(new IntrField(dimField.getLong("dimension.id"), dimField.getLong("id"), "dim", dimNum, dimField.getString("dimension.name"), DataTypeEnum.TXT.getOIndex(), dimField.getInt("sequence")));
            }
        }
        return result;
    }

    public static IntrField getTmpFieldByRefId(Long fieldRefId) {
        DynamicObject extField = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield.model,extfield.id,extfield.number,extfield.name,extfield.datatype,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter("id", "=", (Object)fieldRefId).toArray());
        if (extField != null) {
            MultiF7Results linkDim = ExtDataUtil.getMultiF7ValueByExtMem(extField.getString("extfield.number"), extField.getLong("extfield.model"));
            IntrField field = new IntrField(extField.getLong("extfield.id"), extField.getLong("id"), "ext", extField.getString("extfield.number"), extField.getString("extfield.name"), extField.getString("extfield.datatype"), extField.getInt("sequence"));
            if (linkDim != null && linkDim.getDimDy() != null) {
                field.setShowType("F7");
                field.setLinkDim(true);
                DynamicObject dimDy = linkDim.getDimDy();
                field.setDimInfo((Tuple<Long, String, String>)Tuple.create((Object)dimDy.getLong("id"), (Object)dimDy.getString("number"), (Object)dimDy.getString("membermodel")));
            }
            return field;
        }
        DynamicObject dimField = QueryServiceHelper.queryOne((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension.id,dimension.number,dimension.name,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter("id", "=", (Object)fieldRefId).toArray());
        if (dimField != null) {
            return new IntrField(dimField.getLong("dimension.id"), dimField.getLong("id"), "dim", dimField.getString("dimension.number"), dimField.getString("dimension.name"), DataTypeEnum.TXT.getOIndex(), dimField.getInt("sequence"));
        }
        return null;
    }

    public static IntrField getTmpFieldById(Long fieldId) {
        DynamicObject extField = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)fieldId).toArray());
        if (extField != null) {
            return new IntrField(extField.getLong("id"), null, "ext", extField.getString("number"), extField.getString("name"), null);
        }
        DynamicObject dimField = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)fieldId).toArray());
        if (dimField != null) {
            return new IntrField(dimField.getLong("id"), null, "dim", dimField.getString("number"), dimField.getString("name"), null);
        }
        return null;
    }

    public static IntrField getTmpFieldInfoById(Long extModelId, Long fieldId) {
        if (IntrConstant.BUY_FIELD_ID.equals(fieldId)) {
            return IntrField.getBuyField();
        }
        if (IntrConstant.SELL_FIELD_ID.equals(fieldId)) {
            return IntrField.getSellField();
        }
        QFBuilder extBuilder = new QFBuilder();
        extBuilder.add("extmodelid", "=", (Object)extModelId);
        extBuilder.add("extfield.id", "=", (Object)fieldId);
        DynamicObject extField = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"id,extfield.id,extfield.number,extfield.name,sequence,isnecessary,uniquecheck", (QFilter[])extBuilder.toArray());
        if (extField != null) {
            return new IntrField(extField.getLong("extfield.id"), extField.getLong("id"), "ext", extField.getString("extfield.number"), extField.getString("extfield.name"), extField.getInt("sequence"));
        }
        QFBuilder dimBuilder = new QFBuilder();
        dimBuilder.add("extmodelid", "=", (Object)extModelId);
        dimBuilder.add("dimension.id", "=", (Object)fieldId);
        DynamicObject dimField = QueryServiceHelper.queryOne((String)"bcm_extmodeldim", (String)"id,dimension.id,dimension.number,dimension.name,sequence,isnecessary,uniquecheck", (QFilter[])dimBuilder.toArray());
        if (dimField != null) {
            return new IntrField(dimField.getLong("dimension.id"), dimField.getLong("id"), "dim", dimField.getString("dimension.number"), dimField.getString("dimension.name"), dimField.getInt("sequence"));
        }
        return null;
    }

    public static IntrField getTmpFieldByNum(Long extModelId, String number) {
        QFilter modelQf = new QFilter("extmodelid", "=", (Object)extModelId);
        DynamicObject extField = QueryServiceHelper.queryOne((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield.id,extfield.number,extfield.name,extfield.datatype,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{modelQf, new QFilter("extfield.number", "=", (Object)number)});
        if (extField != null) {
            return new IntrField(extField.getLong("extfield.id"), extField.getLong("id"), "ext", extField.getString("extfield.number"), extField.getString("extfield.name"), extField.getString("extfield.datatype"), extField.getInt("sequence"));
        }
        DynamicObject dimField = QueryServiceHelper.queryOne((String)"bcm_extmodeldim", (String)"id,extmodelid,dimension.id,dimension.number,dimension.name,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter[]{modelQf, new QFilter("dimension.number", "=", (Object)number)});
        if (dimField != null) {
            return new IntrField(dimField.getLong("dimension.id"), dimField.getLong("id"), "dim", dimField.getString("dimension.number"), dimField.getString("dimension.name"), DataTypeEnum.TXT.getOIndex(), dimField.getInt("sequence"));
        }
        return null;
    }

    public static DynamicObjectCollection getEnumValuesByExtendFieldId(Long extendFieldId) {
        DynamicObjectCollection enumItems = new DynamicObjectCollection();
        String selectFields = "id,number,name,fieldmapped,datatype,exchange,enumitem.id";
        DynamicObject extField = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)extendFieldId)});
        if (extField != null && extField.getLong("enumitem.id") != 0L) {
            enumItems = EnumItemServiceHelper.queryEnumValue(Sets.newHashSet((Object[])new Long[]{extField.getLong("enumitem.id")}));
        }
        return enumItems;
    }

    public static List<IntrField> getExtendFieldsByRefIds(long modelId, Set<Long> extModelFieldIds) {
        ArrayList<IntrField> result = new ArrayList<IntrField>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_extmodelfield", (String)"id,extmodelid,extfield.id,extfield.number,extfield.name,extfield.datatype,sequence,isnecessary,uniquecheck", (QFilter[])new QFilter("id", "in", extModelFieldIds).toArray());
        if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
            Map<Long, MultiF7Results> linkDimMap = ExtDataUtil.getMultiF7ValueByExtMemIds(dynamicObjects.stream().map(e -> e.getLong("extfield.id")).collect(Collectors.toList()), modelId);
            for (DynamicObject extField : dynamicObjects) {
                IntrField field = new IntrField(extField.getLong("extfield.id"), extField.getLong("id"), "ext", extField.getString("extfield.number"), extField.getString("extfield.name"), extField.getString("extfield.datatype"), extField.getInt("sequence"));
                MultiF7Results link = linkDimMap.get(field.getId());
                if (link != null) {
                    field.setShowType("F7");
                    field.setLinkDim(true);
                    DynamicObject dimDy = link.getDimDy();
                    field.setDimInfo((Tuple<Long, String, String>)Tuple.create((Object)dimDy.getLong("id"), (Object)dimDy.getString("number"), (Object)dimDy.getString("membermodel")));
                }
                result.add(field);
            }
        }
        return result;
    }
}

