/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.YearScopeEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.papertemplate.PaperTemplateSceneSettingHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class PaperTemplateHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, PaperTemplateHelper.class);

    public static void saveTmplScene(long modelId, PaperTemplateTypeEnum type, long groupId, List<Map<String, Object>> items) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"bcm_tmplscenario", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("type", "=", (Object)type.getCode()), new QFilter("groupid", "=", (Object)groupId)});
                DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_tmplscenario");
                DynamicObjectCollection doc = new DynamicObjectCollection(dyn.getDynamicObjectType(), null);
                if (!CollectionUtils.isEmpty(items)) {
                    for (Map<String, Object> item : items) {
                        DynamicObject dynaObj = new DynamicObject(dyn.getDynamicObjectType(), null);
                        dynaObj.set("model", (Object)modelId);
                        dynaObj.set("scenario", (Object)LongUtil.toLong((Object)item.get("id")));
                        dynaObj.set("scope", item.get("scope"));
                        dynaObj.set("isexcept", item.get("isexcept"));
                        dynaObj.set("groupid", (Object)groupId);
                        dynaObj.set("type", (Object)type.getCode());
                        doc.add((Object)dynaObj);
                    }
                    SaveServiceHelper.save((IDataEntityType)doc.getDynamicObjectType(), (Object[])doc.toArray(new Object[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u4fdd\u5b58\u5171\u4eab\u60c5\u666f\u6570\u636e\u5931\u8d25\u3002", (Throwable)e);
                throw new KDBizException(ThrowableHelper.toString((Exception)e));
            }
        }
    }

    public static Map<String, Object> findTmplScene4Setting(long modelId, PaperTemplateTypeEnum type, long groupId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (type == null) {
            return result;
        }
        ArrayList<Map> items = new ArrayList<Map>(16);
        DynamicObjectCollection doc = PaperTemplateHelper.findTmplScene(modelId, type, Sets.newHashSet((Object[])new Long[]{groupId}));
        StringJoiner stringJoiner = new StringJoiner(";");
        for (DynamicObject dyn : doc) {
            items.add(MapInitHelper.ofMap((Object)"id", (Object)dyn.getLong("scenario.id"), (Object)"scope", (Object)dyn.getString("scope"), (Object)"isexcept", (Object)dyn.getString("isexcept")));
            stringJoiner.add(PaperTemplateSceneSettingHelper.formateDisplay((String)dyn.getString("scenario.number"), (String)dyn.getString("scenario.name"), (String)dyn.getString("scope"), (String)dyn.getString("isexcept")));
        }
        result.put("name", stringJoiner.toString());
        result.put("items", items);
        return result;
    }

    public static DynamicObjectCollection findTmplScene(long modelId, PaperTemplateTypeEnum type, Set<Long> groupIds) {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)modelId);
        qf.add("type", "=", (Object)type.getCode());
        qf.add("groupid", "in", groupIds);
        return QueryServiceHelper.query((String)"bcm_tmplscenario", (String)"id,model.id,scenario.id,scenario.number,scenario.name,scope,isexcept,groupid,type", (QFilter[])qf.toArray());
    }

    public static Set<Long> findTmplIdsByScene(Long modelId, PaperTemplateTypeEnum type, Long sceneId, Set<Long> tempIds) {
        if (CollectionUtils.isEmpty(tempIds)) {
            return new HashSet<Long>(16);
        }
        QFBuilder qfb = new QFBuilder();
        qfb.add("model", "=", (Object)modelId);
        qfb.add("type", "=", (Object)type.getCode());
        DynamicObjectCollection tmplDoc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "in", tempIds)});
        Set groupIds = tmplDoc.stream().map(e -> e.getLong("group")).collect(Collectors.toSet());
        qfb.add("groupid", "in", groupIds);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_tmplscenario", (String)"id,groupid,scenario.id,scenario.number,scope,isexcept", (QFilter[])qfb.toArray());
        Map<Long, Map<String, List<DynamicObject>>> groupExceptMap = doc.stream().collect(Collectors.groupingBy(e -> e.getLong("groupid"), Collectors.groupingBy(e -> e.getString("isexcept"))));
        Set<Long> authSceneIds = new HashSet<Long>(16);
        if (sceneId != null) {
            authSceneIds.add(sceneId);
        } else {
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            Set sceneIds = MemberReader.getAllNodeByDimNum((String)DimTypesEnum.SCENARIO.getNumber(), (String)modelNumber).stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet());
            Long l = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.SCENARIO.getNumber());
            authSceneIds = PermissionServiceImpl.getInstance(modelId).matchReadOrWritePermMembers(l, "bcm_scenemembertree", sceneIds);
        }
        HashSet groupIdSet = new HashSet(16);
        for (Map.Entry entry : groupExceptMap.entrySet()) {
            block12: {
                Set<Object> fitSceneIds;
                block11: {
                    Set<Object> exceptSceneIds = new HashSet(16);
                    if (((Map)entry.getValue()).get(PaperTemplateScenarioSettingConstant.ExceptEnum.NOT_APPLICABLE.getCode()) != null) {
                        exceptSceneIds = PaperTemplateHelper.explainRange(modelId, (List)((Map)entry.getValue()).get(PaperTemplateScenarioSettingConstant.ExceptEnum.NOT_APPLICABLE.getCode()));
                    }
                    fitSceneIds = new HashSet(16);
                    if (((Map)entry.getValue()).get(PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode()) != null) {
                        fitSceneIds = PaperTemplateHelper.explainRange(modelId, (List)((Map)entry.getValue()).get(PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode()));
                    }
                    fitSceneIds.removeAll(exceptSceneIds);
                    if (!CollectionUtils.isEmpty(fitSceneIds)) break block11;
                    if (sceneId == null) break block12;
                }
                if (!fitSceneIds.stream().anyMatch(authSceneIds::contains)) continue;
            }
            groupIdSet.add(entry.getKey());
        }
        if (CollectionUtils.isEmpty(groupIdSet)) {
            return new HashSet<Long>(16);
        }
        DynamicObjectCollection tmpls = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("group", "in", groupIdSet)});
        Set<Long> set = tmpls.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(tempIds)) {
            set.removeIf(e -> !tempIds.contains(e));
        }
        return set;
    }

    private static Set<Long> explainRange(Long modelId, List<DynamicObject> doc) {
        HashSet<Long> result = new HashSet<Long>(16);
        for (DynamicObject dyn : doc) {
            Set ids = (Set)BcmThreadCache.get((Object)"tmpl_scene_cache", (Object)dyn.getLong("scenario.id"), (Object)dyn.getString("scope"), () -> {
                MembRangeItem rangeItem = new MembRangeItem("bcm_scenemembertree", (Long)dyn.getLong("scenario.id"), dyn.getString("scenario.number"), RangeEnum.getRangeByVal((int)Integer.parseInt(dyn.getString("scope"))), false, (Object)modelId);
                HashSet tempSet = new HashSet(16);
                rangeItem.matchItems(e -> tempSet.add(e.getId()));
                return tempSet;
            });
            result.addAll(ids);
        }
        return result;
    }

    public static void deleteTmplScene(long modelId, Set<Long> collect) {
        QFBuilder qfb = new QFBuilder();
        qfb.add("model", "=", (Object)modelId);
        DynamicObjectCollection tmplDoc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
        Set groupIds = tmplDoc.stream().map(e -> e.getLong("group")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> groupIdMap = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,group", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("group", "in", groupIds)}).stream().collect(Collectors.groupingBy(e -> e.getLong("group")));
        groupIds.removeIf(item -> {
            List doc = (List)groupIdMap.get(item);
            if (doc != null) {
                return !collect.containsAll(doc.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()));
            }
            return true;
        });
        qfb.add("groupid", "in", groupIds);
        BusinessDataWriter.delete((String)"bcm_tmplscenario", (QFilter[])qfb.toArray());
    }

    public static Pair<String, Map<String, Set<Long>>> explainEffective(DynamicObject template) {
        DynamicObjectCollection effectives;
        if (template.containsProperty("effective") && (effectives = template.getDynamicObjectCollection("effective")).size() > 0) {
            Map<String, List<DynamicObject>> eMap = effectives.stream().collect(Collectors.groupingBy(o -> String.join((CharSequence)"#", o.getString("applytype"), o.getString("effectiveyear.number"), o.getString("yearscope"))));
            TreeMap<String, List<DynamicObject>> treeMap = new TreeMap<String, List<DynamicObject>>(eMap);
            TreeMap effectivedata = new TreeMap();
            StringBuilder str = new StringBuilder();
            for (Map.Entry<String, List<DynamicObject>> effectiveEntry : treeMap.entrySet()) {
                List<DynamicObject> es = effectiveEntry.getValue();
                Set periodIds = es.stream().filter(ef -> null != ef.getDynamicObject("effectiveperiod") && 0L != ef.getDynamicObject("effectiveperiod").getLong("id")).map(e -> e.getDynamicObject("effectiveperiod").getLong("id")).collect(Collectors.toSet());
                DynamicObject effective = es.get(0);
                effectivedata.put(effectiveEntry.getKey() + "@" + Optional.ofNullable(effective.getDynamicObject("effectiveyear")).map(year -> year.getString("id")).orElse("null") + "@" + effective.getString("applytype") + "@" + effective.getString("yearscope"), periodIds);
                str.append("1".equals(effective.getString("applytype")) ? ResManager.loadKDString((String)"\u9002\u7528", (String)"TemplateModel_01", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f8b\u5916", (String)"TemplateModel_02", (String)"fi-bcm-business", (Object[])new Object[0]));
                str.append(Optional.ofNullable(effective.getDynamicObject("effectiveyear")).map(year -> year.getString("name")).orElse(""));
                str.append(YearScopeEnum.getEnumByType((String)effective.getString("yearscope")).getName());
                if (!periodIds.isEmpty()) {
                    for (DynamicObject esp : es) {
                        DynamicObject effectiveperiod = esp.getDynamicObject("effectiveperiod");
                        str.append(effectiveperiod.getString("name"));
                    }
                } else {
                    str.append(ResManager.loadKDString((String)"\u6240\u6709\u671f\u95f4", (String)"TemplateModel_03", (String)"fi-bcm-business", (Object[])new Object[0]));
                }
                str.append(';');
            }
            return Pair.onePair((Object)str.toString(), effectivedata);
        }
        return Pair.onePair((Object)"", new HashMap(16));
    }

    public static void buildTemplateEffectDate(Map<String, Set<Long>> effective, DynamicObject template) {
        DynamicObjectCollection effectiveCol = template.getDynamicObjectCollection("effective");
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject temp = null;
        if (effectiveCol.size() > 0) {
            temp = (DynamicObject)effectiveCol.get(0);
        }
        effectiveCol.clear();
        if (effective != null && effective.size() > 0) {
            TreeMap effectiveMap = new TreeMap();
            AtomicInteger lineCount = new AtomicInteger();
            effective.forEach((key, value) -> {
                HashSet set = new HashSet(value);
                effectiveMap.put(key, set);
                lineCount.addAndGet(value.size() == 0 ? 1 : value.size());
            });
            HashSet yearIds = new HashSet();
            effectiveMap.keySet().forEach(k -> yearIds.add(k.split("@")[1]));
            Map years = new HashMap();
            yearIds.remove("null");
            if (yearIds.size() > 0) {
                years = BusinessDataServiceHelper.loadFromCache((String)"bcm_fymembertree", (String)"name, number", (QFilter[])new QFBuilder("id", "in", (Object)LongUtil.toLongList(yearIds)).toArray());
            }
            for (Map.Entry entry : effectiveMap.entrySet()) {
                DynamicObject rowObj;
                String[] split = ((String)entry.getKey()).split("@");
                Set periodIds = (Set)entry.getValue();
                if (periodIds.size() > 0) {
                    Collection periodDys = BusinessDataServiceHelper.loadFromCache((String)"bcm_periodmembertree", (String)"id, name, number", (QFilter[])new QFBuilder("id", "in", (Object)periodIds).toArray(), (String)"number").values();
                    for (DynamicObject p : periodDys) {
                        DynamicObject rowObj2;
                        if (temp != null) {
                            rowObj2 = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
                            effectiveCol.add((Object)rowObj2);
                        } else {
                            rowObj2 = effectiveCol.addNew();
                        }
                        rowObj2.set("seq", (Object)split[0]);
                        rowObj2.set("effectiveyear", split[1].equals("null") ? null : years.get(Long.valueOf(split[1])));
                        rowObj2.set("applytype", (Object)split[2]);
                        rowObj2.set("yearscope", (Object)split[3]);
                        rowObj2.set("effectiveperiod", (Object)p);
                    }
                    periodDys.clear();
                    continue;
                }
                if (temp != null) {
                    rowObj = (DynamicObject)cloneUtils.clone((IDataEntityBase)temp);
                    rowObj.set("effectiveperiod", null);
                    effectiveCol.add((Object)rowObj);
                } else {
                    rowObj = effectiveCol.addNew();
                }
                rowObj.set("seq", (Object)split[0]);
                rowObj.set("effectiveyear", split[1].equals("null") ? null : years.get(Long.valueOf(split[1])));
                rowObj.set("applytype", (Object)split[2]);
                rowObj.set("yearscope", (Object)split[3]);
            }
        }
    }

    public static Set<Long> queryEffectiveTmpls(Long modelId, Long yearId, Long periodId, Set<Long> tmplIds) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty(tmplIds)) {
            DynamicObject[] doc;
            List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
            for (DynamicObject tmpl : doc = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)"group,id,effective.effectiveyear, effective.effectiveperiod, effective.applytype, effective.yearscope", (QFilter[])new QFilter[]{new QFilter("id", "in", tmplIds)})) {
                if (!ConvertDifferenceHandle.isApply(yearId, periodId, tmpl.getDynamicObjectCollection("effective"), yearIdsList)) continue;
                result.add(tmpl.getLong("id"));
            }
        }
        return result;
    }

    public static boolean checkEffectiveScenario(long modelId, List<Map<String, Object>> settings) {
        if (settings != null && !settings.isEmpty()) {
            HashMap membRangeItemCache = new HashMap(16);
            HashSet applyScenarios = new HashSet(16);
            HashSet noScenarios = new HashSet(16);
            settings.forEach(d -> {
                long sceneId = LongUtil.toLong((Object)d.getOrDefault("id", 0L));
                String number = d.getOrDefault("number", "").toString();
                int scope = Integer.parseInt(((Object)d.getOrDefault("scope", 0)).toString());
                boolean isLeaf = Boolean.parseBoolean(((Object)d.getOrDefault("isleaf", false)).toString());
                String isExcept = d.getOrDefault("isexcept", "").toString();
                MembRangeItem item = new MembRangeItem("bcm_scenemembertree", (Long)sceneId, number, scope, false, (Object)modelId);
                String key = item.genKey("");
                if (!isLeaf && scope == RangeEnum.VALUE_10.getValue()) {
                    return;
                }
                Set nums = membRangeItemCache.computeIfAbsent(key, v -> {
                    HashSet numberSet = new HashSet(16);
                    item.matchItems(c -> numberSet.add(Pair.onePair(c.getId(), (Object)c.getNumber())));
                    return numberSet;
                });
                if (PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode().equals(isExcept)) {
                    applyScenarios.addAll(nums);
                } else {
                    noScenarios.addAll(nums);
                }
            });
            applyScenarios.removeAll(noScenarios);
            if (applyScenarios.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public static Set<Long> findTmpCatalogIds(Long model, PaperTemplateTypeEnum type) {
        QFBuilder catalog = new QFBuilder("model", "=", (Object)model);
        catalog.add("longnumber", "like", (Object)(type.getCatalogLongNumber() + "%"));
        return QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"id", (QFilter[])catalog.toArray()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }
}

