/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.computing.BizRuleExecStarter;
import kd.fi.bcm.business.innertrade.report.IntrBizRuleHelper;
import kd.fi.bcm.business.innertrade.report.IntrTemplateHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.BRExecStatusEnum;
import kd.fi.bcm.common.enums.BizRuleDebugLogInfoEnum;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateRuleTypeEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.BizRuleDebugLogInfo;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PaperTemplateRuleHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, IntrBizRuleHelper.class);

    public static ResultBox execBizRule(Long modelId, Long templateId, Map<String, Long> dimValueMap, PaperTemplateRuleTypeEnum ruleExecType, BizRuleExecuteTypeEnum ruleType, Consumer<BizRuleExecParam> paramConsumer) {
        ResultBox resultBox = ResultBox.of();
        DynamicObject template = IntrTemplateHelper.getTemplateInfo(modelId, templateId);
        DynamicObjectCollection rules = PaperTemplateRuleHelper.getTemplateAssignRule(modelId, Sets.newHashSet((Object[])new Long[]{templateId}), ruleExecType);
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            List<BizRuleExecParam> paramList = PaperTemplateRuleHelper.getExecParams(modelId, template, dimValueMap, rules, ruleType, paramConsumer);
            if (CollectionUtils.isEmpty(paramList)) {
                IDNumberTreeNode processNode = MemberReader.findProcessMemberById((String)MemberReader.findModelNumberById((Object)modelId), (Long)dimValueMap.get(PresetConstant.PROCESS_DIM));
                logger.info(String.format("\u6a21\u677f%s\u5728\u8fc7\u7a0b%s\u4e0a\u6ca1\u6709\u53ef\u8c03\u7528\u7684\u89c4\u5219\u3002", template.getString("number"), processNode.getNumber()));
                resultBox.add(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5728\u8fc7\u7a0b%s\u4e0a\u6ca1\u6709\u53ef\u8c03\u7528\u7684\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"PaperTemplateRuleHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), processNode.getNumber()));
                return resultBox;
            }
            Object[] result = PaperTemplateRuleHelper.doExecBizRule(modelId, paramList, rules);
            if (result.length == 0) {
                logger.info(String.format("\u6a21\u677f%s\u6ca1\u6709\u53ef\u8c03\u7528\u7684\u89c4\u5219\u3002", template.getString("number")));
                resultBox.add(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u6ca1\u6709\u53ef\u8c03\u7528\u7684\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"PaperTemplateRuleHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            } else {
                resultBox.setData((Object)result);
            }
            return resultBox;
        }
        logger.info(String.format("\u6a21\u677f%s\u5206\u914d\u89c4\u5219\u4e3a\u7a7a\u3002", template.getString("number")));
        resultBox.add(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5206\u914d\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"PaperTemplateRuleHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        return resultBox;
    }

    private static Object[] doExecBizRule(Long modelId, List<BizRuleExecParam> paramList, DynamicObjectCollection rules) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        BizRuleExecParam param = paramList.get(0);
        Collection allocateRecords = BizRuleServiceHelper.getBizRule((String)modelNum, f -> f.add("bizrule.id", "in", rules.stream().map(e -> e.getLong("bizrule.id")).collect(Collectors.toSet())), (String[])new String[]{param.getProcessNumber()});
        Object[] records = BizRuleExecStarter.createExecRecord(allocateRecords.toArray(new DynamicObject[0]), param, modelId);
        Map<Long, String> result = OlapServiceHelper.excuteScript4ReportParams(param.getModelNum(), paramList, ApplicationTypeEnum.CM);
        for (DynamicObject dynamicObject : records) {
            String reason;
            long bizRuleId = dynamicObject.getLong("bizrule");
            List infolist = (List)ThreadCache.get((Object)String.valueOf(bizRuleId));
            String executeInfoMsg = "";
            if (CollectionUtils.isNotEmpty((Collection)infolist)) {
                executeInfoMsg = infolist.stream().filter(log -> log.getLevel() == BizRuleDebugLogInfoEnum.LOG).map(BizRuleDebugLogInfo::getInfo).collect(Collectors.joining(","));
            }
            if (StringUtils.isNotEmpty((String)(reason = result.get(bizRuleId)))) {
                dynamicObject.set("execstatus", (Object)BRExecStatusEnum.FAILED.getIndex());
                dynamicObject.set("reason", (Object)(reason + System.lineSeparator() + executeInfoMsg));
            } else {
                dynamicObject.set("execstatus", (Object)BRExecStatusEnum.SUCCESS.getIndex());
                dynamicObject.set("reason", (Object)executeInfoMsg);
            }
            if (ThreadCache.get((Object)(bizRuleId + "startTime")) != null) {
                dynamicObject.set("starttime", ThreadCache.get((Object)(bizRuleId + "startTime")));
            }
            if (ThreadCache.get((Object)(bizRuleId + "endTime")) != null) {
                dynamicObject.set("endtime", ThreadCache.get((Object)(bizRuleId + "endTime")));
                continue;
            }
            dynamicObject.set("endtime", (Object)System.currentTimeMillis());
        }
        SaveServiceHelper.update((DynamicObject[])records);
        return records;
    }

    public static List<BizRuleExecParam> getExecParams(Long modelId, DynamicObject template, Map<String, Long> dimValueMap, DynamicObjectCollection rules, BizRuleExecuteTypeEnum ruleType, Consumer<BizRuleExecParam> paramConsumer) {
        IDNumberTreeNode processNode;
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Collection allocateRecords = BizRuleServiceHelper.getBizRule((String)modelNum, f -> f.add("bizrule.id", "in", rules.stream().map(e -> e.getLong("bizrule.id")).collect(Collectors.toSet())), (String[])new String[]{(processNode = MemberReader.findProcessMemberById((String)modelNum, (Long)dimValueMap.get(PresetConstant.PROCESS_DIM))).getNumber()});
        if (CollectionUtils.isEmpty((Collection)allocateRecords)) {
            return new ArrayList<BizRuleExecParam>(16);
        }
        List bizRuleList = allocateRecords.stream().filter(e -> kd.fi.bcm.fel.common.StringUtils.isNotEmpty((CharSequence)e.getString("bizrule.content"))).map(e -> Pair.onePair((Object)e.getLong("bizrule.id"), (Object)e.getString("bizrule.content"))).collect(Collectors.toList());
        BizRuleExecParam param = new BizRuleExecParam(modelNum);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)modelNum, (Long)dimValueMap.get(PresetConstant.ENTITY_DIM));
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberById((String)modelNum, (Long)dimValueMap.get(PresetConstant.SCENE_DIM));
        IDNumberTreeNode yearNode = MemberReader.findFyMemberById((String)modelNum, (Long)dimValueMap.get(PresetConstant.FY_DIM));
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberById((String)modelNum, (Long)dimValueMap.get(PresetConstant.PERIOD_DIM));
        IDNumberTreeNode currencyNode = MemberReader.findCurrencyMemberById((String)modelNum, (Long)dimValueMap.get(PresetConstant.CURRENCY_DIM));
        if (CurrencyEnum.EC.getNumber().equals(currencyNode.getNumber()) || CurrencyEnum.DC.getNumber().equals(currencyNode.getNumber())) {
            currencyNode = MemberReader.findCurrencyMemberByNum((String)modelNum, (String)orgNode.getCurrency());
        }
        param.getCommonParam().addCommonParamPair(PresetConstant.ENTITY_DIM, orgNode.getId(), orgNode.getNumber());
        param.getCommonParam().addCommonParamPair(PresetConstant.SCENE_DIM, sceneNode.getId(), sceneNode.getNumber());
        param.getCommonParam().addCommonParamPair(PresetConstant.FY_DIM, yearNode.getId(), yearNode.getNumber());
        param.getCommonParam().addCommonParamPair(PresetConstant.PERIOD_DIM, periodNode.getId(), periodNode.getNumber());
        param.getCommonParam().addCommonParamPair(PresetConstant.CURRENCY_DIM, currencyNode.getId(), currencyNode.getNumber());
        param.getCommonParam().addCommonParamPair(PresetConstant.PROCESS_DIM, processNode.getId(), processNode.getNumber());
        param.setBizRuleList(bizRuleList);
        param.setExecuteType(ruleType);
        param.setPaperTemplateNumber(template.getString("number"));
        param.setPaperTemplateId(Long.valueOf(template.getLong("id")));
        if (paramConsumer != null) {
            paramConsumer.accept(param);
        }
        return Lists.newArrayList((Object[])new BizRuleExecParam[]{param});
    }

    public static DynamicObjectCollection getTemplateAssignRule(Long modelId, Set<Long> templateIds, PaperTemplateRuleTypeEnum ruleType) {
        QFilter filter = new QFilter("papertemplate", "in", IntrTemplateHelper.getGroupTmplIds(modelId, templateIds));
        if (ruleType != null) {
            if (PaperTemplateRuleTypeEnum.MANUAL == ruleType) {
                filter.and("execwhenopen", "=", (Object)false);
                filter.and("execwhensave", "=", (Object)false);
            } else {
                filter.and(ruleType.getCode(), "=", (Object)true);
            }
        }
        return QueryServiceHelper.query((String)"bcm_brallocateentity", (String)"bizrule.id,execwhenopen,execwhensave,papertemplate", (QFilter[])new QFilter[]{filter});
    }
}

