/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections.CollectionUtils;

public class PaperTemplateService {
    private static final Set<TemplateCatalogEnum> PAPER_CATALOGS = new HashSet<TemplateCatalogEnum>(4);

    public static void initPresetCatalog(String modelId) {
        DynamicObject rootDyn;
        if (modelId == null) {
            return;
        }
        QFilter model = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter top = new QFilter("parent.id", "=", (Object)0);
        QFilter type = new QFilter("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType()));
        if (!QueryServiceHelper.exists((String)"bcm_papertemplatecatalog", (QFilter[])new QFilter[]{model, top, type})) {
            TemplateCatalogEnum rootCatalog = TemplateCatalogEnum.ROOT;
            rootDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_papertemplatecatalog");
            rootDyn.set("name", LanguageUtil.getValue(rootCatalog.getName(), rootCatalog.getResourceId(), "fi-bcm-common"));
            rootDyn.set("number", (Object)rootCatalog.getNumber());
            rootDyn.set("parent", (Object)LongUtil.toLong((Object)rootCatalog.getParent()));
            rootDyn.set("model", (Object)LongUtil.toLong((Object)modelId));
            rootDyn.set("longnumber", (Object)rootCatalog.getLongnumber());
            rootDyn.set("catalogtype", (Object)Character.valueOf(TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rootDyn});
        } else {
            rootDyn = BusinessDataServiceHelper.loadSingle((String)"bcm_papertemplatecatalog", (String)"id,name,number,longnumber,level", (QFilter[])new QFilter[]{model, top, type});
        }
        QFilter number = new QFilter("number", "in", (Object)PAPER_CATALOGS.stream().map(TemplateCatalogEnum::getNumber).distinct().toArray());
        if (!QueryServiceHelper.exists((String)"bcm_papertemplatecatalog", (QFilter[])new QFilter[]{model, number, type})) {
            ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(PAPER_CATALOGS.size());
            for (TemplateCatalogEnum catalogEnum : PAPER_CATALOGS) {
                DynamicObject catalogDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_papertemplatecatalog");
                catalogDyn.set("name", LanguageUtil.getValue(catalogEnum.getName(), catalogEnum.getResourceId(), "fi-bcm-common"));
                catalogDyn.set("number", (Object)catalogEnum.getNumber());
                catalogDyn.set("parent", (Object)rootDyn.getLong("id"));
                catalogDyn.set("catalogtype", (Object)Character.valueOf(catalogEnum.getType()));
                catalogDyn.set("sequence", (Object)catalogEnum.getSeq());
                catalogDyn.set("model", (Object)LongUtil.toLong((Object)modelId));
                catalogDyn.set("longnumber", (Object)catalogEnum.getLongnumber());
                catalogDyn.set("enable", (Object)"1");
                catalogDyn.set("status", (Object)"C");
                dynList.add(catalogDyn);
            }
            SaveServiceHelper.save((DynamicObject[])dynList.toArray(new DynamicObject[0]));
        }
    }

    public static String getTemplateType(String foucusnodeid) {
        if (StringUtils.isEmpty((CharSequence)foucusnodeid)) {
            return "";
        }
        DynamicObject catalogDy = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)foucusnodeid), (String)"bcm_papertemplatecatalog", (String)"longnumber");
        if (Objects.nonNull(catalogDy)) {
            return PaperTemplateService.getTemplateTypeByLongnumber(catalogDy.getString("longnumber"));
        }
        return "";
    }

    public static String getTemplateLongnumber(String foucusnodeid) {
        if (StringUtils.isEmpty((CharSequence)foucusnodeid)) {
            return "";
        }
        DynamicObject catalogDy = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)foucusnodeid), (String)"bcm_papertemplatecatalog", (String)"longnumber");
        if (Objects.nonNull(catalogDy)) {
            return PaperTemplateService.getCatalogPrefixByLongnumber(catalogDy.getString("longnumber"));
        }
        return "";
    }

    public static String getTemplateTypeByLongnumber(String longnumber) {
        TemplateCatalogEnum catalogEnum = PaperTemplateService.getCatalogEnumByLongnumber(longnumber);
        return catalogEnum == null ? "" : catalogEnum.getTemplatetype();
    }

    public static String getCatalogPrefixByLongnumber(String longnumber) {
        TemplateCatalogEnum catalogEnum = PaperTemplateService.getCatalogEnumByLongnumber(longnumber);
        return catalogEnum == null ? "" : catalogEnum.getLongnumber();
    }

    public static TemplateCatalogEnum getCatalogEnumByLongnumber(String longnumber) {
        if (StringUtils.isEmpty((CharSequence)longnumber)) {
            return null;
        }
        if (Objects.equals(longnumber, TemplateCatalogEnum.ROOT.getLongnumber())) {
            return TemplateCatalogEnum.ROOT;
        }
        for (TemplateCatalogEnum catalogEnum : TemplateCatalogEnum.values()) {
            if (catalogEnum == TemplateCatalogEnum.ROOT || !longnumber.startsWith(catalogEnum.getLongnumber())) continue;
            return catalogEnum;
        }
        return null;
    }

    public static boolean isTemplateType(String foucusnodeid, String templatetype) {
        if (StringUtils.isEmpty((CharSequence)templatetype) || StringUtils.isEmpty((CharSequence)foucusnodeid)) {
            return false;
        }
        DynamicObject catalogDy = BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)foucusnodeid), (String)"bcm_papertemplatecatalog", (String)"longnumber");
        if (Objects.nonNull(catalogDy)) {
            String numberPrefix = PaperTemplateService.getCatalogPrefixByLongnumber(catalogDy.getString("longnumber"));
            return Objects.equals("root." + templatetype, numberPrefix);
        }
        return false;
    }

    public static String beforeSaveCheck(String modelID, BigDecimal version, String number, String name, Long catalogId) {
        String msg = "";
        String regex = ".*[/:\\*\\?\\!<>\\[\\]\\\\].*";
        if (name.matches(regex)) {
            msg = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u542b\u6709%s\u7b49\u5b57\u7b26\u3002", (String)"PaperTemplatePlugin_1", (String)"fi-bcm-business", (Object[])new Object[0]), "/\\\\:*?!<>[]");
            return msg;
        }
        if (!PaperTemplateService.checkNumberVersionUnique(modelID, version, number, catalogId)) {
            msg = ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff01", (String)"PaperTemplatePlugin_2", (String)"fi-bcm-business", (Object[])new Object[]{number});
            return msg;
        }
        return msg;
    }

    public static boolean checkNumberVersionUnique(String modelID, BigDecimal version, String number, Long catalogId) {
        QFilter fmodelid = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelID));
        QFilter fnumber = new QFilter("number", "=", (Object)number);
        QFilter fcatalog = new QFilter("templatecatalog", "=", (Object)catalogId);
        QFilter fversion = new QFilter("versionnumber", "=", (Object)version);
        return !QueryServiceHelper.exists((String)"bcm_papertemplate", (QFilter[])new QFilter[]{fmodelid, fnumber, fcatalog, fversion});
    }

    public static List<Long> getSameGroup(List<String> templateIds, Long model) {
        List ids = LongUtil.toLongList(templateIds);
        QFilter qf = new QFilter("id", "in", (Object)ids.toArray()).and("model", "=", (Object)model);
        DynamicObjectCollection tempList = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"group", (QFilter[])new QFilter[]{qf});
        QFilter groupqf = new QFilter("group", "in", (Object)tempList.stream().map(s -> s.getLong("group")).toArray()).and("model", "=", (Object)model);
        DynamicObjectCollection alltempList = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,number,name,effectivescope", (QFilter[])new QFilter[]{groupqf});
        return alltempList.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    public static TreeNode getTemplateTree(DynamicObject catalogObj, long modelId, DynamicObject[] templateColl, List<TreeNode> templateNodeList, String rootId, TreeNode treeNode, List<Long> noPermCatalogIds) {
        List<Map<String, String>> templatecatalogList = PaperTemplateService.mergeTemplatecatalogList(catalogObj, modelId, noPermCatalogIds);
        return PaperTemplateService.traverseTemplateTree(templatecatalogList, templateColl, templateNodeList, rootId, treeNode);
    }

    public static TreeNode traverseTemplateTree(List<Map<String, String>> templatecatalogList, DynamicObject[] templateColl, List<TreeNode> templateNodeList, String rootId, TreeNode treeNode) {
        if (!templateNodeList.isEmpty()) {
            treeNode.setChildren(templateNodeList);
        }
        if (templatecatalogList.isEmpty()) {
            return new TreeNode();
        }
        for (Map<String, String> map : templatecatalogList) {
            String fieldId = map.get("id");
            String fieldName = map.get("name");
            String parentid = map.get("parentid");
            if (!parentid.equals(rootId)) continue;
            if (templateColl != null && templateColl.length > 0) {
                templateNodeList = new ArrayList<TreeNode>(templateColl.length);
                for (DynamicObject templateObject : templateColl) {
                    if (!templateObject.get("templatecatalog").toString().equals(fieldId)) continue;
                    TreeNode templateNode = new TreeNode();
                    templateNode.setParentid(fieldId);
                    templateNode.setId(templateObject.get("id").toString());
                    templateNode.setText(templateObject.get("number").toString() + "   " + templateObject.get("name").toString());
                    templateNode.setData(null);
                    templateNodeList.add(templateNode);
                }
            }
            TreeNode entry = new TreeNode();
            entry.setParentid(parentid);
            entry.setId(fieldId);
            entry.setText(fieldName);
            entry.setData((Object)map.get("number"));
            entry = PaperTemplateService.traverseTemplateTree(templatecatalogList, templateColl, templateNodeList, fieldId, entry);
            ArrayList<TreeNode> children = treeNode.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>();
                treeNode.setChildren(children);
            }
            if (entry.getChildren() != null) {
                children.add(entry);
            }
            entry.setIsOpened(true);
        }
        return treeNode;
    }

    public static String getTemplateNumbers(Object[] primaryKeyValues) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,name,number,status", (QFilter[])qfBuilder.toArray());
        return doc.stream().map(s -> s.getString("number")).collect(Collectors.joining("\u3001"));
    }

    public static void saveDistributeRecord(List<DynamicObject> orgList, List<Long> tplIds, long modelId, String msg) {
        List<DynamicObject> distList = PaperTemplateService.mergeResult(orgList, tplIds, modelId);
        if (CollectionUtils.isEmpty(distList)) {
            return;
        }
        List templateIds = distList.stream().map(s -> s.getLong("template")).collect(Collectors.toList());
        QFilter qf = new QFilter("id", "in", (Object)templateIds.toArray());
        Collection tplList = BusinessDataServiceHelper.loadFromCache((String)"bcm_papertemplate", (String)"id,number,name,effectivescope", (QFilter[])new QFilter[]{qf}).values();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        String selectFields = "id,entity,template,range,propertyvalue,isexcept ";
        DynamicObjectCollection oldColl = QueryServiceHelper.query((String)"bcm_templateassignrecord", (String)selectFields, (QFilter[])new QFilter[]{filter});
        for (DynamicObject tem : oldColl) {
            Iterator<DynamicObject> itr = distList.iterator();
            while (itr.hasNext()) {
                DynamicObject dd = itr.next();
                Object entityid = dd.get("entity");
                String colName = !ObjectUtils.isEmpty((Object)entityid) ? "entity" : "propertyvalue";
                dd.set("creator", (Object)RequestContext.get().getCurrUserId());
                dd.set("createtime", (Object)TimeServiceHelper.now());
                if (tem.getLong("template") != dd.getLong("template") || !tem.get("range").equals(dd.get("range")) || !tem.get("isexcept").equals(dd.get("isexcept")) || tem.getLong(colName) != dd.getLong(colName)) continue;
                itr.remove();
            }
        }
        if (distList.isEmpty()) {
            return;
        }
        boolean flag = false;
        try (TXHandle tx = TX.required();){
            String result;
            try {
                DynamicObject[] newdoc = distList.toArray(new DynamicObject[0]);
                SaveServiceHelper.save((DynamicObject[])newdoc);
                flag = true;
                result = flag ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName();
            }
            catch (Throwable e) {
                try {
                    tx.markRollback();
                    throw e;
                }
                catch (Throwable throwable) {
                    result = flag ? ResultStatusEnum.SUCCESS.getName() : ResultStatusEnum.FAIL.getName();
                    HashSet<String> numbers = new HashSet<String>(16);
                    HashSet<String> names = new HashSet<String>(16);
                    for (DynamicObject dy : tplList) {
                        numbers.add(dy.getString("number"));
                        names.add(dy.getString("name"));
                    }
                    String opDescription = Joiner.on((String)",").join(numbers) + " " + Joiner.on((String)",").join(names) + " " + result;
                    OperationLogUtil.writeOperationLog(OpItemEnum.SEND.getName(), opDescription, modelId, "bcm_templateassignrecord");
                    throw throwable;
                }
            }
            HashSet<String> numbers = new HashSet<String>(16);
            HashSet<String> names = new HashSet<String>(16);
            for (DynamicObject dy : tplList) {
                numbers.add(dy.getString("number"));
                names.add(dy.getString("name"));
            }
            String opDescription = Joiner.on((String)",").join(numbers) + " " + Joiner.on((String)",").join(names) + " " + result;
            OperationLogUtil.writeOperationLog(OpItemEnum.SEND.getName(), opDescription, modelId, "bcm_templateassignrecord");
        }
    }

    private static List<DynamicObject> mergeResult(List<DynamicObject> orgList, List<Long> tplList, Long modelId) {
        if (!orgList.isEmpty()) {
            HashMap<String, DynamicObject> mergeMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject dyn : orgList) {
                String formatKey;
                IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)dyn.getLong("oid")).getBaseTreeNode();
                if (IDNumberTreeNode.NotFoundTreeNode != node) {
                    dyn.set("oid", (Object)node.getId());
                }
                if (mergeMap.containsKey(formatKey = String.format("%s_%s_%s_%s", dyn.get("oid"), dyn.get("pid"), dyn.get("rangevalue"), dyn.get("org_isexcept")))) continue;
                mergeMap.put(formatKey, dyn);
            }
            ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
            for (Long tem : tplList) {
                for (Map.Entry kv : mergeMap.entrySet()) {
                    DynamicObject org = (DynamicObject)kv.getValue();
                    DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateassignrecord");
                    if (StringUtils.isEmpty((CharSequence)org.getString("pid").trim()) || Objects.equals("0", org.getString("pid").trim())) {
                        distribute.set("entity", (Object)Long.valueOf(org.get("oid").toString()));
                    } else {
                        distribute.set("property", org.get("pid"));
                        distribute.set("propertyvalue", org.get("oid"));
                    }
                    distribute.set("range", org.get("rangevalue"));
                    distribute.set("template", (Object)tem);
                    distribute.set("model", (Object)modelId);
                    distribute.set("isexcept", (Object)org.getString("org_isexcept"));
                    result.add(distribute);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static void deleteDistRecord(Object[] rows, long modelId) {
        String selectFields = "id,template.id,template.number,template.group,entity.id,property.id,propertyvalue.id,range,isexcept";
        HashMultimap groupOrgInfo = HashMultimap.create();
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bcm_templateassignrecord", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)rows)});
        docs.forEach(arg_0 -> PaperTemplateService.lambda$deleteDistRecord$4((Multimap)groupOrgInfo, arg_0));
        DynamicObjectCollection sameGroupAssignRecords = QueryServiceHelper.query((String)"bcm_templateassignrecord", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("template.group", "in", (Object)groupOrgInfo.keySet())});
        Set ids = sameGroupAssignRecords.stream().filter(arg_0 -> PaperTemplateService.lambda$deleteDistRecord$5((Multimap)groupOrgInfo, arg_0)).map(e -> e.getLong("id")).collect(Collectors.toSet());
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"bcm_templateassignrecord", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                String numberstr = docs.stream().map(s -> s.getString("template.number")).collect(Collectors.joining(","));
                OperationLogUtil.writeOperationLog(OpItemEnum.BACKSEND.getName(), numberstr + " " + ResultStatusEnum.SUCCESS.getName(), modelId, "bcm_templateassignrecord");
            }
            catch (Throwable ex) {
                OperationLogUtil.writeOperationLog(OpItemEnum.BACKSEND.getName(), ResultStatusEnum.FAIL.getName(), modelId, "bcm_templateassignrecord");
                tx.markRollback();
                throw ex;
            }
        }
    }

    private static String getOrgInfo(DynamicObject e) {
        StringBuilder orgInfo = new StringBuilder(16);
        orgInfo.append(e.getLong("entity.id"));
        orgInfo.append(e.getLong("property.id"));
        orgInfo.append(e.getLong("propertyvalue.id"));
        orgInfo.append(e.getString("range"));
        orgInfo.append(e.getString("isexcept"));
        return orgInfo.toString();
    }

    public static List<Map<String, String>> mergeTemplatecatalogList(DynamicObject catalogObj, long modelId, List<Long> noPermCatalogIds) {
        DynamicObjectCollection doc = PaperTemplateService.getTemplatecatalogList(modelId, noPermCatalogIds);
        doc = PaperTemplateService.filterTemplatecatalogList(doc);
        String catalogprefix = PaperTemplateService.getCatalogPrefixByLongnumber(catalogObj.getString("longnumber"));
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>(10);
        doc.stream().filter(s -> s.getString("longnumber").equals("root") || s.getString("longnumber").startsWith(catalogprefix)).forEach(p -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("id", p.getString("id"));
            map.put("name", p.getString("name"));
            map.put("parentid", p.getString("parent"));
            map.put("longnumber", p.getString("longnumber"));
            clist.add(map);
        });
        return clist;
    }

    public static DynamicObjectCollection getTemplatecatalogList(long modelId, List<Long> noPermCatalogIds) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        QFilter ftype = new QFilter("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType()));
        if (CollectionUtils.isNotEmpty(noPermCatalogIds)) {
            filter.and("id", "not in", noPermCatalogIds);
        }
        QFilter[] filters = new QFilter[]{filter, ftype};
        String selectFields = "id,parent,name,longnumber";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public static DynamicObjectCollection filterTemplatecatalogList(DynamicObjectCollection docs) {
        Map<String, DynamicObject> allMap = docs.stream().collect(Collectors.toMap(s -> s.getString("longnumber"), s -> s, (s1, s2) -> s2));
        QFilter filter = new QFilter("templatecatalog.id", "in", docs.stream().map(s -> s.getLong("id")).collect(Collectors.toSet()));
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "templatecatalog.id,templatecatalog.longnumber";
        String orderBys = "templatecatalog.longnumber";
        DynamicObjectCollection directCatalog = QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])filters, (String)orderBys);
        List distinctdirectCatalog = directCatalog.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(o -> o.getLong("templatecatalog.id") + o.getString("templatecatalog.longnumber")))), ArrayList::new));
        Map<Long, String> directMap = distinctdirectCatalog.stream().collect(Collectors.toMap(s -> s.getLong("templatecatalog.id"), s -> s.getString("templatecatalog.longnumber")));
        return allMap.entrySet().stream().filter(s -> directMap.entrySet().stream().anyMatch(t -> ((String)t.getValue()).startsWith((String)s.getKey()))).map(v -> (DynamicObject)v.getValue()).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    public static Map<Long, DynamicObject> getTemplateStatus(Object[] primaryKeyValues) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", (Object)primaryKeyValues);
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(primaryKeyValues.length);
        DynamicObjectCollection dos = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,name,number,status", (QFilter[])qfBuilder.toArray());
        for (DynamicObject object : dos) {
            result.put(object.getLong("id"), object);
        }
        return result;
    }

    public static Pair<Set<Long>, Set<Long>> updateTemplateStatus(String isEnable, Object[] primaryKeyValues, boolean isCheckEffectiveDate) {
        HashSet unEffectiveDate = new HashSet(10);
        HashSet unTmplScene = new HashSet(10);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", (Object)primaryKeyValues);
        qfBuilder.add("status", "!=", (Object)isEnable);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)PaperTemplateService.getSelectParams(isCheckEffectiveDate), (QFilter[])qfBuilder.toArray());
        ArrayList needUpdate = new ArrayList(16);
        Arrays.stream(dos).forEach(p -> {
            boolean exists;
            boolean isUpdate = true;
            if (isCheckEffectiveDate && p.get("effectivedate") == null) {
                isUpdate = false;
                unEffectiveDate.add(p.getLong("id"));
            }
            if (!(exists = QueryServiceHelper.exists((String)"bcm_tmplscenario", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)p.getLong("model.id")), new QFilter("groupid", "=", (Object)p.getLong("group"))})) && "1".equals(isEnable)) {
                isUpdate = false;
                unTmplScene.add(p.getLong("id"));
            }
            if (isUpdate) {
                p.set("status", (Object)isEnable);
                p.set("modifier", (Object)RequestContext.get().getUserId());
                p.set("modifytime", (Object)TimeServiceHelper.now());
                needUpdate.add(p);
            }
        });
        if (needUpdate.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdate.toArray(new DynamicObject[0]));
        }
        return Pair.onePair(unEffectiveDate, unTmplScene);
    }

    private static String getSelectParams(boolean isCheckEffectiveDate) {
        if (isCheckEffectiveDate) {
            return "model.id,number,name,versionnumber,status,effectivedate,modifier,modifytime,group";
        }
        return "model.id,status,modifier,modifytime,group";
    }

    public static void filterVersionTemplateTree(Collection<DynamicObject> templateColls) {
        HashSet passes = new HashSet();
        Map<String, List<DynamicObject>> templateGroups = templateColls.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
        templateGroups.forEach((number, tmpList) -> {
            if (tmpList.size() == 1) {
                passes.add(((DynamicObject)tmpList.get(0)).getLong("id"));
            } else {
                tmpList.sort((o1, o2) -> -1 * o1.getBigDecimal("versionnumber").compareTo(o2.getBigDecimal("versionnumber")));
                passes.add(((DynamicObject)tmpList.get(0)).getLong("id"));
            }
        });
        templateColls.removeIf(t -> !passes.contains(t.getLong("id")));
    }

    public static ResultBox copyTemplate(String foucusId, Object[] ids) {
        String templateType = PaperTemplateService.getTemplateType(foucusId);
        if (TemplateCatalogEnum.PRTADJUST.getTemplatetype().equals(templateType)) {
            return PaperTemplateService.copyAdjustPaperTemplate(ids);
        }
        return ResultBox.of();
    }

    private static ResultBox checkTemplateCatalogPerm(DynamicObject[] templates) {
        ResultBox result = ResultBox.of();
        if (templates != null && templates.length > 0) {
            String modelId = templates[0].getString("model.id");
            boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), modelId);
            if (!adminUserBol) {
                ArrayListMultimap<String, Long> tmplCatalogPermMap = PermClassEntityHelper.getPermissionMapBatch("bcm_papertemplatecatalog", modelId, RequestContext.get().getUserId());
                List noPerms = tmplCatalogPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
                List readonlyPerm = tmplCatalogPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue());
                ArrayListMultimap<String, Long> tmplPermMap = PermClassEntityHelper.getPermissionMapBatch("bcm_papertemplate", modelId, RequestContext.get().getUserId());
                List notmplPerms = tmplPermMap.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
                if (CollectionUtils.isEmpty((Collection)noPerms) && CollectionUtils.isEmpty((Collection)readonlyPerm)) {
                    return result;
                }
                for (DynamicObject template : templates) {
                    if (noPerms.contains(template.getLong("templatecatalog.id")) || readonlyPerm.contains(template.getLong("templatecatalog.id"))) {
                        result.addError(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5206\u7c7b\u3010%1$s %2$s\u3011\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"PaperTemplateService_1", (String)"fi-bcm-business", (Object[])new Object[0]), template.getString("number"), template.getString("name")));
                        continue;
                    }
                    if (!notmplPerms.contains(template.getLong("permclass.id"))) continue;
                    result.addError(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e3a\u3010%1$s %2$s\u3011\u7684\u6743\u9650\u7c7b\u65e0\u6743\u3002", (String)"PaperTemplateService_4", (String)"fi-bcm-business", (Object[])new Object[0]), template.getString("number"), template.getString("name")));
                }
            }
        }
        return result;
    }

    private static ResultBox copyAdjustPaperTemplate(Object[] ids) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"bcm_papertemplate");
        DynamicObject[] templates = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)dataEntityType);
        ResultBox resultBox = PaperTemplateService.checkTemplateCatalogPerm(templates);
        if (resultBox.isNotSuccess()) {
            return resultBox;
        }
        long modelId = templates[0].getLong("model.id");
        Set<Long> groupIds = Arrays.stream(templates).map(e -> e.getLong("group")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> groupTmplSceneMap = PaperTemplateHelper.findTmplScene(modelId, PaperTemplateTypeEnum.PRTADJUST, groupIds).stream().collect(Collectors.groupingBy(e -> e.getLong("groupid")));
        ArrayList<DynamicObject> newTmplSceneList = new ArrayList<DynamicObject>(16);
        if (templates != null && templates.length > 0) {
            CloneUtils cloneUtils = new CloneUtils(true, true);
            HashMap<String, DynamicObject> copyMap = new HashMap<String, DynamicObject>(templates.length);
            for (DynamicObject template : templates) {
                DynamicObject newDy = (DynamicObject)cloneUtils.clone((IDataEntityType)dataEntityType, (Object)template);
                newDy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                newDy.set("creator", (Object)RequestContext.get().getUserId());
                newDy.set("createtime", (Object)TimeServiceHelper.now());
                long newGroupId = GlobalIdUtil.genGlobalLongId();
                newDy.set("group", (Object)newGroupId);
                newDy.set("modifytime", null);
                newDy.set("modifier", null);
                newDy.set("permclass", null);
                newDy.set("status", (Object)"0");
                String name = newDy.getString("name") + "_copy";
                newDy.set("name", (Object)(name.length() > 50 ? name.substring(0, 50) : name));
                String number = newDy.getString("number") + "_copy";
                number = number.length() > 50 ? number.substring(0, 50) : number;
                newDy.set("number", (Object)number);
                newDy.set("description", (Object)String.format(ResManager.loadKDString((String)"%1$s(\u6765\u6e90\u590d\u5236%2$s)", (String)"PaperTemplateService_2", (String)"fi-bcm-business", (Object[])new Object[0]), newDy.getString("description"), template.getString("number")));
                newDy.getDynamicObjectCollection("commembentry").stream().forEach(e -> e.set("id", null));
                newDy.getDynamicObjectCollection("spreadmembentry").stream().forEach(e -> e.set("id", null));
                copyMap.put(number, newDy);
                List<DynamicObject> oldTmplSceneList = groupTmplSceneMap.get(template.getLong("group"));
                if (!CollectionUtils.isNotEmpty(oldTmplSceneList)) continue;
                for (DynamicObject oldDyn : oldTmplSceneList) {
                    DynamicObject newTmplSceneDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_tmplscenario");
                    newTmplSceneDy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                    newTmplSceneDy.set("model", (Object)oldDyn.getLong("model.id"));
                    newTmplSceneDy.set("scenario", (Object)oldDyn.getLong("scenario.id"));
                    newTmplSceneDy.set("scope", (Object)oldDyn.getString("scope"));
                    newTmplSceneDy.set("groupid", (Object)newGroupId);
                    newTmplSceneDy.set("isexcept", (Object)oldDyn.getString("isexcept"));
                    newTmplSceneDy.set("type", (Object)oldDyn.getString("type"));
                    newTmplSceneList.add(newTmplSceneDy);
                }
            }
            PaperTemplateService.resetSampleNumber(copyMap);
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])copyMap.values().toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])newTmplSceneList.toArray(new DynamicObject[0]));
                }
                catch (Exception e2) {
                    tx.markRollback();
                    throw new KDBizException(ThrowableHelper.toString((Exception)e2));
                }
            }
            resultBox.setData(copyMap);
        }
        return resultBox;
    }

    private static void resetSampleNumber(Map<String, DynamicObject> copyMaps) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", copyMaps.keySet())});
        if (query.isEmpty()) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = simpleDateFormat.format(new Date());
        query.stream().map(e -> e.getString("number")).forEach(e -> {
            DynamicObject c = (DynamicObject)copyMaps.remove(e);
            if (c != null) {
                c.set("number", (Object)(e.length() <= 35 ? e + dateStr : e.substring(0, 35) + dateStr));
                copyMaps.put(c.getString("number"), c);
            }
        });
        PaperTemplateService.resetSampleNumber(copyMaps);
    }

    public static void moveTemplateForCatalog(long modelId, long templateCatalogId, Collection<Object> ids) {
        ArrayListMultimap<String, Long> tmplCatalogPermMap;
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId));
        if (!adminUserBol && ((tmplCatalogPermMap = PermClassEntityHelper.getPermissionMapBatch("bcm_papertemplatecatalog", String.valueOf(modelId), RequestContext.get().getUserId())).get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue()).contains(templateCatalogId) || tmplCatalogPermMap.get((Object)PermClassEntityHelper.PermClassEnum.READONLY.getValue()).contains(templateCatalogId))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u76ee\u6807\u6a21\u677f\u5206\u7c7b\u65e0\u6743\u6216\u53ea\u8bfb\u3002", (String)"PaperTemplateService_3", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", ids);
        DynamicObject[] selectedData = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)"number,name,group", (QFilter[])qfBuilder.toArray());
        ArrayList msg = new ArrayList(selectedData.length);
        Set<Object> groupIds = Arrays.stream(selectedData).map(p -> {
            msg.add(p.getString("number") + " " + p.getString("name") + "," + OpItemEnum.MOVE.getName() + ResultStatusEnum.SUCCESS.getName());
            return p.get("group");
        }).collect(Collectors.toSet());
        PaperTemplateService.moveAllVersion2Catalog(ids, modelId, templateCatalogId, groupIds, (Consumer<DynamicObject[]>)((Consumer)dos -> {
            SaveServiceHelper.save((DynamicObject[])dos);
            OperationLogUtil.batchWriteOperationLog(OpItemEnum.MOVE.getName(), msg, modelId, "bcm_papertemplate");
        }));
    }

    public static void moveAllVersion2Catalog(Collection<Object> ids, long modelId, long templateCatalogId, Set<Object> groupIds, Consumer<DynamicObject[]> consumer) {
        DynamicObject[] dos;
        groupIds.remove(0L);
        QFBuilder qfBuilderG = new QFBuilder("model", "=", (Object)modelId).add("group", "in", groupIds).or("id", "in", ids);
        for (DynamicObject dynamicObject : dos = BusinessDataServiceHelper.load((String)"bcm_papertemplate", (String)"templatecatalog", (QFilter[])qfBuilderG.toArray())) {
            dynamicObject.set("templatecatalog", (Object)templateCatalogId);
        }
        if (dos.length > 0) {
            consumer.accept((Object)dos);
        }
    }

    public static String querySpreadType(long id) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_papertemplate", (String)"spreadtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        return Optional.ofNullable(dynamicObject).map(dy -> dy.getString("spreadtype")).orElse("1");
    }

    public static void checkRelationTypeUsed(Collection<Long> relationTypeIds, BiConsumer<String, Long> consumer) {
        String baseData = "invrelationtype.fbasedataid";
        QFBuilder qfBuilder = new QFBuilder(baseData, "in", relationTypeIds);
        String selectFields = String.join((CharSequence)",", baseData, "number");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])qfBuilder.toArray());
        for (DynamicObject dynamicObject : query) {
            String paperNumber = dynamicObject.getString("number");
            long relationTypeId = dynamicObject.getLong(baseData);
            consumer.accept(paperNumber, relationTypeId);
        }
    }

    public static Map<Long, List<DynamicObject>> buildTemp2RelationBy(Set<Long> tempIds) {
        String selectFields = String.join((CharSequence)",", "invrelationtype.pkid", "invrelationtype", "invrelationtype.fbasedataid", "invrelationtype.fbasedataid.number", "invrelationtype.fbasedataid.name", "invrelationtype.fbasedataid.categorized");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_papertemplate", (String)selectFields, (QFilter[])new QFBuilder("id", "in", tempIds).toArray());
        return query.stream().collect(Collectors.groupingBy(dy -> dy.getLong("invrelationtype")));
    }

    public static String getDefaultRelationTypeNumber(Long templateId) {
        return (String)ThreadCache.get((Object)("inv_DefaultRelationType" + templateId), () -> {
            List relationTypes = PaperTemplateService.buildTemp2RelationBy(Sets.newHashSet((Object[])new Long[]{templateId})).getOrDefault(templateId, Collections.emptyList());
            if (relationTypes.isEmpty()) {
                return "";
            }
            DynamicObject dynamicObject = (DynamicObject)relationTypes.get(0);
            String defaultRelationType = dynamicObject.getString("invrelationtype.fbasedataid.number");
            return defaultRelationType;
        });
    }

    public static boolean existsByExtMem(Collection<Long> extMemIds) {
        QFilter invQf = new QFilter("extdimid", "in", extMemIds);
        DynamicObjectCollection layouts = QueryServiceHelper.query((String)"bcm_invsheetacclayout", (String)"template", (QFilter[])new QFilter[]{invQf});
        Set templateIds = layouts.stream().map(dy -> dy.getLong("template")).collect(Collectors.toSet());
        DynamicObjectCollection templateDys = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id", (QFilter[])new QFBuilder("id", "in", templateIds).toArray());
        Set templatePresentIds = templateDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        templateIds.removeAll(templatePresentIds);
        if (!templateIds.isEmpty()) {
            DeleteServiceHelper.delete((String)"bcm_invsheetacclayout", (QFilter[])new QFBuilder("template", "in", templateIds).toArray());
        }
        return !templatePresentIds.isEmpty();
    }

    private static /* synthetic */ boolean lambda$deleteDistRecord$5(Multimap groupOrgInfo, DynamicObject e) {
        return groupOrgInfo.get((Object)e.getLong("template.group")).contains(PaperTemplateService.getOrgInfo(e));
    }

    private static /* synthetic */ void lambda$deleteDistRecord$4(Multimap groupOrgInfo, DynamicObject e) {
        groupOrgInfo.put((Object)e.getLong("template.group"), (Object)PaperTemplateService.getOrgInfo(e));
    }

    static {
        PAPER_CATALOGS.addAll(TemplateCatalogEnum.getPaperCatalog());
    }
}

