/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.papertemplate.PaperTemplateScenarioSettingConstant;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;

public class PaperTmplExpImpHelper {
    public static Map<String, FourTuple<Integer, Long, Long, Long>> getTmplMaxVersion(Long modelId, TemplateCatalogEnum type, Set<String> numberSet) {
        QFBuilder catalogFilter = new QFBuilder("model", "=", (Object)modelId).and("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.PAPERTEMPLATELOG.getType())).and("longnumber", "like", (Object)(type.getLongnumber() + "%"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_papertemplatecatalog", (String)"id", (QFilter[])catalogFilter.toArray());
        Set catalogIds = dynamicObjects.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)modelId);
        builder.add("templatecatalog", "in", catalogIds);
        builder.add("number", "in", numberSet);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id,number,versionnumber,group,templatecatalog", (QFilter[])builder.toArray());
        if (doc == null || doc.isEmpty()) {
            return new HashMap<String, FourTuple<Integer, Long, Long, Long>>(16);
        }
        return doc.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> new FourTuple((Object)e.getInt("versionnumber"), (Object)e.getLong("group"), (Object)e.getLong("id"), (Object)e.getLong("templatecatalog")), (e1, e2) -> (Integer)e1.item1 > (Integer)e2.item1 ? e1 : e2));
    }

    public static DynamicObject createTmplSceneDyn(Long modelId, Long sceneid, Long groupId, PaperTemplateTypeEnum type) {
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_tmplscenario");
        dyn.set("model", (Object)modelId);
        dyn.set("scenario", (Object)sceneid);
        dyn.set("scope", (Object)String.valueOf(RangeEnum.VALUE_10.getValue()));
        dyn.set("isexcept", (Object)PaperTemplateScenarioSettingConstant.ExceptEnum.APPLICABLE.getCode());
        dyn.set("groupid", (Object)groupId);
        dyn.set("type", (Object)type.getCode());
        return dyn;
    }

    public static List<DynamicObject> createDistributionDyn(Long modelId, long newTmplid, Long oldTmplId) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_templateassignrecord").getAllFields().keySet();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateassignrecord", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("template", "=", (Object)oldTmplId)});
        for (DynamicObject dyn : doc) {
            DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templateassignrecord");
            for (String field : fields) {
                item.set(field, dyn.get(field));
            }
            item.set("template", (Object)newTmplid);
            result.add(item);
        }
        return result;
    }

    public static String getErrorMsg(String modelNum, String dimNum, Set<String> numbers) {
        if (numbers != null) {
            numbers.removeIf(Objects::isNull);
        }
        if (CollectionUtils.isEmpty(numbers)) {
            return "";
        }
        HashSet<String> notExistNumber = new HashSet<String>(16);
        HashSet<String> errorNumber = new HashSet<String>(16);
        for (String number : numbers) {
            boolean isaccountoffset;
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)number);
            if (IDNumberTreeNode.NotFoundTreeNode == node) {
                if (PresetConstant.MYCOMPANY_DIM.equals(dimNum) || PresetConstant.INTERNALCOMPANY_DIM.equals(dimNum)) {
                    SystemVarsEnum dimVarsByNumber = SystemVarsEnum.getDimVarsByNumber((String)number);
                    if (!Objects.nonNull(dimVarsByNumber)) continue;
                    notExistNumber.add(number);
                    continue;
                }
                notExistNumber.add(number);
                continue;
            }
            if (!node.isLeaf()) {
                errorNumber.add(number);
                continue;
            }
            if (!PresetConstant.ACCOUNT_DIM.equals(dimNum) || SystemVarsEnum.CURRENT.getNumber().equalsIgnoreCase(number) || (isaccountoffset = node.getProperty("accountpart.isaccountoffset") == null ? false : (Boolean)node.getProperty("accountpart.isaccountoffset"))) continue;
            errorNumber.add(number);
        }
        if (!CollectionUtils.isEmpty(notExistNumber)) {
            return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6[%1$s]\u4e2d\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a%2$s\u7684\u6210\u5458\u3002", (String)"InvTemplateHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), dimNum, notExistNumber);
        }
        if (!CollectionUtils.isEmpty(errorNumber)) {
            if (PresetConstant.ACCOUNT_DIM.equals(dimNum)) {
                return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6[%1$s]\u4e2d\u7684\u6210\u5458[%2$s]\u4e0d\u662f\u660e\u7ec6\u4e14\u62b5\u9500\u6210\u5458\u3002", (String)"InvTmplImportExportHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), dimNum, String.join((CharSequence)",", errorNumber));
            }
            return String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6[%1$s]\u4e2d\u7684\u6210\u5458[%2$s]\u4e0d\u662f\u660e\u7ec6\u6210\u5458\u3002", (String)"InvTmplImportExportHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), dimNum, String.join((CharSequence)",", errorNumber));
        }
        return null;
    }

    public static String getNotExistNumber(String modelNum, String dimNum, Collection<String> numbers) {
        if (numbers != null) {
            numbers.removeIf(Objects::isNull);
        }
        if (numbers == null || numbers.isEmpty()) {
            return "";
        }
        HashSet<String> notExistNumber = new HashSet<String>(16);
        for (String number : numbers) {
            if (IDNumberTreeNode.NotFoundTreeNode != MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)number)) continue;
            notExistNumber.add(number);
        }
        return String.join((CharSequence)",", notExistNumber);
    }

    public static Long getExtModelIdByNum(Long modelId, String extmodelNumber) {
        return (Long)ThreadCache.get((Object)("ExtModelId-" + extmodelNumber + modelId), () -> {
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)extmodelNumber)});
            if (dyn != null) {
                return dyn.getLong("id");
            }
            return null;
        });
    }

    public static Long getMemberId(Long modelId, String dimNum, String number) {
        SystemVarsEnum dimVarsByNumber;
        if (StringUtils.isBlank((CharSequence)dimNum) || StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        if ((PresetConstant.MYCOMPANY_DIM.equals(dimNum) || PresetConstant.INTERNALCOMPANY_DIM.equals(dimNum)) && Objects.nonNull(dimVarsByNumber = SystemVarsEnum.getDimVarsByNumber((String)number))) {
            return LongUtil.toLong((Object)dimVarsByNumber.getId());
        }
        IDNumberTreeNode node = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)dimNum, (String)number);
        if (IDNumberTreeNode.NotFoundTreeNode == node) {
            return null;
        }
        return node.getId();
    }

    public static Map<String, String> getDimFieldMapped(Long modelId) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, fieldmapped", (QFilter[])new QFBuilder().add("model", "=", (Object)modelId).toArray(), (String)"dseq");
        return dims.stream().collect(Collectors.toMap(k -> StringUtils.isBlank((CharSequence)k.getString("fieldmapped")) ? k.getString("number") : k.getString("fieldmapped"), v -> v.getString("number"), (e1, e2) -> e1));
    }

    public static Object getOrDeafult(boolean isRequest, Object value, Object defaultValue) {
        if (isRequest && (value == null || StringUtils.isBlank((CharSequence)value.toString()))) {
            return defaultValue;
        }
        return value;
    }
}

