/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate.filterchain;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperFilterParam;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;

public class PaperTmplChainFilter {
    private PaperFilterParam param;
    private boolean isHaveAddFilter = false;
    private List<AbstractPaperFilter> filterList = new ArrayList<AbstractPaperFilter>();

    public Set<Long> doFilter(Set<Long> filterTmpIds) {
        if (this.param.isTmpIdsEmptyToAll() && CollectionUtils.isEmpty(filterTmpIds)) {
            filterTmpIds = this.getTmplIds();
        }
        if (!this.isHaveAddFilter && CollectionUtils.isEmpty(filterTmpIds)) {
            return filterTmpIds;
        }
        for (AbstractPaperFilter filter : this.filterList) {
            if (this.isHaveAddFilter && !filter.isAddFilter() && CollectionUtils.isEmpty(filterTmpIds)) continue;
            filterTmpIds = filter.doFilter(filterTmpIds);
            if (this.isHaveAddFilter || !CollectionUtils.isEmpty(filterTmpIds)) continue;
            return filterTmpIds;
        }
        return filterTmpIds;
    }

    public PaperTmplChainFilter addFilter(AbstractPaperFilter filter) {
        filter.setCommonParam(this.param);
        if (!this.isHaveAddFilter() && filter.isAddFilter()) {
            this.isHaveAddFilter = true;
        }
        this.filterList.add(filter);
        return this;
    }

    public void clearFilter() {
        this.filterList.clear();
    }

    public PaperTmplChainFilter(Long modelId, PaperTemplateTypeEnum type) {
        this.param = new PaperFilterParam(modelId, type);
    }

    public PaperTmplChainFilter(Long modelId, PaperTemplateTypeEnum type, boolean tmpIdsEmptyToAll) {
        this.param = new PaperFilterParam(modelId, type, tmpIdsEmptyToAll);
    }

    private Set<Long> getTmplIds() {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.param.getModelId());
        qf.and(new QFilter("templatecatalog", "in", PaperTemplateHelper.findTmpCatalogIds(this.param.getModelId(), this.param.getType())));
        return QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id", (QFilter[])qf.toArray()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    public boolean isHaveAddFilter() {
        return this.isHaveAddFilter;
    }
}

