/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate.filterchain.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.innertrade.report.IntrReportHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.common.enums.innertrade.IntrRptGenTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class IntrGenTypeFilter
extends AbstractPaperFilter {
    private Long orgId;
    private Long sceneId;
    private Long yearId;
    private Long periodId;
    private Long currencyId;
    private IntrRptGenTypeEnum genType;

    public IntrGenTypeFilter(Long orgId, Long sceneId, Long yearId, Long periodId, Long currencyId, IntrRptGenTypeEnum genType) {
        this.orgId = orgId;
        this.sceneId = sceneId;
        this.yearId = yearId;
        this.periodId = periodId;
        this.currencyId = currencyId;
        this.genType = genType;
    }

    @Override
    public Set<Long> doFilter(Set<Long> tmplIds) {
        Long realCurrencyId = (Long)IntrReportHelper.getRealCurrencyId((Long)this.getCommonParam().getModelId(), (Long)this.orgId, (Long)this.currencyId).p1;
        QFBuilder qf = new QFBuilder();
        qf.add("papertemplate", "in", tmplIds);
        qf.add("entity", "=", (Object)this.orgId);
        qf.add("scenario", "=", (Object)this.sceneId);
        qf.add("year", "=", (Object)this.yearId);
        qf.add("period", "=", (Object)this.periodId);
        qf.add("currency", "=", (Object)realCurrencyId);
        qf.add("gentype", "=", (Object)this.genType.value);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_intrreportentity", (String)"id, papertemplate", (QFilter[])qf.toArray());
        if (!CollectionUtil.isEmpty((Collection)doc)) {
            return doc.stream().map(e -> e.getLong("papertemplate")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(1);
    }
}

