/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate.filterchain.filter;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperFilterParam;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.util.QFBuilder;

public class IntrRecordAddition
extends AbstractPaperFilter {
    private Set<Long> originTmplIds;
    private Set<Long> orgIds;
    private Long sceneId;
    private Set<Long> yearIds;
    private Set<Long> periodIds;

    public IntrRecordAddition(Set<Long> originTmplIds, Set<Long> orgIds, Long sceneId, Long yearId, Long periodId) {
        if (originTmplIds != null) {
            this.originTmplIds = new HashSet<Long>(originTmplIds);
        }
        this.orgIds = QueryMemberDetailsHelper.change2BaseMember(orgIds);
        this.sceneId = sceneId;
        this.yearIds = Sets.newHashSet((Object[])new Long[]{yearId});
        this.periodIds = Sets.newHashSet((Object[])new Long[]{periodId});
    }

    public IntrRecordAddition(Set<Long> originTmplIds, Long sceneId) {
        if (originTmplIds != null) {
            this.originTmplIds = new HashSet<Long>(originTmplIds);
        }
        this.sceneId = sceneId;
    }

    @Override
    public Set<Long> doFilter(Set<Long> tmplIds) {
        PaperFilterParam commonParam = this.getCommonParam();
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)commonParam.getModelId());
        qf.add("scenario", "=", (Object)this.getSceneId());
        if (!CollectionUtils.isEmpty(this.getOriginTmplIds())) {
            qf.add("papertemplate", "in", this.getOriginTmplIds());
        }
        if (!CollectionUtils.isEmpty(this.getYearIds())) {
            qf.add("year", "in", this.getYearIds());
        }
        if (!CollectionUtils.isEmpty(this.getPeriodIds())) {
            qf.add("period", "in", this.getPeriodIds());
        }
        if (!CollectionUtils.isEmpty(this.getOrgIds())) {
            qf.add("entity", "in", this.getOrgIds());
        }
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_intrreportentity", (String)"id, entity, papertemplate", (QFilter[])qf.toArray());
        for (DynamicObject dyn : reports) {
            tmplIds.add(dyn.getLong("papertemplate"));
        }
        return tmplIds;
    }

    @Override
    public boolean isAddFilter() {
        return true;
    }

    public Set<Long> getOrgIds() {
        return this.orgIds;
    }

    public Long getSceneId() {
        return this.sceneId;
    }

    public Set<Long> getYearIds() {
        return this.yearIds;
    }

    public Set<Long> getPeriodIds() {
        return this.periodIds;
    }

    public Set<Long> getOriginTmplIds() {
        return this.originTmplIds;
    }
}

