/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.papertemplate.filterchain.filter;

import com.google.common.collect.ArrayListMultimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.papertemplate.filterchain.AbstractPaperFilter;
import kd.fi.bcm.business.papertemplate.filterchain.PaperFilterParam;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.util.QFBuilder;

public class ReadOrWriteAuthFilter
extends AbstractPaperFilter {
    private Long userId;

    public ReadOrWriteAuthFilter(Long userId) {
        this.userId = userId;
    }

    @Override
    public Set<Long> doFilter(Set<Long> tmplIds) {
        PaperFilterParam param = this.getCommonParam();
        if (PermissionServiceImpl.getInstance(param.getModelId()).isAdmin()) {
            return tmplIds;
        }
        ArrayListMultimap<String, Long> catalogPerm = PermClassEntityHelper.getPermissionMapBatch("bcm_papertemplatecatalog", String.valueOf(this.getCommonParam().getModelId()), String.valueOf(this.userId));
        QFBuilder qf = new QFBuilder();
        qf.add(new QFilter("model", "=", (Object)this.getCommonParam().getModelId()));
        qf.add(new QFilter("id", "in", tmplIds));
        qf.add(new QFilter("templatecatalog", "not in", (Object)catalogPerm.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue())));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_papertemplate", (String)"id", (QFilter[])qf.toArray());
        if (doc == null || doc.isEmpty()) {
            return new HashSet<Long>(16);
        }
        List<Long> ids = doc.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        ArrayListMultimap<String, Long> tmplPerm = PermClassEntityHelper.getPermissionMapBatch("bcm_papertemplate", String.valueOf(this.getCommonParam().getModelId()), String.valueOf(this.userId), ids);
        List noPermIds = tmplPerm.get((Object)PermClassEntityHelper.PermClassEnum.NOPERM.getValue());
        return ids.stream().filter(e -> !noPermIds.contains(e)).collect(Collectors.toSet());
    }
}

